/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.realbench.logic;

import com.nomiceu.realbench.logic.TileEntityWorkbench;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;

public class WorkbenchRenderer
extends TileEntitySpecialRenderer<TileEntityWorkbench> {
    Map<TileEntityWorkbench, RenderingState> states = new WeakHashMap<TileEntityWorkbench, RenderingState>();
    static final int ANIMATION_DURATION = 1000;

    public void render(@NotNull TileEntityWorkbench tile, double xOffset, double yOffset, double zOffset, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a((TileEntity)tile, xOffset, yOffset, zOffset, partialTicks, destroyStage, alpha);
        for (int i = 0; i < tile.getCraftMatrixSafe().size(); ++i) {
            Block block;
            Item item;
            float shift;
            ItemStack itemStack = tile.getCraftMatrixSafe().get(i);
            if (itemStack.func_190926_b()) continue;
            GlStateManager.func_179140_f();
            RenderingState state = this.states.computeIfAbsent(tile, k -> new RenderingState());
            double playerAngle = (Math.atan2(xOffset + 0.5, zOffset + 0.5) + 3.9269908169872414) % (Math.PI * 2);
            byte sector = (byte)(playerAngle * 2.0 / Math.PI);
            long time = System.currentTimeMillis();
            if (state.sector != sector) {
                state.animating = true;
                state.animationAngleStart = state.currentAngle;
                float delta1 = (float)sector * 90.0f - state.currentAngle;
                float abs1 = Math.abs(delta1);
                float delta2 = delta1 + 360.0f;
                shift = Math.abs(delta2);
                float delta3 = delta1 - 360.0f;
                float abs3 = Math.abs(delta3);
                state.animationAngleEnd = abs3 < abs1 && abs3 < shift ? delta3 + state.currentAngle : (shift < abs1 && shift < abs3 ? delta2 + state.currentAngle : delta1 + state.currentAngle);
                state.startTime = time;
                state.sector = sector;
            }
            if (state.animating) {
                if (time >= state.startTime + 1000L) {
                    state.animating = false;
                    state.currentAngle = (state.animationAngleEnd + 360.0f) % 360.0f;
                } else {
                    state.currentAngle = (WorkbenchRenderer.easeOutQuad(time - state.startTime, state.animationAngleStart, state.animationAngleEnd - state.animationAngleStart) + 360.0f) % 360.0f;
                }
            }
            if ((item = itemStack.func_77973_b()) instanceof ItemBlock) {
                ItemBlock itemBlock = (ItemBlock)item;
                block = itemBlock.func_179223_d();
            } else if (item instanceof ItemBlockSpecial) {
                ItemBlockSpecial itemSpecial = (ItemBlockSpecial)item;
                block = itemSpecial.getBlock();
            } else {
                block = null;
            }
            boolean normalBlock = block != null && block.func_176223_P().func_185904_a().func_76220_a();
            shift = (float)Math.abs((time + (long)i * 1000L) % 5000L - 2500L) / 200000.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(xOffset + 0.5), (double)(yOffset + (double)shift), (double)(zOffset + 0.5));
            GlStateManager.func_179114_b((float)state.currentAngle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)((double)(i % 3) * 3.0 / 16.0 + 0.3125 - 0.5), (double)1.09375, (double)((double)(i / 3) * 3.0 / 16.0 + 0.3125 - 0.5));
            if (!normalBlock) {
                GlStateManager.func_179114_b((float)(-this.field_147501_a.field_147563_i), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
            float lastBrightnessX = OpenGlHelper.lastBrightnessX;
            float lastBrightnessY = OpenGlHelper.lastBrightnessY;
            WorkbenchRenderer.setLightingToPos((IBlockAccess)tile.func_145831_w(), tile.func_174877_v().func_177984_a());
            Minecraft.func_71410_x().func_175599_af().func_181564_a(itemStack, ItemCameraTransforms.TransformType.FIXED);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
        }
    }

    private static float easeOutQuad(long t, float b, float c) {
        float z = (float)t / 1000.0f;
        return -c * z * (z - 2.0f) + b;
    }

    public static void setLightingToPos(IBlockAccess world, BlockPos pos) {
        int actualLight = world.func_175626_b(pos, 0);
        float lightmapXCoord = actualLight & 0xFFFF;
        float lightmapYCoord = actualLight >> 16;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapXCoord, (float)lightmapYCoord);
    }

    static class RenderingState {
        byte sector;
        float currentAngle;
        boolean animating;
        float animationAngleStart;
        float animationAngleEnd;
        long startTime;

        RenderingState() {
        }
    }
}

