/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.realbench.mixin;

import com.nomiceu.realbench.logic.ContainerWorkbenchLogic;
import com.nomiceu.realbench.logic.SlotCraftingResult;
import com.nomiceu.realbench.logic.TileContainerWorkbench;
import com.nomiceu.realbench.logic.TileEntityWorkbench;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ContainerWorkbench.class})
public abstract class ContainerWorkbenchMixin
extends Container
implements TileContainerWorkbench {
    @Shadow
    public InventoryCrafting field_75162_e;
    @Shadow
    public InventoryCraftResult field_75160_f;
    @Shadow
    @Final
    private World field_75161_g;
    @Shadow
    @Final
    private EntityPlayer field_192390_i;
    @Unique
    @Nullable
    public TileEntityWorkbench tile;
    @Unique
    public List<ItemStack> oldMatrix;

    @Inject(method={"<init>(Lnet/minecraft/entity/player/InventoryPlayer;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="RETURN")})
    public void init(InventoryPlayer playerInventory, World worldIn, BlockPos posIn, CallbackInfo ci) {
        this.tile = ContainerWorkbenchLogic.getTile((ContainerWorkbench)this, worldIn, posIn);
        this.oldMatrix = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        ContainerWorkbenchLogic.init((ContainerWorkbench)this, playerInventory.field_70458_d, (container, playerIn) -> this.func_75146_a((Slot)new SlotCraftingResult((EntityPlayer)playerIn, (ContainerWorkbench)container, this.field_75162_e, this.field_75160_f, 0, 124, 35)));
    }

    @Inject(method={"onContainerClosed(Lnet/minecraft/entity/player/EntityPlayer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onContainerClosed(EntityPlayer player, CallbackInfo ci) {
        if (this.tile == null) {
            return;
        }
        super.func_75134_a(player);
        this.tile.removeContainer((ContainerWorkbench)this);
        ci.cancel();
    }

    @Override
    @Unique
    @Nullable
    public TileEntityWorkbench getTile() {
        return this.tile;
    }

    @Override
    @Unique
    public void updateResult() {
        this.func_192389_a(this.field_75161_g, this.field_192390_i, this.field_75162_e, this.field_75160_f);
        this.func_75142_b();
    }

    @Override
    @Unique
    public List<ItemStack> getOldMatrix() {
        return this.oldMatrix;
    }

    @Override
    public void updateOldMatrix(List<ItemStack> matrix) {
        this.oldMatrix = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < matrix.size(); ++i) {
            this.oldMatrix.set(i, matrix.get(i).func_77946_l());
        }
    }

    @Override
    @Unique
    public void addSlot(Slot slot) {
        this.func_75146_a(slot);
    }

    @Override
    @Unique
    public EntityPlayer getPlayer() {
        return this.field_192390_i;
    }

    @Unique
    public boolean equals(Object obj) {
        if (!(obj instanceof ContainerWorkbench)) {
            return false;
        }
        ContainerWorkbench container = (ContainerWorkbench)obj;
        if (this.field_192390_i == null || ((TileContainerWorkbench)container).getPlayer() == null) {
            return super.equals(obj);
        }
        return this.field_192390_i.func_110124_au() == ((TileContainerWorkbench)container).getPlayer().func_110124_au();
    }
}

