/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item;

import cofh.core.item.IEnchantableItem;
import cofh.redstoneflux.api.IEnergyContainerItem;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thundr.redstonerepository.api.IArmorEnderium;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.capability.CapabilityProviderEnergy;
import tonius.simplyjetpacks.capability.EnergyConversionStorage;
import tonius.simplyjetpacks.client.model.PackModelType;
import tonius.simplyjetpacks.client.util.RenderUtils;
import tonius.simplyjetpacks.config.Config;
import tonius.simplyjetpacks.handler.LivingTickHandler;
import tonius.simplyjetpacks.handler.SyncHandler;
import tonius.simplyjetpacks.item.IHUDInfoProvider;
import tonius.simplyjetpacks.item.Jetpack;
import tonius.simplyjetpacks.setup.FuelType;
import tonius.simplyjetpacks.setup.ModEnchantments;
import tonius.simplyjetpacks.setup.ModItems;
import tonius.simplyjetpacks.setup.ParticleType;
import tonius.simplyjetpacks.util.EquipmentSlotHelper;
import tonius.simplyjetpacks.util.ItemHelper;
import tonius.simplyjetpacks.util.NBTHelper;
import tonius.simplyjetpacks.util.SJStringHelper;
import tonius.simplyjetpacks.util.StackUtil;

@Optional.InterfaceList(value={@Optional.Interface(iface="thundr.redstonerepository.api.IArmorEnderium", modid="redstonerepository"), @Optional.Interface(iface="cofh.core.item.IEnchantableItem", modid="cofhcore")})
public class ItemJetpack
extends ItemArmor
implements ISpecialArmor,
IEnergyContainerItem,
IHUDInfoProvider,
IArmorEnderium,
IEnchantableItem {
    public static final String TAG_ENERGY = "Energy";
    public static final String TAG_ON = "PackOn";
    public static final String TAG_HOVERMODE_ON = "JetpackHoverModeOn";
    public static final String TAG_EHOVER_ON = "JetpackEHoverOn";
    public static final String TAG_CHARGER_ON = "JetpackChargerOn";
    protected static final UUID ARMOR_MODIFIER = UUID.fromString("0819e549-a0f9-49d3-a199-53662799c67b");
    public String name;
    public boolean showTier = true;
    public boolean hasFuelIndicator = true;
    public boolean hasStateIndicators = true;
    public FuelType fuelType = FuelType.ENERGY;
    public boolean isFluxBased = false;
    private final int numItems;

    public ItemJetpack(String name) {
        super(EnumHelper.addArmorMaterial((String)"JETPACK_SJ", (String)"jetpack", (int)0, (int[])new int[]{0, 0, 0, 0}, (int)0, (SoundEvent)SoundEvents.field_187719_p, (float)0.0f), 2, EntityEquipmentSlot.CHEST);
        this.name = name;
        this.func_77655_b("simplyjetpacks." + name);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(SimplyJetpacks.creativeTab);
        this.setRegistryName(name);
        this.numItems = Jetpack.values().length;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTabs, NonNullList<ItemStack> List2) {
        if (this.func_194125_a(creativeTabs)) {
            for (Jetpack pack : Jetpack.PACKS_SJ) {
                ItemHelper.addJetpacks(pack, List2);
            }
            if (ModItems.integrateEIO) {
                for (Jetpack pack : Jetpack.PACKS_EIO) {
                    ItemHelper.addJetpacks(pack, List2);
                }
            }
            if (ModItems.integrateTE) {
                for (Jetpack pack : Jetpack.PACKS_TE) {
                    ItemHelper.addJetpacks(pack, List2);
                }
            }
            if (ModItems.integrateRR) {
                for (Jetpack pack : Jetpack.PACKS_RR) {
                    ItemHelper.addJetpacks(pack, List2);
                }
            }
            if (ModItems.integrateVanilla) {
                for (Jetpack pack : Jetpack.PACKS_VANILLA) {
                    ItemStack stack = new ItemStack((Item)this, 1, pack.ordinal());
                    List2.add((Object)stack);
                }
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        this.flyUser(player, stack, this, false);
        if (this.isJetplate(stack) && this.isChargerOn(stack)) {
            this.chargeInventory((EntityLivingBase)player, stack, this);
        }
    }

    public void toggleState(boolean on, ItemStack stack, String type, String tag, EntityPlayer player, boolean showState) {
        NBTHelper.setBoolean(stack, tag, !on);
        if (player != null && showState) {
            type = type != null && !type.equals("") ? "chat." + this.name + "." + type : "chat." + this.name + ".on";
            ITextComponent state = SJStringHelper.localizeNew(on ? "chat.disabled" : "chat.enabled", new Object[0]);
            if (on) {
                state.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
            } else {
                state.func_150255_a(new Style().func_150238_a(TextFormatting.GREEN));
            }
            ITextComponent msg = SJStringHelper.localizeNew(type, state);
            player.func_146105_b(msg, true);
        }
    }

    public boolean isJetplate(ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        return Jetpack.values()[i].getTier() == 5;
    }

    public boolean isChargerOn(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_CHARGER_ON, true);
    }

    public void setParticleType(ItemStack stack, ParticleType particle) {
        NBTHelper.setInt(stack, "JetpackParticleType", particle.ordinal());
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (Jetpack.values()[i].getRarity() != null) {
            return Jetpack.values()[i].getRarity();
        }
        return super.func_77613_e(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (!Jetpack.values()[i].usesFuel) {
            return false;
        }
        return this.hasFuelIndicator;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double stored = this.getMaxFuelStored(stack) - this.getFuelStored(stack) + 1;
        double max = this.getMaxFuelStored(stack) + 1;
        return stored / max;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        Jetpack jetpack = Jetpack.values()[i];
        return jetpack == Jetpack.JETPLATE_TE_5_ENDERIUM ? 1333581 : super.getRGBDurabilityForDisplay(stack);
    }

    public String func_77667_c(ItemStack itemStack) {
        int i = MathHelper.func_76125_a((int)itemStack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        return Jetpack.values()[i].unlocalisedName;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        this.information(stack, this, tooltip);
        if (SJStringHelper.canShowDetails()) {
            this.shiftInformation(stack, tooltip);
        } else {
            tooltip.add(SJStringHelper.getShiftText());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void information(ItemStack stack, ItemJetpack item, List list) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (this.showTier) {
            list.add(SJStringHelper.getTierText(Jetpack.values()[i].getTier()));
        }
        list.add(SJStringHelper.getFuelText(this.fuelType, item.getFuelStored(stack), item.getMaxFuelStored(stack), !Jetpack.values()[i].usesFuel));
    }

    @SideOnly(value=Side.CLIENT)
    public void shiftInformation(ItemStack stack, List list) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        list.add(SJStringHelper.getStateText(this.isOn(stack)));
        list.add(SJStringHelper.getHoverModeText(this.isHoverModeOn(stack)));
        if (Jetpack.values()[i].getFuelUsage() > 0) {
            if (Jetpack.values()[i].getBaseName().contains("enderium")) {
                list.add(TextFormatting.BLUE + "Supercooled! Fuel Usage Rate " + Config.gelidEnderiumFuelUsageBonus + "%");
            }
            list.add(SJStringHelper.getFuelUsageText(this.fuelType, Jetpack.values()[i].getFuelUsage()));
        }
        list.add(SJStringHelper.getParticlesText(Jetpack.values()[i].getParticleType(stack)));
        SJStringHelper.addDescriptionLines(list, "jetpack", TextFormatting.GREEN.toString());
    }

    public boolean isOn(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_ON, true);
    }

    public int getFuelStored(ItemStack stack) {
        return this.getEnergyStored(stack);
    }

    public int getMaxFuelStored(ItemStack stack) {
        return this.getMaxEnergyStored(stack);
    }

    protected int getFuelUsage(ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        int usage = Jetpack.values()[i].getFuelUsage();
        if (Jetpack.values()[i].getBaseName().contains("enderium")) {
            return (int)Math.round((double)usage * 0.8);
        }
        return usage;
    }

    public int addFuel(ItemStack stack, int maxAdd, boolean simulate) {
        return this.receiveEnergy(stack, maxAdd, simulate);
    }

    public int useFuel(ItemStack stack, int maxUse, boolean simulate) {
        return this.extractEnergy(stack, maxUse, simulate);
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int i = MathHelper.func_76125_a((int)container.func_77952_i(), (int)0, (int)(this.numItems - 1));
        int energy = this.getEnergyStored(container);
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - energy, Math.min(maxReceive, Jetpack.values()[i].getFuelPerTickIn()));
        if (!Jetpack.values()[i].usesFuel) {
            energyReceived = this.getMaxEnergyStored(container);
        }
        if (!simulate) {
            NBTHelper.setInt(container, TAG_ENERGY, energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int i = MathHelper.func_76125_a((int)container.func_77952_i(), (int)0, (int)(this.numItems - 1));
        int energy = this.getEnergyStored(container);
        int energyExtracted = Math.min(energy, Math.min(maxExtract, Jetpack.values()[i].getFuelPerTickOut() == 0 ? Jetpack.values()[i].getFuelUsage() : Jetpack.values()[i].getFuelPerTickOut()));
        if (!simulate) {
            NBTHelper.setInt(container, TAG_ENERGY, energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        return NBTHelper.getInt(container, TAG_ENERGY, 0);
    }

    public int getMaxEnergyStored(ItemStack container) {
        int i = MathHelper.func_76125_a((int)container.func_77952_i(), (int)0, (int)(this.numItems - 1));
        int id = StackUtil.getEnchantmentIdByName("cofhcore:holding", container);
        if (id != -1) {
            return Jetpack.values()[i].getFuelCapacity() + Jetpack.values()[i].getFuelCapacity() * EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_185262_c((int)id), (ItemStack)container) / 2;
        }
        return Jetpack.values()[i].getFuelCapacity();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHUDInfo(List<String> list, ItemStack stack, boolean showFuel, boolean showState) {
        if (showFuel && this.hasFuelIndicator) {
            list.add(this.getHUDFuelInfo(stack, this));
        }
        if (showState && this.hasStateIndicators) {
            list.add(this.getHUDStatesInfo(stack));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getHUDFuelInfo(ItemStack stack, ItemJetpack item) {
        int fuel = item.getFuelStored(stack);
        int maxFuel = item.getMaxFuelStored(stack);
        int percent = (int)Math.ceil((double)fuel / (double)maxFuel * 100.0);
        return SJStringHelper.getHUDFuelText(this.name, percent, this.fuelType, fuel);
    }

    public boolean isHoverModeOn(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_HOVERMODE_ON, false);
    }

    public boolean isEHoverModeOn(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_EHOVER_ON, true);
    }

    public void doEHover(ItemStack armor, EntityLivingBase user) {
        NBTHelper.setBoolean(armor, TAG_ON, true);
        NBTHelper.setBoolean(armor, TAG_HOVERMODE_ON, true);
        if (user instanceof EntityPlayer) {
            ITextComponent msg = SJStringHelper.localizeNew("chat.itemJetpack.emergencyHoverMode.msg", new Object[0]);
            msg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
            ((EntityPlayer)user).func_146105_b(msg, true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getHUDStatesInfo(ItemStack stack) {
        Boolean engine = this.isOn(stack);
        Boolean hover = this.isHoverModeOn(stack);
        Boolean charger = this.isChargerOn(stack);
        if (this.isJetplate(stack)) {
            return SJStringHelper.getHUDStateText(engine, hover, charger);
        }
        return SJStringHelper.getHUDStateText(engine, hover, null);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        int i = MathHelper.func_76125_a((int)armor.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (Jetpack.values()[i].getIsArmored() && !source.func_76363_c()) {
            int maxAbsorbed;
            int energyPerDamage = this.getFuelPerDamage(armor);
            int n = maxAbsorbed = energyPerDamage > 0 ? 25 * (this.getFuelStored(armor) / energyPerDamage) : 0;
            if (this.getFuelStored(armor) < energyPerDamage) {
                return new ISpecialArmor.ArmorProperties(0, 0.65 * ((double)Jetpack.values()[i].getArmorReduction() / 20.0), Integer.MAX_VALUE);
            }
            if (this.isFluxBased && source.field_76373_n.equals("flux")) {
                return new ISpecialArmor.ArmorProperties(0, 0.5, Integer.MAX_VALUE);
            }
            return new ISpecialArmor.ArmorProperties(0, 0.85 * ((double)Jetpack.values()[i].getArmorReduction() / 20.0), maxAbsorbed);
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        return 0;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        Multimap multimap = super.func_111205_h(slot);
        if (!Jetpack.values()[i].getIsArmored()) {
            multimap.clear();
            return multimap;
        }
        if (slot == EntityEquipmentSlot.CHEST) {
            multimap.clear();
            multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIER, "Armor modifier", (double)Jetpack.values()[i].getArmorReduction(), 0));
        }
        return multimap;
    }

    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelBiped model;
        int i = MathHelper.func_76125_a((int)itemStack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (Config.enableArmor3DModels && (model = RenderUtils.getArmorModel(Jetpack.values()[i], entityLiving)) != null) {
            return model;
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        String flat = Config.enableArmor3DModels || Jetpack.values()[i].armorModel == PackModelType.FLAT ? "" : ".flat";
        return "simplyjetpacks:textures/armor/" + Jetpack.values()[i].getBaseName() + flat + ".png";
    }

    public void damageArmor(EntityLivingBase entity, ItemStack armor, DamageSource source, int damage, int slot) {
        int i = MathHelper.func_76125_a((int)armor.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (Jetpack.values()[i].getIsArmored() && Jetpack.values()[i].usesFuel) {
            if (this.fuelType == FuelType.ENERGY && this.isFluxBased && source.field_76373_n.equals("flux")) {
                this.addFuel(armor, damage * (source.func_76364_f() == null ? Jetpack.values()[i].getArmorFuelPerHit() / 2 : this.getFuelPerDamage(armor)), false);
            } else {
                this.useFuel(armor, damage * this.getFuelPerDamage(armor), false);
            }
        }
    }

    protected int getFuelPerDamage(ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (ModEnchantments.fuelEffeciency == null) {
            return Jetpack.values()[i].getArmorFuelPerHit();
        }
        int fuelEfficiencyLevel = MathHelper.func_76125_a((int)EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.fuelEffeciency, (ItemStack)stack), (int)0, (int)4);
        return (int)Math.round((double)(Jetpack.values()[i].getArmorFuelPerHit() * (5 - fuelEfficiencyLevel)) / 5.0);
    }

    public void flyUser(EntityPlayer user, ItemStack stack, ItemJetpack item, boolean force) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        Item chestItem = StackUtil.getItem(stack);
        ItemJetpack jetpack = (ItemJetpack)chestItem;
        if (jetpack.isOn(stack)) {
            boolean hoverMode = jetpack.isHoverModeOn(stack);
            double hoverSpeed = Config.invertHoverSneakingBehavior == SyncHandler.isDescendKeyDown((EntityLivingBase)user) ? Jetpack.values()[i].speedVerticalHoverSlow : Jetpack.values()[i].speedVerticalHover;
            boolean flyKeyDown = force || SyncHandler.isFlyKeyDown((EntityLivingBase)user);
            boolean descendKeyDown = SyncHandler.isDescendKeyDown((EntityLivingBase)user);
            double currentAccel = Jetpack.values()[i].accelVertical * (user.field_70181_x < 0.3 ? 2.5 : 1.0);
            double currentSpeedVertical = Jetpack.values()[i].speedVertical * (user.func_70090_H() ? 0.4 : 1.0);
            if (flyKeyDown || hoverMode && !user.field_70122_E) {
                if (Jetpack.values()[i].usesFuel) {
                    item.useFuel(stack, (int)(user.func_70051_ag() ? Math.round((double)this.getFuelUsage(stack) * Jetpack.values()[i].sprintFuelModifier) : (long)this.getFuelUsage(stack)), false);
                }
                if (item.getFuelStored(stack) > 0) {
                    user.field_70181_x = flyKeyDown ? (!hoverMode ? Math.min(user.field_70181_x + currentAccel, currentSpeedVertical) : (descendKeyDown ? Math.min(user.field_70181_x + currentAccel, -Jetpack.values()[i].speedVerticalHoverSlow) : Math.min(user.field_70181_x + currentAccel, Jetpack.values()[i].speedVerticalHover))) : Math.min(user.field_70181_x + currentAccel, -hoverSpeed);
                    float speedSideways = (float)(user.func_70093_af() ? Jetpack.values()[i].speedSideways * 0.5 : Jetpack.values()[i].speedSideways);
                    float speedForward = (float)(user.func_70051_ag() ? (double)speedSideways * Jetpack.values()[i].sprintSpeedModifier : (double)speedSideways);
                    if (SyncHandler.isForwardKeyDown((EntityLivingBase)user)) {
                        user.func_191958_b(0.0f, 0.0f, speedForward, speedForward);
                    }
                    if (SyncHandler.isBackwardKeyDown((EntityLivingBase)user)) {
                        user.func_191958_b(0.0f, 0.0f, -speedSideways, speedSideways * 0.8f);
                    }
                    if (SyncHandler.isLeftKeyDown((EntityLivingBase)user)) {
                        user.func_191958_b(speedSideways, 0.0f, 0.0f, speedSideways);
                    }
                    if (SyncHandler.isRightKeyDown((EntityLivingBase)user)) {
                        user.func_191958_b(-speedSideways, 0.0f, 0.0f, speedSideways);
                    }
                    if (!user.field_70170_p.field_72995_K) {
                        user.field_70143_R = 0.0f;
                        if (user instanceof EntityPlayerMP) {
                            try {
                                LivingTickHandler.floatingTickCount.setInt(((EntityPlayerMP)user).field_71135_a, 0);
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
        if (!(user.field_70170_p.field_72995_K || !Jetpack.values()[i].emergencyHoverMode || !this.isEHoverModeOn(stack) || item.getEnergyStored(stack) <= 0 || this.isHoverModeOn(stack) && this.isOn(stack))) {
            if (user.field_70163_u < -5.0) {
                this.doEHover(stack, (EntityLivingBase)user);
            } else if (!user.field_71075_bZ.field_75098_d && user.field_70143_R - 1.2f >= user.func_110143_aJ()) {
                for (int j = 0; j <= 16; ++j) {
                    int z;
                    int y;
                    int x = Math.round((float)user.field_70165_t - 0.5f);
                    if (user.field_70170_p.func_175623_d(new BlockPos(x, y = Math.round((float)user.field_70163_u) - j, z = Math.round((float)user.field_70161_v - 0.5f)))) continue;
                    this.doEHover(stack, (EntityLivingBase)user);
                    break;
                }
            }
        }
    }

    protected void chargeInventory(EntityLivingBase user, ItemStack stack, ItemJetpack item) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (this.fuelType == FuelType.ENERGY) {
            for (int j = 0; j <= 5; ++j) {
                ItemStack currentStack = user.func_184582_a(EquipmentSlotHelper.fromSlot(j));
                if (currentStack == null || currentStack == stack || this.getIEnergyStorage(currentStack) == null || !currentStack.hasCapability(CapabilityEnergy.ENERGY, null) && (!(currentStack.func_77973_b() instanceof IEnergyContainerItem) || ModItems.integrateRR && stack.func_77973_b() instanceof IArmorEnderium)) continue;
                if (Jetpack.values()[i].usesFuel) {
                    int energyToAdd = Math.min(item.useFuel(stack, Jetpack.values()[i].getFuelPerTickOut(), true), this.getIEnergyStorage(currentStack).receiveEnergy(Jetpack.values()[i].getFuelPerTickOut(), true));
                    item.useFuel(stack, energyToAdd, false);
                    this.getIEnergyStorage(currentStack).receiveEnergy(energyToAdd, false);
                    continue;
                }
                this.getIEnergyStorage(currentStack).receiveEnergy(Jetpack.values()[i].getFuelPerTickOut(), false);
            }
        }
    }

    public IEnergyStorage getIEnergyStorage(ItemStack chargeItem) {
        if (chargeItem.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return (IEnergyStorage)chargeItem.getCapability(CapabilityEnergy.ENERGY, null);
        }
        if (chargeItem.func_77973_b() instanceof IEnergyContainerItem) {
            return new EnergyConversionStorage((IEnergyContainerItem)chargeItem.func_77973_b(), chargeItem);
        }
        return null;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapabilityProviderEnergy<EnergyConversionStorage>(new EnergyConversionStorage(this, stack), CapabilityEnergy.ENERGY, null);
    }

    public void registerItemModel() {
        for (int i = 0; i < this.numItems; ++i) {
            SimplyJetpacks.proxy.registerItemRenderer((Item)this, i, Jetpack.getTypeFromMeta(i).getBaseName());
        }
    }

    @Optional.Method(modid="redstonerepository")
    public boolean isEnderiumArmor(ItemStack stack) {
        return MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1)) == 19;
    }

    @Optional.Method(modid="cofhcore")
    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantment.func_180305_b((String)"cofhcore:holding");
    }
}

