/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.mods.abyssalcraft;

import com.shinoow.abyssalcraft.api.transfer.caps.ItemTransferCapabilityProvider;
import java.util.Map;
import mod.acgaming.universaltweaks.config.UTConfigMods;
import mod.acgaming.universaltweaks.mods.abyssalcraft.worlddata.UTWorldDataCapability;
import mod.acgaming.universaltweaks.mods.abyssalcraft.worlddata.UTWorldDataCapabilityProvider;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class UTAbyssalCraftEvents {
    private static final String CHECK_ID = "universaltweaksAbyssalConfigurations";

    @SubscribeEvent
    public void attachCapabilityWorld(AttachCapabilitiesEvent<World> event) {
        if (!UTConfigMods.ABYSSALCRAFT.utOptimizedItemTransferToggle) {
            return;
        }
        event.addCapability(new ResourceLocation("universaltweaks", "WorldDataCapability"), (ICapabilityProvider)new UTWorldDataCapabilityProvider());
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        if (!UTConfigMods.ABYSSALCRAFT.utOptimizedItemTransferToggle) {
            return;
        }
        Chunk chunk = event.getChunk();
        Map<BlockPos, TileEntity> set = UTWorldDataCapability.getCap(event.getWorld()).getChunkMap(chunk);
        if (set != null && !set.isEmpty()) {
            NBTTagList tagList = new NBTTagList();
            for (BlockPos pos : set.keySet()) {
                TileEntity te = event.getWorld().func_175625_s(pos);
                if (te != null && !te.hasCapability(ItemTransferCapabilityProvider.ITEM_TRANSFER_CAP, null)) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("x", pos.func_177958_n());
                tag.func_74768_a("y", pos.func_177956_o());
                tag.func_74768_a("z", pos.func_177952_p());
                tagList.func_74742_a((NBTBase)tag);
            }
            if (!event.getChunk().func_177410_o() || tagList.func_82582_d()) {
                UTWorldDataCapability.getCap(event.getWorld()).removeChunk(event.getChunk());
                if (tagList.func_82582_d()) {
                    return;
                }
            }
            event.getData().func_74782_a(CHECK_ID, (NBTBase)tagList);
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        if (!UTConfigMods.ABYSSALCRAFT.utOptimizedItemTransferToggle) {
            return;
        }
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getData().func_74764_b(CHECK_ID)) {
            World world = event.getWorld();
            NBTTagList tagList = event.getData().func_150295_c(CHECK_ID, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
                TileEntity te = world.func_175667_e(pos) ? world.func_175625_s(pos) : null;
                UTWorldDataCapability.getCap(world).addConfigured(event.getChunk(), pos, te);
            }
        }
    }
}

