/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.MEGuiTooltipTextField;
import appeng.client.me.ClientDCInternalInv;
import appeng.client.me.SlotDisconnected;
import appeng.client.render.BlockPosHighlighter;
import appeng.container.implementations.ContainerInterfaceTerminal;
import appeng.container.slot.AppEngSlot;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.ItemStackHelper;
import appeng.helpers.PatternHelper;
import appeng.parts.reporting.PartInterfaceTerminal;
import appeng.util.BlockPosUtils;
import appeng.util.Platform;
import com.google.common.collect.HashMultimap;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Loader;
import org.lwjgl.input.Mouse;

public class GuiInterfaceTerminal
extends AEBaseGui {
    private static final int OFFSET_X = 21;
    private static final int MAGIC_HEIGHT_NUMBER = 151;
    private static final String MOLECULAR_ASSEMBLER = "molecular assembler";
    private final boolean jeiEnabled;
    private final int jeiButtonPadding;
    private final HashMap<Long, ClientDCInternalInv> byId = new HashMap();
    private final HashMultimap<String, ClientDCInternalInv> byName = HashMultimap.create();
    private final HashMap<ClientDCInternalInv, BlockPos> blockPosHashMap = new HashMap();
    private final HashMap<GuiButton, ClientDCInternalInv> guiButtonHashMap = new HashMap();
    private final Map<ClientDCInternalInv, Integer> numUpgradesMap = new HashMap<ClientDCInternalInv, Integer>();
    private final ArrayList<String> names = new ArrayList();
    private final ArrayList<Object> lines = new ArrayList();
    private final Set<Object> matchedStacks = new HashSet<Object>();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private final Map<ClientDCInternalInv, Integer> dimHashMap = new HashMap<ClientDCInternalInv, Integer>();
    private final MEGuiTooltipTextField searchFieldOutputs;
    private final MEGuiTooltipTextField searchFieldInputs;
    private final MEGuiTooltipTextField searchFieldNames;
    private final GuiImgButton guiButtonHideFull;
    private final GuiImgButton guiButtonAssemblersOnly;
    private final GuiImgButton guiButtonBrokenRecipes;
    private final GuiImgButton terminalStyleBox;
    private boolean refreshList = false;
    private boolean onlyShowWithSpace = false;
    private boolean onlyMolecularAssemblers = false;
    private boolean onlyBrokenRecipes = false;
    private int rows = 6;

    public GuiInterfaceTerminal(InventoryPlayer inventoryPlayer, PartInterfaceTerminal te) {
        super(new ContainerInterfaceTerminal(inventoryPlayer, te));
        GuiScrollbar scrollbar = new GuiScrollbar();
        this.setScrollBar(scrollbar);
        this.field_146999_f = 208;
        this.field_147000_g = 255;
        this.jeiEnabled = Loader.isModLoaded((String)"jei");
        this.jeiButtonPadding = this.jeiEnabled ? 22 : 0;
        this.searchFieldInputs = this.createTextField(86, 12, ButtonToolTips.SearchFieldInputs.getLocal());
        this.searchFieldOutputs = this.createTextField(86, 12, ButtonToolTips.SearchFieldOutputs.getLocal());
        this.searchFieldNames = this.createTextField(71, 12, ButtonToolTips.SearchFieldNames.getLocal());
        this.searchFieldNames.setFocused(true);
        this.guiButtonAssemblersOnly = new GuiImgButton(0, 0, Settings.ACTIONS, null);
        this.guiButtonHideFull = new GuiImgButton(0, 0, Settings.ACTIONS, null);
        this.guiButtonBrokenRecipes = new GuiImgButton(0, 0, Settings.ACTIONS, null);
        this.terminalStyleBox = new GuiImgButton(0, 0, Settings.TERMINAL_STYLE, null);
    }

    private MEGuiTooltipTextField createTextField(int width, int height, String tooltip) {
        MEGuiTooltipTextField textField = new MEGuiTooltipTextField(width, height, tooltip){

            @Override
            public void onTextChange(String oldText) {
                GuiInterfaceTerminal.this.refreshList();
            }
        };
        textField.setEnableBackgroundDrawing(false);
        textField.setMaxStringLength(25);
        textField.setTextColor(0xFFFFFF);
        textField.setCursorPositionZero();
        return textField;
    }

    private void setScrollBar() {
        this.getScrollBar().setTop(52).setLeft(189).setHeight(this.rows * 18 - 2);
        this.getScrollBar().setRange(0, this.lines.size() - 1, 1);
    }

    private int calculateRowsCount() {
        int maxRows = this.getMaxRows();
        int jeiPadding = this.jeiEnabled ? 40 : 0;
        int extraSpace = this.field_146295_m - 151 - jeiPadding;
        return Math.max(6, Math.min(maxRows, extraSpace / 18));
    }

    @Override
    public void func_73866_w_() {
        this.rows = this.calculateRowsCount();
        super.func_73866_w_();
        this.field_147000_g = 151 + this.rows * 18;
        int unusedSpace = this.field_146295_m - this.field_147000_g;
        this.field_147009_r = (int)Math.floor((float)unusedSpace / (unusedSpace < 0 ? 3.8f : 2.0f));
        this.searchFieldInputs.x = this.field_147003_i + 32;
        this.searchFieldInputs.y = this.field_147009_r + 25;
        this.searchFieldOutputs.x = this.field_147003_i + 32;
        this.searchFieldOutputs.y = this.field_147009_r + 38;
        this.searchFieldNames.x = this.field_147003_i + 32 + 99;
        this.searchFieldNames.y = this.field_147009_r + 38;
        this.terminalStyleBox.field_146128_h = this.field_147003_i - 18;
        this.terminalStyleBox.field_146129_i = this.field_147009_r + 8 + this.jeiButtonPadding;
        this.guiButtonBrokenRecipes.field_146128_h = this.field_147003_i - 18;
        this.guiButtonBrokenRecipes.field_146129_i = this.terminalStyleBox.field_146129_i + 20;
        this.guiButtonHideFull.field_146128_h = this.field_147003_i - 18;
        this.guiButtonHideFull.field_146129_i = this.guiButtonBrokenRecipes.field_146129_i + 20;
        this.guiButtonAssemblersOnly.field_146128_h = this.field_147003_i - 18;
        this.guiButtonAssemblersOnly.field_146129_i = this.guiButtonHideFull.field_146129_i + 20;
        this.setScrollBar();
        this.repositionSlots();
    }

    protected void repositionSlots() {
        for (Object obj : this.field_147002_h.field_75151_b) {
            if (!(obj instanceof AppEngSlot)) continue;
            AppEngSlot slot = (AppEngSlot)((Object)obj);
            slot.field_75221_f = this.field_147000_g + slot.getY() - 78 - 7;
            slot.field_75223_e = slot.getX() + 14;
        }
    }

    @Override
    public List<Rectangle> getJEIExclusionArea() {
        Rectangle tallButton = new Rectangle(this.field_147003_i - 18, this.field_147009_r + 24 + 24, 18, 18);
        ArrayList<Rectangle> area = new ArrayList<Rectangle>();
        area.add(tallButton);
        return area;
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(GuiText.InterfaceTerminal.getLocal()), 23, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 23, this.field_147000_g - 96, 0x404040);
        int currentScroll = this.getScrollBar().getCurrentScroll();
        int offset = 51;
        int linesDraw = 0;
        for (int x = 0; x < this.rows && linesDraw < this.rows && currentScroll + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(currentScroll + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                int extraLines = this.numUpgradesMap.get(inv);
                for (int row = 0; row < 1 + extraLines && linesDraw < this.rows; ++row) {
                    for (int z = 0; z < 9; ++z) {
                        if (!this.matchedStacks.contains(inv.getInventory().getStackInSlot(z + row * 9))) continue;
                        GuiInterfaceTerminal.func_73734_a((int)(z * 18 + 22), (int)(1 + offset), (int)(z * 18 + 22 + 16), (int)(1 + offset + 16), (int)704708352);
                    }
                    ++linesDraw;
                    offset += 18;
                }
                continue;
            }
            if (!(lineObj instanceof String)) continue;
            String name = (String)lineObj;
            int rows = this.byName.get((Object)name).size();
            if (rows > 1) {
                name = name + " (" + rows + ')';
            }
            while (name.length() > 2 && this.field_146289_q.func_78256_a(name) > 158) {
                name = name.substring(0, name.length() - 1);
            }
            this.field_146289_q.func_78276_b(name, 24, 6 + offset, 0x404040);
            ++linesDraw;
            offset += 18;
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.field_146292_n.clear();
        this.guiButtonHashMap.clear();
        this.field_147002_h.field_75151_b.removeIf(slot -> slot instanceof SlotDisconnected);
        this.guiButtonAssemblersOnly.set(this.onlyMolecularAssemblers ? ActionItems.MOLECULAR_ASSEMBLERS_ON : ActionItems.MOLECULAR_ASSEMBLERS_OFF);
        this.guiButtonHideFull.set(this.onlyShowWithSpace ? ActionItems.TOGGLE_SHOW_FULL_INTERFACES_OFF : ActionItems.TOGGLE_SHOW_FULL_INTERFACES_ON);
        this.guiButtonBrokenRecipes.set(this.onlyBrokenRecipes ? ActionItems.TOGGLE_SHOW_ONLY_INVALID_PATTERNS_ON : ActionItems.TOGGLE_SHOW_ONLY_INVALID_PATTERNS_OFF);
        this.terminalStyleBox.set(AEConfig.instance().getConfigManager().getSetting(Settings.TERMINAL_STYLE));
        this.field_146292_n.add(this.guiButtonAssemblersOnly);
        this.field_146292_n.add(this.guiButtonHideFull);
        this.field_146292_n.add(this.guiButtonBrokenRecipes);
        this.field_146292_n.add(this.terminalStyleBox);
        int offset = 51;
        int currentScroll = this.getScrollBar().getCurrentScroll();
        int linesDraw = 0;
        for (int x = 0; x < this.rows && linesDraw < this.rows && currentScroll + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(currentScroll + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                GuiImgButton guiButton = new GuiImgButton(this.field_147003_i + 4, this.field_147009_r + offset + 1, Settings.ACTIONS, ActionItems.HIGHLIGHT_INTERFACE);
                this.guiButtonHashMap.put(guiButton, inv);
                this.field_146292_n.add(guiButton);
                int extraLines = this.numUpgradesMap.get(inv);
                for (int row = 0; row < 1 + extraLines && linesDraw < this.rows; ++row) {
                    for (int z = 0; z < 9; ++z) {
                        this.field_147002_h.field_75151_b.add(new SlotDisconnected(inv, z + row * 9, z * 18 + 22, 1 + offset));
                    }
                    ++linesDraw;
                    offset += 18;
                }
                continue;
            }
            if (!(lineObj instanceof String)) continue;
            ++linesDraw;
            offset += 18;
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawTooltip(this.searchFieldInputs, mouseX, mouseY);
        this.drawTooltip(this.searchFieldOutputs, mouseX, mouseY);
        this.drawTooltip(this.searchFieldNames, mouseX, mouseY);
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) throws IOException {
        this.searchFieldInputs.mouseClicked(xCoord, yCoord, btn);
        this.searchFieldOutputs.mouseClicked(xCoord, yCoord, btn);
        this.searchFieldNames.mouseClicked(xCoord, yCoord, btn);
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_146284_a(GuiButton btn) throws IOException {
        GuiImgButton iBtn;
        if (this.guiButtonHashMap.containsKey(btn)) {
            int interfaceDim;
            BlockPos blockPos = this.blockPosHashMap.get(this.guiButtonHashMap.get(this.field_146290_a));
            BlockPos blockPos2 = this.field_146297_k.field_71439_g.func_180425_c();
            int playerDim = this.field_146297_k.field_71441_e.field_73011_w.getDimension();
            if (playerDim != (interfaceDim = this.dimHashMap.get(this.guiButtonHashMap.get(this.field_146290_a)).intValue())) {
                try {
                    this.field_146297_k.field_71439_g.func_146105_b(PlayerMessages.InterfaceInOtherDimParam.get(interfaceDim, DimensionManager.getWorld((int)interfaceDim).field_73011_w.func_186058_p().func_186065_b()), false);
                }
                catch (Exception e) {
                    this.field_146297_k.field_71439_g.func_146105_b(PlayerMessages.InterfaceInOtherDim.get(), false);
                }
            } else {
                BlockPosHighlighter.hilightBlock(blockPos, System.currentTimeMillis() + 500L * BlockPosUtils.getDistance(blockPos, blockPos2), playerDim);
                this.field_146297_k.field_71439_g.func_146105_b(PlayerMessages.InterfaceHighlighted.get(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), false);
            }
            this.field_146297_k.field_71439_g.func_71053_j();
        } else if (btn == this.guiButtonHideFull) {
            this.onlyShowWithSpace = !this.onlyShowWithSpace;
            this.refreshList();
        } else if (btn == this.guiButtonAssemblersOnly) {
            this.onlyMolecularAssemblers = !this.onlyMolecularAssemblers;
            this.refreshList();
        } else if (btn == this.guiButtonBrokenRecipes) {
            this.onlyBrokenRecipes = !this.onlyBrokenRecipes;
            this.refreshList();
        } else if (btn instanceof GuiImgButton && (iBtn = (GuiImgButton)btn).getSetting() != Settings.ACTIONS) {
            Enum cv = iBtn.getCurrentValue();
            boolean backwards = Mouse.isButtonDown((int)1);
            Enum next = Platform.rotateEnum(cv, backwards, iBtn.getSetting().getPossibleValues());
            if (btn == this.terminalStyleBox) {
                AEConfig.instance().getConfigManager().putSetting(iBtn.getSetting(), next);
                this.reinitalize();
            }
            iBtn.set(next);
        }
    }

    private void reinitalize() {
        this.field_146292_n.clear();
        this.func_73866_w_();
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/newinterfaceterminal.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, 53);
        for (int x = 0; x < this.rows; ++x) {
            this.func_73729_b(offsetX, offsetY + 53 + x * 18, 0, 52, this.field_146999_f, 18);
        }
        int offset = 51;
        int ex = this.getScrollBar().getCurrentScroll();
        int linesDraw = 0;
        for (int x = 0; x < this.rows && linesDraw < this.rows && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int width = 162;
                int extraLines = this.numUpgradesMap.get(lineObj);
                for (int row = 0; row < 1 + extraLines && linesDraw < this.rows; ++linesDraw, ++row) {
                    this.func_73729_b(offsetX + 20, offsetY + offset, 20, 173, 162, 18);
                    offset += 18;
                }
                continue;
            }
            offset += 18;
            ++linesDraw;
        }
        this.func_73729_b(offsetX, offsetY + 50 + this.rows * 18, 0, 158, this.field_146999_f, 99);
        this.searchFieldInputs.drawTextBox();
        this.searchFieldOutputs.drawTextBox();
        this.searchFieldNames.drawTextBox();
    }

    protected void func_73869_a(char character, int key) throws IOException {
        if (!this.func_146983_a(key)) {
            if (character == ' ' ? this.searchFieldInputs.getText().isEmpty() && this.searchFieldInputs.isFocused() || this.searchFieldOutputs.getText().isEmpty() && this.searchFieldOutputs.isFocused() || this.searchFieldNames.getText().isEmpty() && this.searchFieldNames.isFocused() : character == '\t' && this.handleTab()) {
                return;
            }
            if (this.searchFieldInputs.textboxKeyTyped(character, key) || this.searchFieldOutputs.textboxKeyTyped(character, key) || this.searchFieldNames.textboxKeyTyped(character, key)) {
                this.refreshList();
            } else {
                super.func_73869_a(character, key);
            }
        }
    }

    private boolean handleTab() {
        if (this.searchFieldInputs.isFocused()) {
            this.searchFieldInputs.setFocused(false);
            if (GuiInterfaceTerminal.func_146272_n()) {
                this.searchFieldNames.setFocused(true);
            } else {
                this.searchFieldOutputs.setFocused(true);
            }
            return true;
        }
        if (this.searchFieldOutputs.isFocused()) {
            this.searchFieldOutputs.setFocused(false);
            if (GuiInterfaceTerminal.func_146272_n()) {
                this.searchFieldInputs.setFocused(true);
            } else {
                this.searchFieldNames.setFocused(true);
            }
            return true;
        }
        if (this.searchFieldNames.isFocused()) {
            this.searchFieldNames.setFocused(false);
            if (GuiInterfaceTerminal.func_146272_n()) {
                this.searchFieldOutputs.setFocused(true);
            } else {
                this.searchFieldInputs.setFocused(true);
            }
            return true;
        }
        return false;
    }

    public void postUpdate(NBTTagCompound in) {
        if (in.func_74767_n("clear")) {
            this.byId.clear();
            this.refreshList = true;
        }
        for (Object oKey : in.func_150296_c()) {
            String key = (String)oKey;
            if (!key.startsWith("=")) continue;
            try {
                long id = Long.parseLong(key.substring(1), 36);
                NBTTagCompound invData = in.func_74775_l(key);
                ClientDCInternalInv current = this.getById(id, invData.func_74763_f("sortBy"), invData.func_74779_i("un"));
                this.blockPosHashMap.put(current, NBTUtil.func_186861_c((NBTTagCompound)invData.func_74775_l("pos")));
                this.dimHashMap.put(current, invData.func_74762_e("dim"));
                this.numUpgradesMap.put(current, invData.func_74762_e("numUpgrades"));
                for (int x = 0; x < current.getInventory().getSlots(); ++x) {
                    String which = Integer.toString(x);
                    if (!invData.func_74764_b(which)) continue;
                    current.getInventory().setStackInSlot(x, ItemStackHelper.stackFromNBT(invData.func_74775_l(which)));
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        if (this.refreshList) {
            this.refreshList = false;
            this.cachedSearches.clear();
            this.refreshList();
        }
    }

    private void refreshList() {
        this.byName.clear();
        this.field_146292_n.clear();
        this.matchedStacks.clear();
        String searchFieldInputs = this.searchFieldInputs.getText().toLowerCase();
        String searchFieldOutputs = this.searchFieldOutputs.getText().toLowerCase();
        String searchFieldNames = this.searchFieldNames.getText().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm("IN:" + searchFieldInputs + " OUT:" + searchFieldOutputs + "NAME:" + searchFieldNames + this.onlyShowWithSpace + this.onlyMolecularAssemblers + this.onlyBrokenRecipes);
        boolean rebuild = cachedSearch.isEmpty();
        for (ClientDCInternalInv entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFieldInputs.isEmpty() && searchFieldOutputs.isEmpty();
            boolean interfaceHasFreeSlots = false;
            boolean interfaceHasBrokenRecipes = false;
            if (!found || this.onlyShowWithSpace || this.onlyBrokenRecipes) {
                int slot = 0;
                for (ItemStack itemStack : entry.getInventory()) {
                    if (slot > 8 + this.numUpgradesMap.get(entry) * 9) break;
                    if (itemStack.func_190926_b()) {
                        interfaceHasFreeSlots = true;
                    }
                    if (this.onlyBrokenRecipes && this.recipeIsBroken(itemStack)) {
                        interfaceHasBrokenRecipes = true;
                    }
                    if (!searchFieldInputs.isEmpty() && this.itemStackMatchesSearchTerm(itemStack, searchFieldInputs, 0) || !searchFieldOutputs.isEmpty() && this.itemStackMatchesSearchTerm(itemStack, searchFieldOutputs, 1)) {
                        found = true;
                        this.matchedStacks.add(itemStack);
                    }
                    ++slot;
                }
            }
            if (!found) {
                cachedSearch.remove(entry);
                continue;
            }
            if (!entry.getName().toLowerCase().contains(searchFieldNames)) {
                cachedSearch.remove(entry);
                continue;
            }
            if (this.onlyMolecularAssemblers && !entry.getName().toLowerCase().contains(MOLECULAR_ASSEMBLER)) {
                cachedSearch.remove(entry);
                continue;
            }
            if (this.onlyShowWithSpace && !interfaceHasFreeSlots) {
                cachedSearch.remove(entry);
                continue;
            }
            if (this.onlyBrokenRecipes && !interfaceHasBrokenRecipes) {
                cachedSearch.remove(entry);
                continue;
            }
            this.byName.put((Object)entry.getName(), (Object)entry);
            cachedSearch.add(entry);
        }
        this.names.clear();
        this.names.addAll(this.byName.keySet());
        Collections.sort(this.names);
        this.lines.clear();
        this.lines.ensureCapacity(this.names.size() + this.byId.size());
        for (String n : this.names) {
            this.lines.add(n);
            ArrayList clientInventories = new ArrayList(this.byName.get((Object)n));
            Collections.sort(clientInventories);
            this.lines.addAll(clientInventories);
        }
        this.setScrollBar();
    }

    private boolean recipeIsBroken(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        NBTTagCompound encodedValue = stack.func_77978_p();
        if (encodedValue == null) {
            return true;
        }
        World w = AppEng.proxy.getWorld();
        if (w == null) {
            return false;
        }
        try {
            new PatternHelper(stack, w);
            return false;
        }
        catch (Throwable ignored) {
            return true;
        }
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm, int pass) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        NBTTagCompound encodedValue = itemStack.func_77978_p();
        if (encodedValue == null) {
            return searchTerm.matches(GuiText.InvalidPattern.getLocal());
        }
        NBTTagList tag = pass == 0 ? encodedValue.func_150295_c("in", 10) : encodedValue.func_150295_c("out", 10);
        boolean foundMatchingItemStack = false;
        String[] splitTerm = searchTerm.split(" ");
        for (int i = 0; i < tag.func_74745_c(); ++i) {
            ItemStack parsedItemStack = new ItemStack(tag.func_150305_b(i));
            if (parsedItemStack.func_190926_b()) continue;
            String displayName = Platform.getItemDisplayName(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(parsedItemStack)).toLowerCase();
            for (String term : splitTerm) {
                if (term.length() > 1 && (term.startsWith("-") || term.startsWith("!"))) {
                    if (!displayName.contains(term = term.substring(1))) continue;
                    return false;
                }
                if (!displayName.contains(term)) continue;
                foundMatchingItemStack = true;
            }
        }
        return foundMatchingItemStack;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
            return cache;
        }
        return cache;
    }

    private int getMaxRows() {
        return AEConfig.instance().getConfigManager().getSetting(Settings.TERMINAL_STYLE) != TerminalStyle.TALL ? 6 : Integer.MAX_VALUE;
    }

    private ClientDCInternalInv getById(long id, long sortBy, String string) {
        ClientDCInternalInv o = this.byId.get(id);
        if (o == null) {
            o = new ClientDCInternalInv(36, id, sortBy, string);
            this.byId.put(id, o);
            this.refreshList = true;
        }
        return o;
    }
}

