/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.me;

import appeng.api.AEApi;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.config.YesNo;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.core.AEConfig;
import appeng.integration.Integrations;
import appeng.integration.modules.bogosorter.InventoryBogoSortModule;
import appeng.items.storage.ItemViewCell;
import appeng.util.ItemSorters;
import appeng.util.Platform;
import appeng.util.prioritylist.IPartitionList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class ItemRepo {
    private final IItemList<IAEItemStack> list = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private List<IAEItemStack> view = new ArrayList<IAEItemStack>();
    private final IScrollSource src;
    private final ISortSource sortSrc;
    private int rowSize = 9;
    private String searchString = "";
    private IPartitionList<IAEItemStack> myPartitionList;
    private String innerSearch = "";
    private boolean hasPower;
    private Enum lastView;
    private Enum lastSearchMode;
    private Enum lastSortBy;
    private Enum lastSortDir;
    private String lastSearch = "";
    private boolean resort = true;
    private boolean changed = false;

    public ItemRepo(IScrollSource src, ISortSource sortSrc) {
        this.src = src;
        this.sortSrc = sortSrc;
    }

    public IAEItemStack getReferenceItem(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.view.size()) {
            return null;
        }
        return this.view.get(idx);
    }

    void setSearch(String search) {
        this.searchString = search == null ? "" : search;
    }

    public void postUpdate(IAEItemStack is) {
        IAEItemStack st = this.list.findPrecise(is);
        if (st != null) {
            st.reset();
            st.add(is);
        } else {
            this.list.add(is);
        }
        this.changed = true;
    }

    public long getItemCount(IAEItemStack is) {
        IAEItemStack st = this.list.findPrecise(is);
        return st == null ? 0L : st.getStackSize();
    }

    public void setViewCell(ItemStack[] list) {
        this.myPartitionList = ItemViewCell.createFilter(list);
        this.changed = true;
    }

    public void updateView() {
        Enum<?> searchMode;
        Enum viewMode = this.sortSrc.getSortDisplay();
        if (this.lastView != viewMode) {
            this.resort = true;
            this.lastView = viewMode;
        }
        if (this.lastSearchMode != (searchMode = AEConfig.instance().getConfigManager().getSetting(Settings.SEARCH_MODE))) {
            this.resort = true;
            this.lastSearchMode = searchMode;
        }
        if (searchMode == SearchBoxMode.JEI_AUTOSEARCH || searchMode == SearchBoxMode.JEI_MANUAL_SEARCH || searchMode == SearchBoxMode.JEI_AUTOSEARCH_KEEP || searchMode == SearchBoxMode.JEI_MANUAL_SEARCH_KEEP) {
            this.updateJEI(this.searchString);
        }
        if (!this.lastSearch.equals(this.searchString)) {
            this.resort = true;
            this.lastSearch = this.searchString;
        }
        Enum sortBy = this.sortSrc.getSortBy();
        Enum sortDir = this.sortSrc.getSortDir();
        if (this.lastSortBy != sortBy) {
            this.resort = true;
            this.lastSortBy = sortBy;
        }
        if (this.lastSortDir != sortDir) {
            this.resort = true;
            this.lastSortDir = sortDir;
        }
        if (this.changed || this.resort) {
            this.changed = false;
            this.resort = false;
            this.view = new ArrayList<IAEItemStack>();
            ItemSorters.setDirection((SortDir)sortDir);
            ItemSorters.init();
            Comparator<IAEItemStack> c = ItemRepo.getComparator(sortBy);
            for (IAEItemStack is : this.list) {
                this.addIAE(is, viewMode);
            }
            this.view.sort(c);
        }
    }

    private static Comparator<IAEItemStack> getComparator(Enum sortBy) {
        Comparator<IAEItemStack> c = sortBy == SortOrder.MOD ? ItemSorters.CONFIG_BASED_SORT_BY_MOD : (sortBy == SortOrder.AMOUNT ? ItemSorters.CONFIG_BASED_SORT_BY_SIZE : (sortBy == SortOrder.INVTWEAKS ? (InventoryBogoSortModule.isLoaded() ? InventoryBogoSortModule.COMPARATOR : ItemSorters.CONFIG_BASED_SORT_BY_INV_TWEAKS) : ItemSorters.CONFIG_BASED_SORT_BY_NAME));
        return c;
    }

    private void addIAE(IAEItemStack is, Enum viewMode) {
        boolean needsZeroCopy = viewMode == ViewItems.CRAFTABLE;
        boolean terminalSearchToolTips = AEConfig.instance().getConfigManager().getSetting(Settings.SEARCH_TOOLTIPS) != YesNo.NO;
        boolean searchMod = false;
        this.innerSearch = this.searchString.toLowerCase();
        if (this.innerSearch.startsWith("@")) {
            searchMod = true;
            this.innerSearch = this.innerSearch.substring(1);
        }
        Pattern m = null;
        try {
            m = Pattern.compile(this.innerSearch, 2);
        }
        catch (Throwable ignore) {
            try {
                m = Pattern.compile(Pattern.quote(this.innerSearch), 2);
            }
            catch (Throwable __) {
                return;
            }
        }
        if (this.myPartitionList != null && !this.myPartitionList.isListed(is)) {
            return;
        }
        if (viewMode == ViewItems.CRAFTABLE && !is.isCraftable()) {
            return;
        }
        if (viewMode == ViewItems.STORED && is.getStackSize() == 0L) {
            return;
        }
        String dspName = (searchMod ? Platform.getModId(is) : Platform.getItemDisplayName(is)).toLowerCase();
        boolean foundMatchingItemStack = true;
        for (String term : this.innerSearch.split(" ")) {
            if (term.length() > 1 && (term.startsWith("-") || term.startsWith("!"))) {
                if (!dspName.contains(term = term.substring(1))) continue;
                foundMatchingItemStack = false;
                break;
            }
            if (dspName.contains(term)) continue;
            foundMatchingItemStack = false;
            break;
        }
        if (terminalSearchToolTips && !foundMatchingItemStack) {
            List<String> tooltip = Platform.getTooltip(is);
            for (String line : tooltip) {
                if (!m.matcher(line).find()) continue;
                foundMatchingItemStack = true;
                break;
            }
        }
        if (foundMatchingItemStack) {
            if (needsZeroCopy) {
                is = is.copy();
                is.setStackSize(0L);
            }
            this.view.add(is);
        }
    }

    private void updateJEI(String filter) {
        Integrations.jei().setSearchText(filter);
    }

    public int size() {
        return this.view.size();
    }

    public void clear() {
        this.list.resetStatus();
    }

    public boolean hasPower() {
        return this.hasPower;
    }

    public void setPower(boolean hasPower) {
        this.hasPower = hasPower;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(@Nonnull String searchString) {
        this.searchString = searchString;
    }

    public IItemList<IAEItemStack> getList() {
        return this.list;
    }
}

