/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.AEApi;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.CommonHelper;
import appeng.core.CreativeTab;
import appeng.core.CreativeTabFacade;
import appeng.core.FacadeConfig;
import appeng.core.IMCHandler;
import appeng.core.PluginLoader;
import appeng.core.Registration;
import appeng.core.crash.CrashInfo;
import appeng.core.crash.IntegrationCrashEnhancement;
import appeng.core.crash.ModCrashEnhancement;
import appeng.core.features.AEFeature;
import appeng.core.stats.AdvancementTriggers;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.worlddata.WorldData;
import appeng.helpers.NonBlockingItems;
import appeng.hooks.TickHandler;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.server.AECommand;
import appeng.services.VersionChecker;
import appeng.services.export.ExportConfig;
import appeng.services.export.ExportProcess;
import appeng.services.export.ForgeExportConfig;
import appeng.services.version.VersionCheckerConfig;
import appeng.util.Platform;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommand;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@Mod(modid="appliedenergistics2", acceptedMinecraftVersions="[1.12.2]", name="Applied Energistics 2", version="v0.56.5", dependencies="required-after:forge@[14.23.5.2847,15.0.0.0);after:ctm@[MC1.12.2-1.0.2.31,);after:itemstages;after:recipestages;before:bogosorter@[1.2.2,);", guiFactory="appeng.client.gui.config.AEConfigGuiFactory", certificateFingerprint="dfa4d3ac143316c6f32aa1a1beda1e34d42132e5")
public final class AppEng {
    @SidedProxy(clientSide="appeng.client.ClientHelper", serverSide="appeng.server.ServerHelper", modId="appliedenergistics2")
    public static CommonHelper proxy;
    public static final String MOD_ID = "appliedenergistics2";
    public static final String MOD_NAME = "Applied Energistics 2";
    public static final String ASSETS = "appliedenergistics2:";
    private static final String FORGE_CURRENT_VERSION = "14.23.5.2847";
    private static final String FORGE_MAX_VERSION = "15.0.0.0";
    public static final String MOD_DEPENDENCIES = "required-after:forge@[14.23.5.2847,15.0.0.0);after:ctm@[MC1.12.2-1.0.2.31,);after:itemstages;after:recipestages;before:bogosorter@[1.2.2,);";
    @Nonnull
    private static final AppEng INSTANCE;
    private final Registration registration;
    private File configDirectory;
    private ExportConfig exportConfig;

    private AppEng() {
        FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new ModCrashEnhancement(CrashInfo.MOD_VERSION));
        this.registration = new Registration();
        MinecraftForge.EVENT_BUS.register((Object)this.registration);
    }

    @Nonnull
    @Mod.InstanceFactory
    public static AppEng instance() {
        return INSTANCE;
    }

    public Biome getStorageBiome() {
        return this.registration.storageBiome;
    }

    public DimensionType getStorageDimensionType() {
        return this.registration.storageDimensionType;
    }

    public int getStorageDimensionID() {
        return this.registration.storageDimensionID;
    }

    public AdvancementTriggers getAdvancementTriggers() {
        return this.registration.advancementTriggers;
    }

    @Mod.EventHandler
    private void preInit(FMLPreInitializationEvent event) {
        Stopwatch watch = Stopwatch.createStarted();
        this.configDirectory = new File(event.getModConfigurationDirectory().getPath(), "AppliedEnergistics2");
        File configFile = new File(this.configDirectory, "AppliedEnergistics2.cfg");
        File facadeFile = new File(this.configDirectory, "Facades.cfg");
        File versionFile = new File(this.configDirectory, "VersionChecker.cfg");
        File recipeFile = new File(this.configDirectory, "CustomRecipes.cfg");
        Configuration recipeConfiguration = new Configuration(recipeFile);
        AEConfig.init(configFile);
        FacadeConfig.init(facadeFile);
        VersionCheckerConfig versionCheckerConfig = new VersionCheckerConfig(versionFile);
        this.exportConfig = new ForgeExportConfig(recipeConfiguration);
        AELog.info("Pre Initialization ( started )", new Object[0]);
        CreativeTab.init();
        if (AEConfig.instance().isFeatureEnabled(AEFeature.FACADES)) {
            CreativeTabFacade.init();
        }
        for (IntegrationType type : IntegrationType.values()) {
            IntegrationRegistry.INSTANCE.add(type);
        }
        this.registration.preInitialize(event);
        if (Platform.isClient()) {
            proxy.preinit();
        }
        IntegrationRegistry.INSTANCE.preInit();
        if (versionCheckerConfig.isVersionCheckingEnabled()) {
            VersionChecker versionChecker = new VersionChecker(versionCheckerConfig);
            Thread versionCheckerThread = new Thread(versionChecker);
            this.startService("AE2 VersionChecker", versionCheckerThread);
        }
        AELog.info("Pre Initialization ( ended after " + watch.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
        ArrayList injectables = Lists.newArrayList((Object[])new Object[]{AEApi.instance()});
        new PluginLoader().loadPlugins(injectables, event.getAsmData());
    }

    private void startService(String serviceName, Thread thread) {
        thread.setName(serviceName);
        thread.setPriority(1);
        AELog.info("Starting " + serviceName, new Object[0]);
        thread.start();
    }

    @Mod.EventHandler
    private void init(FMLInitializationEvent event) {
        Stopwatch start = Stopwatch.createStarted();
        AELog.info("Initialization ( started )", new Object[0]);
        proxy.init();
        if (this.exportConfig.isExportingItemNamesEnabled()) {
            if (FMLCommonHandler.instance().getSide().isClient()) {
                ExportProcess process = new ExportProcess(this.configDirectory, this.exportConfig);
                Thread exportProcessThread = new Thread(process);
                this.startService("AE2 CSV Export", exportProcessThread);
            } else {
                AELog.info("Disabling item.csv export for custom recipes, since creative tab information is only available on the client.", new Object[0]);
            }
        }
        this.registration.initialize(event, this.configDirectory);
        IntegrationRegistry.INSTANCE.init();
        AELog.info("Initialization ( ended after " + start.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
    }

    @Mod.EventHandler
    private void postInit(FMLPostInitializationEvent event) {
        Stopwatch start = Stopwatch.createStarted();
        AELog.info("Post Initialization ( started )", new Object[0]);
        this.registration.postInit(event);
        IntegrationRegistry.INSTANCE.postInit();
        FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new IntegrationCrashEnhancement());
        proxy.postInit();
        AEConfig.instance().save();
        NonBlockingItems.INSTANCE.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)GuiBridge.GUI_Handler);
        NetworkHandler.init("AE2");
        AELog.info("Post Initialization ( ended after " + start.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
    }

    @Mod.EventHandler
    private void handleIMCEvent(FMLInterModComms.IMCEvent event) {
        IMCHandler imcHandler = new IMCHandler();
        imcHandler.handleIMCEvent(event);
    }

    @Mod.EventHandler
    private void serverAboutToStart(FMLServerAboutToStartEvent evt) {
        WorldData.onServerAboutToStart(evt.getServer());
    }

    @Mod.EventHandler
    private void serverStopping(FMLServerStoppingEvent event) {
        WorldData.instance().onServerStopping();
    }

    @Mod.EventHandler
    private void serverStopped(FMLServerStoppedEvent event) {
        WorldData.instance().onServerStoppped();
        TickHandler.INSTANCE.shutdown();
    }

    @Mod.EventHandler
    private void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new AECommand(evt.getServer()));
    }

    static {
        INSTANCE = new AppEng();
    }
}

