/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries.grinder;

import appeng.api.features.IGrinderRecipe;
import appeng.api.features.IGrinderRecipeBuilder;
import appeng.api.features.IGrinderRegistry;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.registries.grinder.AppEngGrinderRecipe;
import appeng.recipes.ores.IOreListener;
import appeng.recipes.ores.OreDictionaryHandler;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class GrinderRecipeManager
implements IGrinderRegistry,
IOreListener {
    private final Map<CacheKey, IGrinderRecipe> recipes = Maps.newHashMap();
    private final Map<ItemStack, String> ores = Maps.newHashMap();
    private final Map<ItemStack, String> ingots = Maps.newHashMap();
    private final Map<String, ItemStack> dusts = Maps.newHashMap();
    private final Map<String, Integer> dustToOreRatio = Maps.newHashMap();

    public GrinderRecipeManager() {
        this.addDustRatio("Obsidian", 1);
        this.addDustRatio("Charcoal", 1);
        this.addDustRatio("Coal", 1);
        this.addOre("Coal", new ItemStack(Items.field_151044_h));
        this.addOre("Charcoal", new ItemStack(Items.field_151044_h, 1, 1));
        this.addOre("NetherQuartz", new ItemStack(Blocks.field_150449_bY));
        this.addIngot("NetherQuartz", new ItemStack(Items.field_151128_bU));
        this.addOre("Gold", new ItemStack(Blocks.field_150352_o));
        this.addIngot("Gold", new ItemStack(Items.field_151043_k));
        this.addOre("Iron", new ItemStack(Blocks.field_150366_p));
        this.addIngot("Iron", new ItemStack(Items.field_151042_j));
        this.addOre("Obsidian", new ItemStack(Blocks.field_150343_Z));
        this.addIngot("Ender", new ItemStack(Items.field_151079_bi));
        this.addIngot("EnderPearl", new ItemStack(Items.field_151079_bi));
        this.addIngot("Wheat", new ItemStack(Items.field_151015_O));
        OreDictionaryHandler.INSTANCE.observe(this);
    }

    @Override
    public IGrinderRecipeBuilder builder() {
        return new Builder();
    }

    @Override
    public boolean addRecipe(IGrinderRecipe recipe) {
        Preconditions.checkNotNull((Object)recipe, (Object)"Cannot add null as recipe.");
        return this.injectRecipe(recipe);
    }

    @Override
    public Collection<IGrinderRecipe> getRecipes() {
        return Collections.unmodifiableCollection(this.recipes.values());
    }

    @Override
    public boolean removeRecipe(IGrinderRecipe recipe) {
        Preconditions.checkNotNull((Object)recipe, (Object)"Cannot remove null as recipe.");
        CacheKey key = new CacheKey(recipe.getInput());
        IGrinderRecipe removedRecipe = this.recipes.remove(key);
        this.log("Removed Grinding of '%1%s'", Platform.getItemDisplayName(recipe.getInput()));
        return removedRecipe != null;
    }

    @Override
    public IGrinderRecipe getRecipeForInput(ItemStack input) {
        this.log("Looking up recipe for '%1$s'", Platform.getItemDisplayName(input));
        if (input == null) {
            return null;
        }
        IGrinderRecipe recipe = this.recipes.get(new CacheKey(input));
        if (recipe == null) {
            return null;
        }
        this.log("Recipe for '%1$s' found '%2$s'", input.func_77977_a(), Platform.getItemDisplayName(recipe.getOutput()));
        return recipe;
    }

    @Override
    public void addDustRatio(String oredictName, int ratio) {
        Preconditions.checkNotNull((Object)oredictName);
        Preconditions.checkArgument((ratio > 0 ? 1 : 0) != 0);
        this.log("Added ratio for '%1$s' of %2$d", oredictName, ratio);
        this.dustToOreRatio.put(oredictName, ratio);
    }

    @Override
    public boolean removeDustRatio(String oredictName) {
        Preconditions.checkNotNull((Object)oredictName);
        this.log("Removed ratio for '%1$s'", oredictName);
        return this.dustToOreRatio.remove(oredictName) != null;
    }

    @Override
    public void oreRegistered(String name, ItemStack item) {
        if (!AEConfig.instance().getGrinderBlackList().contains(name) && (name.startsWith("ore") || name.startsWith("crystal") || name.startsWith("gem") || name.startsWith("ingot") || name.startsWith("dust"))) {
            for (String ore : AEConfig.instance().getGrinderOres()) {
                if (name.equals("ore" + ore)) {
                    this.addOre(ore, item);
                    continue;
                }
                if (name.equals("crystal" + ore) || name.equals("ingot" + ore) || name.equals("gem" + ore)) {
                    this.addIngot(ore, item);
                    continue;
                }
                if (!name.equals("dust" + ore)) continue;
                this.addDust(ore, item);
            }
        }
    }

    private boolean injectRecipe(IGrinderRecipe grinderRecipe) {
        CacheKey cacheKey = new CacheKey(grinderRecipe.getInput());
        if (this.recipes.containsKey(cacheKey)) {
            this.log("Tried to add duplicate recipe for '%1$s'", Platform.getItemDisplayName(grinderRecipe.getInput()));
            return false;
        }
        this.recipes.put(cacheKey, grinderRecipe);
        return true;
    }

    private int getDustToOreRatio(String name) {
        return this.dustToOreRatio.getOrDefault(name, 2);
    }

    private void addOre(String name, ItemStack item) {
        if (item == null) {
            return;
        }
        this.log("Adding Ore: '%1$s'", Platform.getItemDisplayName(item));
        this.ores.put(item, name);
        if (this.dusts.containsKey(name)) {
            ItemStack is = this.dusts.get(name).func_77946_l();
            int ratio = this.getDustToOreRatio(name);
            if (ratio > 1) {
                ItemStack extra = is.func_77946_l();
                extra.func_190920_e(ratio - 1);
                IGrinderRecipeBuilder builder = this.builder();
                IGrinderRecipe grinderRecipe = builder.withInput(item).withOutput(is).withFirstOptional(extra, (float)(AEConfig.instance().getOreDoublePercentage() / 100.0)).withTurns(8).build();
                this.addRecipe(grinderRecipe);
            } else {
                IGrinderRecipeBuilder builder = this.builder();
                IGrinderRecipe grinderRecipe = builder.withInput(item).withOutput(is).withTurns(8).build();
                this.addRecipe(grinderRecipe);
            }
        }
    }

    private void addIngot(String name, ItemStack item) {
        if (item == null) {
            return;
        }
        this.log("Adding Ingot: '%1$s'", Platform.getItemDisplayName(item));
        this.ingots.put(item, name);
        if (this.dusts.containsKey(name)) {
            IGrinderRecipeBuilder builder = this.builder();
            IGrinderRecipe grinderRecipe = builder.withInput(item).withOutput(this.dusts.get(name)).withTurns(4).build();
            this.addRecipe(grinderRecipe);
        }
    }

    private void addDust(String name, ItemStack item) {
        if (item == null) {
            return;
        }
        if (this.dusts.containsKey(name)) {
            this.log("Rejecting Dust: '%1$s'", Platform.getItemDisplayName(item));
            return;
        }
        this.log("Adding Dust: '%1$s'", Platform.getItemDisplayName(item));
        this.dusts.put(name, item);
        for (Map.Entry<ItemStack, String> d : this.ores.entrySet()) {
            if (!name.equals(d.getValue())) continue;
            ItemStack is = item.func_77946_l();
            is.func_190920_e(1);
            int ratio = this.getDustToOreRatio(name);
            if (ratio > 1) {
                ItemStack extra = is.func_77946_l();
                extra.func_190920_e(ratio - 1);
                IGrinderRecipeBuilder builder = this.builder();
                IGrinderRecipe grinderRecipe = builder.withInput(d.getKey()).withOutput(is).withFirstOptional(extra, (float)(AEConfig.instance().getOreDoublePercentage() / 100.0)).withTurns(8).build();
                this.addRecipe(grinderRecipe);
                continue;
            }
            IGrinderRecipeBuilder builder = this.builder();
            IGrinderRecipe grinderRecipe = builder.withInput(d.getKey()).withOutput(is).withTurns(8).build();
            this.addRecipe(grinderRecipe);
        }
        for (Map.Entry<ItemStack, String> d : this.ingots.entrySet()) {
            if (!name.equals(d.getValue())) continue;
            IGrinderRecipeBuilder builder = this.builder();
            IGrinderRecipe grinderRecipe = builder.withInput(d.getKey()).withOutput(item).withTurns(4).build();
            this.addRecipe(grinderRecipe);
        }
    }

    private void log(String o, Object ... params) {
        AELog.grinder(o, params);
    }

    private static final class Builder
    implements IGrinderRecipeBuilder {
        private ItemStack in;
        private ItemStack out;
        private float optionalChance;
        private ItemStack optionalOutput;
        private float optionalChance2;
        private ItemStack optionalOutput2;
        private int turns = 8;

        private Builder() {
        }

        @Override
        public IGrinderRecipeBuilder withInput(ItemStack input) {
            Preconditions.checkNotNull((Object)input);
            Preconditions.checkArgument((!input.func_190926_b() ? 1 : 0) != 0, (Object)"Input cannot be empty.");
            this.in = this.copy(input);
            return this;
        }

        @Override
        public IGrinderRecipeBuilder withOutput(ItemStack output) {
            Preconditions.checkNotNull((Object)output);
            Preconditions.checkArgument((!output.func_190926_b() ? 1 : 0) != 0, (Object)"Output cannot be empty.");
            this.out = this.copy(output);
            return this;
        }

        @Override
        public IGrinderRecipeBuilder withFirstOptional(ItemStack optional, float chance) {
            Preconditions.checkNotNull((Object)optional);
            Preconditions.checkArgument((!optional.func_190926_b() ? 1 : 0) != 0, (Object)"Optional cannot be empty.");
            Preconditions.checkArgument((chance >= 0.0f && (double)chance <= 1.0 ? 1 : 0) != 0);
            this.optionalOutput = this.copy(optional);
            this.optionalChance = chance;
            return this;
        }

        @Override
        public IGrinderRecipeBuilder withSecondOptional(ItemStack optional, float chance) {
            Preconditions.checkNotNull((Object)optional);
            Preconditions.checkArgument((!optional.func_190926_b() ? 1 : 0) != 0, (Object)"Optional cannot be empty.");
            Preconditions.checkArgument((chance >= 0.0f && (double)chance <= 1.0 ? 1 : 0) != 0);
            this.optionalOutput2 = this.copy(optional);
            this.optionalChance2 = chance;
            return this;
        }

        @Override
        public IGrinderRecipeBuilder withTurns(int turns) {
            Preconditions.checkArgument((turns > 0 ? 1 : 0) != 0);
            this.turns = turns;
            return this;
        }

        @Override
        @Nonnull
        public IGrinderRecipe build() {
            Preconditions.checkState((this.in != null ? 1 : 0) != 0, (Object)"Input itemstack must be defined.");
            Preconditions.checkState((this.out != null ? 1 : 0) != 0, (Object)"Output itemstack must be defined.");
            return new AppEngGrinderRecipe(this.in, this.out, this.optionalOutput, this.optionalOutput2, this.optionalChance, this.optionalChance2, this.turns);
        }

        private ItemStack copy(ItemStack is) {
            if (is != null) {
                return is.func_77946_l();
            }
            return null;
        }
    }

    private static class CacheKey {
        private final Item item;
        private final int damage;

        CacheKey(ItemStack input) {
            Preconditions.checkNotNull((Object)input);
            Preconditions.checkNotNull((Object)input.func_77973_b());
            this.item = input.func_77973_b();
            this.damage = input.func_77952_i();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.damage;
            result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.damage != other.damage) {
                return false;
            }
            if (this.item == null) {
                return other.item == null;
            }
            return this.item == other.item;
        }
    }
}

