/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.block.networking.BlockCableBus;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketCableBusLandingParticle
extends AppEngPacket {
    private BlockPos pos;
    private double entityX;
    private double entityY;
    private double entityZ;
    private int numberOfParticles;

    public PacketCableBusLandingParticle(ByteBuf stream) {
        this.pos = BlockPos.func_177969_a((long)stream.readLong());
        this.entityX = stream.readDouble();
        this.entityY = stream.readDouble();
        this.entityZ = stream.readDouble();
        this.numberOfParticles = stream.readInt();
    }

    public PacketCableBusLandingParticle(BlockPos pos, Entity entity, int numberOfParticles) {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeLong(pos.func_177986_g());
        data.writeDouble(entity.field_70165_t);
        data.writeDouble(entity.field_70163_u);
        data.writeDouble(entity.field_70161_v);
        data.writeInt(numberOfParticles);
        this.configureWrite(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        IBlockState state = world.func_180495_p(this.pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockCableBus) {
            BlockCableBus cb = (BlockCableBus)block;
            cb.addLandingParticle(this.pos, this.entityX, this.entityY, this.entityZ, this.numberOfParticles);
        }
    }
}

