/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import appeng.api.storage.ISpatialDimension;
import appeng.capabilities.Capabilities;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;

public class SpatialDimensionManager
implements ISpatialDimension,
ICapabilitySerializable<NBTTagCompound> {
    private static final String NBT_SPATIAL_DATA_KEY = "spatial_data";
    private static final String NBT_SPATIAL_ID_KEY = "id";
    private final World world;
    private final Map<Integer, StorageCellData> spatialData = new HashMap<Integer, StorageCellData>();
    private static final int MAX_CELL_DIMENSION = 512;

    public SpatialDimensionManager(World world) {
        this.world = world;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public int createNewCellDimension(BlockPos contentSize, int owner) {
        int newId = this.getNextId();
        StorageCellData data = new StorageCellData();
        data.contentDimension = contentSize;
        data.owner = owner;
        this.spatialData.put(newId, data);
        return newId;
    }

    @Override
    public void deleteCellDimension(int cellStorageId) {
        StorageCellData removed = this.spatialData.remove(cellStorageId);
        if (removed != null) {
            this.clearCellArea(cellStorageId, removed);
        }
    }

    @Override
    public boolean isCellDimension(int cellStorageId) {
        return this.spatialData.containsKey(cellStorageId);
    }

    @Override
    public int getCellDimensionOwner(int cellStorageId) {
        StorageCellData cell = this.spatialData.get(cellStorageId);
        if (cell != null) {
            return cell.owner;
        }
        return -1;
    }

    @Override
    public BlockPos getCellDimensionOrigin(int cellStorageId) {
        if (this.isCellDimension(cellStorageId)) {
            return this.getBlockPosFromId(cellStorageId);
        }
        return null;
    }

    @Override
    public BlockPos getCellContentSize(int cellStorageId) {
        StorageCellData cell = this.spatialData.get(cellStorageId);
        if (cell != null) {
            return cell.contentDimension;
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == Capabilities.SPATIAL_DIMENSION;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == Capabilities.SPATIAL_DIMENSION) {
            return (T)this;
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Integer, StorageCellData> entry : this.spatialData.entrySet()) {
            NBTTagCompound nbt = entry.getValue().serializeNBT();
            nbt.func_74768_a(NBT_SPATIAL_ID_KEY, entry.getKey().intValue());
            list.func_74742_a((NBTBase)nbt);
        }
        ret.func_74782_a(NBT_SPATIAL_DATA_KEY, (NBTBase)list);
        return ret;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b(NBT_SPATIAL_DATA_KEY)) {
            NBTTagList list = (NBTTagList)nbt.func_74781_a(NBT_SPATIAL_DATA_KEY);
            this.spatialData.clear();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound entry = list.func_150305_b(i);
                StorageCellData data = new StorageCellData();
                int id = entry.func_74762_e(NBT_SPATIAL_ID_KEY);
                data.deserializeNBT(entry);
                this.spatialData.put(id, data);
            }
        }
    }

    private int getNextId() {
        return this.spatialData.keySet().stream().max(Integer::compare).orElse(-1) + 1;
    }

    private BlockPos getBlockPosFromId(int id) {
        int signBits = id & 3;
        int offsetBits = id >> 2;
        int offsetScale = 1;
        int posx = 256;
        int posz = 256;
        while (offsetBits != 0) {
            posx += 512 * offsetScale * (offsetBits & 1);
            posz += 512 * offsetScale * (offsetBits >> 1 & 1);
            offsetBits >>= 2;
            offsetScale <<= 1;
        }
        if ((signBits & 1) == 0) {
            posx *= -1;
        }
        if ((signBits & 2) == 0) {
            posz *= -1;
        }
        return new BlockPos(posx -= 64, 64, posz -= 64);
    }

    private void clearCellArea(int cellId, StorageCellData cell) {
    }

    private static class StorageCellData
    implements INBTSerializable<NBTTagCompound> {
        private static final String NBT_OWNER_KEY = "owner";
        private static final String NBT_DIM_X_KEY = "dim_x";
        private static final String NBT_DIM_Y_KEY = "dim_y";
        private static final String NBT_DIM_Z_KEY = "dim_z";
        public BlockPos contentDimension;
        public int owner;

        private StorageCellData() {
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a(NBT_DIM_X_KEY, this.contentDimension.func_177958_n());
            nbt.func_74768_a(NBT_DIM_Y_KEY, this.contentDimension.func_177956_o());
            nbt.func_74768_a(NBT_DIM_Z_KEY, this.contentDimension.func_177952_p());
            nbt.func_74768_a(NBT_OWNER_KEY, this.owner);
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.contentDimension = new BlockPos(nbt.func_74762_e(NBT_DIM_X_KEY), nbt.func_74762_e(NBT_DIM_Y_KEY), nbt.func_74762_e(NBT_DIM_Z_KEY));
            this.owner = nbt.func_74762_e(NBT_OWNER_KEY);
        }
    }
}

