/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.crafttweaker;

import appeng.api.AEApi;
import appeng.api.features.IGrinderRecipe;
import appeng.api.features.IGrinderRecipeBuilder;
import appeng.integration.modules.crafttweaker.CTModule;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.appliedenergistics2.Grinder")
public class GrinderRecipes {
    private GrinderRecipes() {
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, int turns, @Optional IItemStack secondary1Output, @Optional Float secondary1Chance, @Optional IItemStack secondary2Output, @Optional Float secondary2Chance) {
        Collection inStacks = CTModule.toStacks(input).orElse(Collections.emptySet());
        for (ItemStack inStack : inStacks) {
            ItemStack s2;
            IGrinderRecipeBuilder builder = AEApi.instance().registries().grinder().builder();
            builder.withInput(inStack).withOutput(CTModule.toStack(output)).withTurns(turns);
            ItemStack s1 = CTModule.toStack(secondary1Output);
            if (!s1.func_190926_b()) {
                builder.withFirstOptional(s1, secondary1Chance == null ? 1.0f : secondary1Chance.floatValue());
            }
            if (!(s2 = CTModule.toStack(secondary2Output)).func_190926_b()) {
                builder.withSecondOptional(s2, secondary2Chance == null ? 1.0f : secondary2Chance.floatValue());
            }
            CTModule.MODIFICATIONS.add(new Add(builder.build()));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        for (ItemStack inStack : (Collection)CTModule.toStacks(input).orElse(Collections.emptySet())) {
            CTModule.MODIFICATIONS.add(new Remove(inStack));
        }
    }

    private static class Add
    implements IAction {
        private final IGrinderRecipe entry;

        private Add(IGrinderRecipe entry) {
            this.entry = entry;
        }

        public void apply() {
            AEApi.instance().registries().grinder().addRecipe(this.entry);
        }

        public String describe() {
            return "Adding Grinder Entry for " + this.entry.getInput().func_82833_r();
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack stack;

        private Remove(ItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            IGrinderRecipe recipe = AEApi.instance().registries().grinder().getRecipeForInput(this.stack);
            if (recipe != null) {
                AEApi.instance().registries().grinder().removeRecipe(recipe);
            }
        }

        public String describe() {
            return "Removing Grinder Entry for " + this.stack.func_82833_r();
        }
    }
}

