/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.storage.data.IAEStack;
import io.netty.buffer.ByteBuf;

public abstract class AEStack<T extends IAEStack<T>>
implements IAEStack<T> {
    private boolean isCraftable;
    private long stackSize;
    private long countRequestable;

    protected static long getPacketValue(byte type, ByteBuf tag) {
        if (type == 0) {
            long l = tag.readByte();
            return l -= -128L;
        }
        if (type == 1) {
            long l = tag.readShort();
            return l -= -32768L;
        }
        if (type == 2) {
            long l = tag.readInt();
            return l -= Integer.MIN_VALUE;
        }
        return tag.readLong();
    }

    @Override
    public long getStackSize() {
        return this.stackSize;
    }

    @Override
    public T setStackSize(long ss) {
        this.stackSize = ss;
        return (T)this;
    }

    @Override
    public long getCountRequestable() {
        return this.countRequestable;
    }

    @Override
    public T setCountRequestable(long countRequestable) {
        this.countRequestable = countRequestable;
        return (T)this;
    }

    @Override
    public boolean isCraftable() {
        return this.isCraftable;
    }

    @Override
    public T setCraftable(boolean isCraftable) {
        this.isCraftable = isCraftable;
        return (T)this;
    }

    @Override
    public T reset() {
        this.stackSize = 0L;
        this.setCountRequestable(0L);
        this.setCraftable(false);
        return (T)this;
    }

    @Override
    public T empty() {
        Object dup = this.copy();
        dup.reset();
        return dup;
    }

    @Override
    public boolean isMeaningful() {
        return this.stackSize != 0L || this.countRequestable > 0L || this.isCraftable;
    }

    @Override
    public void incStackSize(long i) {
        this.stackSize += i;
    }

    @Override
    public void decStackSize(long i) {
        this.stackSize -= i;
    }

    @Override
    public void incCountRequestable(long i) {
        this.countRequestable += i;
    }

    @Override
    public void decCountRequestable(long i) {
        this.countRequestable -= i;
    }

    protected byte getType(long num) {
        if (num <= 255L) {
            return 0;
        }
        if (num <= 65535L) {
            return 1;
        }
        if (num <= 0xFFFFFFFFL) {
            return 2;
        }
        return 3;
    }

    protected abstract boolean hasTagCompound();

    protected void putPacketValue(ByteBuf tag, long num) {
        if (num <= 255L) {
            tag.writeByte((int)((byte)(num + -128L)));
        } else if (num <= 65535L) {
            tag.writeShort((int)((short)(num + -32768L)));
        } else if (num <= 0xFFFFFFFFL) {
            tag.writeInt((int)(num + Integer.MIN_VALUE));
        } else {
            tag.writeLong(num);
        }
    }
}

