/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common.render;

import com.elytradev.architecture.common.helpers.Vector3;
import java.util.Arrays;

public class ModelSpec {
    public String modelName;
    public String[] textureNames;
    public Vector3 origin;

    public ModelSpec(String model, String ... textures) {
        this(model, Vector3.zero, textures);
    }

    public ModelSpec(String model, Vector3 origin, String ... textures) {
        this.modelName = model;
        this.textureNames = textures;
        this.origin = origin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelSpec modelSpec = (ModelSpec)o;
        if (this.modelName != null ? !this.modelName.equals(modelSpec.modelName) : modelSpec.modelName != null) {
            return false;
        }
        if (!Arrays.equals(this.textureNames, modelSpec.textureNames)) {
            return false;
        }
        return this.origin != null ? this.origin.equals(modelSpec.origin) : modelSpec.origin == null;
    }

    public int hashCode() {
        int result = this.modelName != null ? this.modelName.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.textureNames);
        result = 31 * result + (this.origin != null ? this.origin.hashCode() : 0);
        return result;
    }
}

