/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common.shape;

import com.elytradev.architecture.common.ArchitectureLog;
import com.elytradev.architecture.common.helpers.Profile;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecture.common.helpers.Vector3;
import com.elytradev.architecture.common.shape.EnumShapeSymmetry;
import com.elytradev.architecture.common.shape.ShapeKind;
import com.elytradev.architecture.common.shape.WindowShapeKinds;
import com.elytradev.architecture.common.tile.TileShape;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;

public enum EnumShape {
    ROOF_TILE(0, "architecturecraft.shape.roof_tile", ShapeKind.Roof, EnumShapeSymmetry.BILATERAL, 1, 2, 207),
    ROOF_OUTER_CORNER(1, "architecturecraft.shape.roof_outer_corner", ShapeKind.Roof, EnumShapeSymmetry.UNILATERAL, 1, 3, 79),
    ROOF_INNER_CORNER(2, "architecturecraft.shape.roof_inner_corner", ShapeKind.Roof, EnumShapeSymmetry.UNILATERAL, 2, 3, 223),
    ROOF_RIDGE(3, "architecturecraft.shape.roof_ridge", ShapeKind.Roof, EnumShapeSymmetry.BILATERAL, 1, 4, 15),
    ROOF_SMART_RIDGE(4, "architecturecraft.shape.roof_smart_ridge", ShapeKind.Roof, EnumShapeSymmetry.QUADRILATERAL, 1, 2, 15),
    ROOF_VALLEY(5, "architecturecraft.shape.roof_valley", ShapeKind.Roof, EnumShapeSymmetry.BILATERAL, 1, 2, 255),
    ROOF_SMART_VALLEY(6, "architecturecraft.shape.roof_smart_valley", ShapeKind.Roof, EnumShapeSymmetry.QUADRILATERAL, 1, 1, 255),
    ROOF_OVERHANG(7, "architecturecraft.shape.roof_overhang", ShapeKind.Model("roof_overhang"), EnumShapeSymmetry.BILATERAL, 1, 2, 207),
    ROOF_OVERHANG_OUTER_CORNER(8, "architecturecraft.shape.roof_overhang_outer_corner", ShapeKind.Model("roof_overhang_outer_corner"), EnumShapeSymmetry.UNILATERAL, 1, 3, 79),
    ROOF_OVERHANG_INNER_CORNER(9, "architecturecraft.shape.roof_overhang_inner_corner", ShapeKind.Model("roof_overhang_inner_corner"), EnumShapeSymmetry.UNILATERAL, 2, 3, 223),
    CYLINDER(10, "architecturecraft.shape.cylinder", ShapeKind.Model("cylinder_full_r8h16"), EnumShapeSymmetry.QUADRILATERAL, 1, 1, 255),
    CYLINDER_HALF(11, "architecturecraft.shape.cylinder_half", ShapeKind.Model("cylinder_half_r8h16"), EnumShapeSymmetry.BILATERAL, 1, 1, 204),
    CYLINDER_QUARTER(12, "architecturecraft.shape.cylinder_quarter", ShapeKind.Model("cylinder_quarter_r8h16"), EnumShapeSymmetry.UNILATERAL, 1, 1, 68),
    CYLINDER_LARGE_QUARTER(13, "architecturecraft.shape.cylinder_large_quarter", ShapeKind.Model("cylinder_quarter_r16h16"), EnumShapeSymmetry.UNILATERAL, 1, 1, 255),
    ANTICYLINDER_LARGE_QUARTER(14, "architecturecraft.shape.anticylinder_large_quarter", ShapeKind.Model("round_inner_corner"), EnumShapeSymmetry.UNILATERAL, 1, 2, 221),
    PILLAR(15, "architecturecraft.shape.pillar", ShapeKind.Model("cylinder_r6h16"), EnumShapeSymmetry.QUADRILATERAL, 1, 1, 262),
    POST(16, "architecturecraft.shape.post", ShapeKind.Model("cylinder_r4h16"), EnumShapeSymmetry.QUADRILATERAL, 1, 4, 260),
    POLE(17, "architecturecraft.shape.pole", ShapeKind.Model("cylinder_r2h16"), EnumShapeSymmetry.QUADRILATERAL, 1, 16, 258),
    BEVELLED_OUTER_CORNER(18, "architecturecraft.shape.bevelled_outer_corner", ShapeKind.Model("bevelled_outer_corner"), EnumShapeSymmetry.UNILATERAL, 1, 3, 79),
    BEVELLED_INNER_CORNER(19, "architecturecraft.shape.bevelled_inner_corner", ShapeKind.Model("bevelled_inner_corner"), EnumShapeSymmetry.UNILATERAL, 1, 1, 223),
    PILLAR_BASE(20, "architecturecraft.shape.pillar_base", ShapeKind.Model("pillar_base"), EnumShapeSymmetry.QUADRILATERAL, 1, 1, 255),
    DORIC_CAPITAL(21, "architecturecraft.shape.doric_capital", ShapeKind.Model("doric_capital"), EnumShapeSymmetry.QUADRILATERAL, 1, 1, 255),
    IONIC_CAPITAL(22, "architecturecraft.shape.ionic_capital", ShapeKind.Model("ionic_capital"), EnumShapeSymmetry.BILATERAL, 1, 1, 255),
    CORINTHIAN_CAPITAL(23, "architecturecraft.shape.corinthian_capital", ShapeKind.Model("corinthian_capital"), EnumShapeSymmetry.QUADRILATERAL, 1, 1, 255),
    DORIC_TRIGLYPH(24, "architecturecraft.shape.doric_triglyph", ShapeKind.Model("doric_triglyph", (Object[])Profile.Generic.lrStraight), EnumShapeSymmetry.BILATERAL, 1, 1, 255),
    DORIC_TRIGLYPH_CORNER(25, "architecturecraft.shape.doric_triglyph_corner", ShapeKind.Model("doric_triglyph_corner", (Object[])Profile.Generic.lrCorner), EnumShapeSymmetry.BILATERAL, 1, 1, 255),
    DORIC_METOPE(26, "architecturecraft.shape.doric_metope", ShapeKind.Model("doric_metope", (Object[])Profile.Generic.lrStraight), EnumShapeSymmetry.BILATERAL, 1, 1, 255),
    ARCHITRAVE(27, "architecturecraft.shape.architrave", ShapeKind.Model("architrave", (Object[])Profile.Generic.lrStraight), EnumShapeSymmetry.BILATERAL, 1, 1, 255),
    ARCHITRAVE_CORNER(28, "architecturecraft.shape.architrave_corner", ShapeKind.Model("architrave_corner", (Object[])Profile.Generic.lrCorner), EnumShapeSymmetry.UNILATERAL, 1, 1, 255),
    WINDOW_FRAME(30, "architecturecraft.shape.window_frame", WindowShapeKinds.PlainWindow, EnumShapeSymmetry.BILATERAL, 1, 4, 514),
    WINDOW_CORNER(31, "architecturecraft.shape.window_corner", WindowShapeKinds.CornerWindow, EnumShapeSymmetry.UNILATERAL, 1, 2, 514),
    WINDOW_MULLION(32, "architecturecraft.shape.window_mullion", WindowShapeKinds.MullionWindow, EnumShapeSymmetry.BILATERAL, 1, 2, 514),
    SPHERE_FULL(33, "architecturecraft.shape.sphere_full", ShapeKind.Model("sphere_full_r8"), EnumShapeSymmetry.QUADRILATERAL, 1, 1, 255),
    SPHERE_HALF(34, "architecturecraft.shape.sphere_half", ShapeKind.Model("sphere_half_r8"), EnumShapeSymmetry.QUADRILATERAL, 1, 2, 15),
    SPHERE_QUARTER(35, "architecturecraft.shape.sphere_quarter", ShapeKind.Model("sphere_quarter_r8"), EnumShapeSymmetry.BILATERAL, 1, 4, 12),
    SPHERE_EIGHTH(36, "architecturecraft.shape.sphere_eighth", ShapeKind.Model("sphere_eighth_r8"), EnumShapeSymmetry.UNILATERAL, 1, 8, 4),
    SPHERE_EIGHTH_LARGE(37, "architecturecraft.shape.sphere_eighth_large", ShapeKind.Model("sphere_eighth_r16"), EnumShapeSymmetry.UNILATERAL, 1, 1, 255),
    SPHERE_EIGHTH_LARGE_REV(38, "architecturecraft.shape.sphere_eighth_large_rev", ShapeKind.Model("sphere_eighth_r16_rev"), EnumShapeSymmetry.UNILATERAL, 1, 1, 223),
    ROOF_OVERHANG_GABLE_LH(40, "architecturecraft.shape.roof_overhang_gable_lh", ShapeKind.Model("roof_overhang_gable_lh"), EnumShapeSymmetry.BILATERAL, 1, 4, 72),
    ROOF_OVERHANG_GABLE_RH(41, "architecturecraft.shape.roof_overhang_gable_rh", ShapeKind.Model("roof_overhang_gable_rh"), EnumShapeSymmetry.BILATERAL, 1, 4, 132),
    ROOF_OVERHANG_GABLE_END_LH(42, "architecturecraft.shape.roof_overhang_gable_end_lh", ShapeKind.Model("roof_overhang_gable_end_lh"), EnumShapeSymmetry.BILATERAL, 1, 4, 72),
    ROOF_OVERHANG_GABLE_END_RH(43, "architecturecraft.shape.roof_overhang_gable_end_rh", ShapeKind.Model("roof_overhang_gable_end_rh"), EnumShapeSymmetry.BILATERAL, 1, 4, 72),
    ROOF_OVERHANG_RIDGE(44, "architecturecraft.shape.roof_overhang_ridge", ShapeKind.Model("roof_overhang_gable_ridge"), EnumShapeSymmetry.BILATERAL, 1, 4, 12),
    ROOF_OVERHANG_VALLEY(45, "architecturecraft.shape.roof_overhang_valley", ShapeKind.Model("roof_overhang_gable_valley"), EnumShapeSymmetry.BILATERAL, 1, 4, 204),
    CORNICE_LH(50, "architecturecraft.shape.cornice_lh", ShapeKind.Model("cornice_lh"), EnumShapeSymmetry.BILATERAL, 1, 4, 72),
    CORNICE_RH(51, "architecturecraft.shape.cornice_rh", ShapeKind.Model("cornice_rh"), EnumShapeSymmetry.BILATERAL, 1, 4, 132),
    CORNICE_END_LH(52, "architecturecraft.shape.cornice_end_lh", ShapeKind.Model("cornice_end_lh"), EnumShapeSymmetry.BILATERAL, 1, 4, 72),
    CORNICE_END_RH(53, "architecturecraft.shape.cornice_end_rh", ShapeKind.Model("cornice_end_rh"), EnumShapeSymmetry.BILATERAL, 1, 4, 72),
    CORNICE_RIDGE(54, "architecturecraft.shape.cornice_ridge", ShapeKind.Model("cornice_ridge"), EnumShapeSymmetry.BILATERAL, 1, 4, 12),
    CORNICE_VALLEY(55, "architecturecraft.shape.cornice_valley", ShapeKind.Model("cornice_valley"), EnumShapeSymmetry.BILATERAL, 1, 4, 204),
    CORNICE_BOTTOM(56, "architecturecraft.shape.cornice_bottom", ShapeKind.Model("cornice_bottom"), EnumShapeSymmetry.BILATERAL, 1, 4, 12),
    CLADDING_SHEET(60, "architecturecraft.shape.cladding_sheet", ShapeKind.Cladding, null, 1, 16, 0),
    ARCH_D_1(61, "architecturecraft.shape.arch_d_1", ShapeKind.Model("arch_d1"), EnumShapeSymmetry.BILATERAL, 1, 1, 255, 1),
    ARCH_D_2(62, "architecturecraft.shape.arch_d_2", ShapeKind.Model("arch_d2"), EnumShapeSymmetry.BILATERAL, 1, 2, 252, 1),
    ARCH_D_3_A(63, "architecturecraft.shape.arch_d_3_a", ShapeKind.Model("arch_d3a"), EnumShapeSymmetry.BILATERAL, 1, 2, 204, 1),
    ARCH_D_3_B(64, "architecturecraft.shape.arch_d_3_b", ShapeKind.Model("arch_d3b"), EnumShapeSymmetry.BILATERAL, 1, 1, 252, 1),
    ARCH_D_3_C(65, "architecturecraft.shape.arch_d_3_c", ShapeKind.Model("arch_d3c"), EnumShapeSymmetry.BILATERAL, 1, 1, 255, 1),
    ARCH_D_4_A(66, "architecturecraft.shape.arch_d_4_a", ShapeKind.Model("arch_d4a"), EnumShapeSymmetry.BILATERAL, 1, 2, 204, 1),
    ARCH_D_4_B(67, "architecturecraft.shape.arch_d_4_b", ShapeKind.Model("arch_d4b"), EnumShapeSymmetry.BILATERAL, 1, 1, 252, 1),
    ARCH_D_4_C(68, "architecturecraft.shape.arch_d_4_c", ShapeKind.Model("arch_d4c"), EnumShapeSymmetry.BILATERAL, 1, 2, 0, 1),
    BANISTER_PLAIN_BOTTOM(70, "architecturecraft.shape.banister_plain_bottom", ShapeKind.Banister("balustrade_stair_plain_bottom"), EnumShapeSymmetry.BILATERAL, 1, 10, 0, 2),
    BANISTER_PLAIN(71, "architecturecraft.shape.banister_plain", ShapeKind.Banister("balustrade_stair_plain"), EnumShapeSymmetry.BILATERAL, 1, 10, 0, 2),
    BANISTER_PLAIN_TOP(72, "architecturecraft.shape.banister_plain_top", ShapeKind.Banister("balustrade_stair_plain_top"), EnumShapeSymmetry.BILATERAL, 1, 10, 0, 2),
    BALUSTRADE_FANCY(73, "architecturecraft.shape.balustrade_fancy", ShapeKind.Model("balustrade_fancy"), EnumShapeSymmetry.BILATERAL, 1, 5, 0),
    BALUSTRADE_FANCY_CORNER(74, "architecturecraft.shape.balustrade_fancy_corner", ShapeKind.Model("balustrade_fancy_corner"), EnumShapeSymmetry.UNILATERAL, 1, 2, 0),
    BALUSTRADE_FANCY_WITH_NEWEL(75, "architecturecraft.shape.balustrade_fancy_with_newel", ShapeKind.Model("balustrade_fancy_with_newel"), EnumShapeSymmetry.BILATERAL, 1, 3, 0),
    BALUSTRADE_FANCY_NEWEL(76, "architecturecraft.shape.balustrade_fancy_newel", ShapeKind.Model("balustrade_fancy_newel"), EnumShapeSymmetry.UNILATERAL, 1, 4, 0),
    BALUSTRADE_PLAIN(77, "architecturecraft.shape.balustrade_plain", ShapeKind.Model("balustrade_plain"), EnumShapeSymmetry.BILATERAL, 1, 10, 0),
    BALUSTRADE_PLAIN_OUTER_CORNER(78, "architecturecraft.shape.balustrade_plain_outer_corner", ShapeKind.Model("balustrade_plain_outer_corner"), EnumShapeSymmetry.UNILATERAL, 1, 4, 0),
    BALUSTRADE_PLAIN_WITH_NEWEL(79, "architecturecraft.shape.balustrade_plain_with_newel", ShapeKind.Model("balustrade_plain_with_newel"), EnumShapeSymmetry.BILATERAL, 1, 6, 0),
    BANISTER_PLAIN_END(80, "architecturecraft.shape.banister_plain_end", ShapeKind.Banister("balustrade_stair_plain_end"), EnumShapeSymmetry.BILATERAL, 1, 8, 0, 2),
    BANISTER_FANCY_NEWEL_TALL(81, "architecturecraft.shape.banister_fancy_newel_tall", ShapeKind.Model("balustrade_fancy_newel_tall"), EnumShapeSymmetry.UNILATERAL, 1, 2, 0),
    BALUSTRADE_PLAIN_INNER_CORNER(82, "architecturecraft.shape.balustrade_plain_inner_corner", ShapeKind.Model("balustrade_plain_inner_corner"), EnumShapeSymmetry.UNILATERAL, 1, 8, 0),
    BALUSTRADE_PLAIN_END(83, "architecturecraft.shape.balustrade_plain_end", ShapeKind.Banister("balustrade_plain_end"), EnumShapeSymmetry.BILATERAL, 1, 8, 0, 2),
    BANISTER_FANCY_BOTTOM(84, "architecturecraft.shape.banister_fancy_bottom", ShapeKind.Banister("balustrade_stair_fancy_bottom"), EnumShapeSymmetry.BILATERAL, 1, 5, 0, 2),
    BANISTER_FANCY(85, "architecturecraft.shape.banister_fancy", ShapeKind.Banister("balustrade_stair_fancy"), EnumShapeSymmetry.BILATERAL, 1, 5, 0, 2),
    BANISTER_FANCY_TOP(86, "architecturecraft.shape.banister_fancy_top", ShapeKind.Banister("balustrade_stair_fancy_top"), EnumShapeSymmetry.BILATERAL, 1, 5, 0, 2),
    BANISTER_FANCY_END(87, "architecturecraft.shape.banister_fancy_end", ShapeKind.Banister("balustrade_stair_fancy_end"), EnumShapeSymmetry.BILATERAL, 1, 2, 0, 2),
    BANISTER_PLAIN_INNER_CORNER(88, "architecturecraft.shape.banister_plain_inner_corner", ShapeKind.Model("balustrade_stair_plain_inner_corner"), EnumShapeSymmetry.UNILATERAL, 1, 6, 0),
    SLAB(90, "architecturecraft.shape.slab", ShapeKind.Model("slab"), EnumShapeSymmetry.QUADRILATERAL, 1, 2, 0),
    STAIRS(91, "architecturecraft.shape.stairs", ShapeKind.Model("stairs", (Object[])Profile.Generic.lrStraight), EnumShapeSymmetry.BILATERAL, 3, 4, 0),
    STAIRS_OUTER_CORNER(92, "architecturecraft.shape.stairs_outer_corner", ShapeKind.Model("stairs_outer_corner", (Object[])Profile.Generic.lrCorner), EnumShapeSymmetry.UNILATERAL, 2, 3, 0),
    STAIRS_INNER_CORNER(93, "architecturecraft.shape.stairs_inner_corner", ShapeKind.Model("stairs_inner_corner", (Object[])Profile.Generic.rlCorner), EnumShapeSymmetry.UNILATERAL, 1, 1, 0);

    public static EnumShape[] values;
    public static boolean debugPlacement;
    protected static Map<Integer, EnumShape> idMap;
    public int id;
    public String translationKey;
    public ShapeKind kind;
    public EnumShapeSymmetry symmetry;
    public int materialUsed;
    public int itemsProduced;
    public int occlusionMask;
    public int flags;

    private EnumShape(int id, String translationKey, ShapeKind kind, EnumShapeSymmetry sym, int used, int made, int occ) {
        this(id, translationKey, kind, sym, used, made, occ, 0);
    }

    private EnumShape(int id, String translationKey, ShapeKind kind, EnumShapeSymmetry sym, int used, int made, int occ, int flags) {
        this.id = id;
        this.translationKey = translationKey;
        this.kind = kind;
        this.symmetry = sym;
        this.materialUsed = used;
        this.itemsProduced = made;
        this.occlusionMask = occ;
        this.flags = flags;
    }

    public static EnumShape forId(int id) {
        EnumShape shape = idMap.get(id);
        if (shape == null) {
            shape = ROOF_TILE;
        }
        return shape;
    }

    public static int turnForPlacementHit(int side, Vector3 hit, EnumShapeSymmetry symmetry) {
        Vector3 h = Trans3.sideTurn(side, 0).ip(hit);
        return EnumShape.turnForPlacementHit(symmetry, h.x, h.z);
    }

    private static int turnForPlacementHit(EnumShapeSymmetry symmetry, double x, double z) {
        switch (symmetry) {
            case QUADRILATERAL: {
                return 0;
            }
            case BILATERAL: {
                if (Math.abs(z) > Math.abs(x)) {
                    return z < 0.0 ? 2 : 0;
                }
                return x > 0.0 ? 1 : 3;
            }
            case UNILATERAL: {
                if (z > 0.0) {
                    return x < 0.0 ? 0 : 1;
                }
                return x > 0.0 ? 2 : 3;
            }
        }
        return 0;
    }

    public void orientOnPlacement(EntityPlayer player, TileShape shape, BlockPos neighbourPos, IBlockState neighbourState, TileEntity neighbourTile, EnumFacing face, Vector3 hit) {
        if (!shape.getShape().kind.orientOnPlacement(player, shape, neighbourPos, neighbourState, neighbourTile, face, hit)) {
            this.orientFromHitPosition(player, shape, face, hit);
        }
    }

    protected void orientFromHitPosition(EntityPlayer player, TileShape shape, EnumFacing face, Vector3 hit) {
        int side;
        switch (face) {
            case UP: {
                side = this.rightSideUpSide();
                break;
            }
            case DOWN: {
                if (shape.getShape().kind.canPlaceUpsideDown()) {
                    side = this.upsideDownSide();
                    break;
                }
                side = this.rightSideUpSide();
                break;
            }
            default: {
                side = player.func_70093_af() ? face.func_176734_d().ordinal() : (hit.y > 0.0 && shape.getShape().kind.canPlaceUpsideDown() ? this.upsideDownSide() : this.rightSideUpSide());
            }
        }
        int turn = EnumShape.turnForPlacementHit(side, hit, this.symmetry);
        if (debugPlacement && !shape.func_145831_w().field_72995_K) {
            ArchitectureLog.info("Shape.orientFromHitPosition: face {} global hit {}", face, hit);
            ArchitectureLog.info("Shape.orientFromHitPosition: side {} turn {} symmetry {}", new Object[]{side, turn, shape.getShape().symmetry});
        }
        shape.setSide(side);
        shape.setTurn(turn);
        if ((this.flags & 2) != 0) {
            shape.setOffsetX(this.offsetXForPlacementHit(side, turn, hit));
            if (debugPlacement && !shape.func_145831_w().field_72995_K) {
                ArchitectureLog.info("Shape.orientFromHitPosition: kind = %s offsetX = %.3f\n", this.kind, shape.getOffsetX());
            }
        }
    }

    public double offsetXForPlacementHit(int side, int turn, Vector3 hit) {
        Vector3 h = Trans3.sideTurn(side, turn).ip(hit);
        return this.signedPlacementOffsetX(h.x);
    }

    public double signedPlacementOffsetX(double sign) {
        double offx = this.kind.placementOffsetX();
        if (sign < 0.0) {
            offx = -offx;
        }
        return offx;
    }

    protected int rightSideUpSide() {
        if (this.isPlacedUnderneath()) {
            return 1;
        }
        return 0;
    }

    protected int upsideDownSide() {
        if (this.isPlacedUnderneath()) {
            return 0;
        }
        return 1;
    }

    public String getLocalizedShapeName() {
        return I18n.func_74837_a((String)this.translationKey, (Object[])new Object[0]);
    }

    protected boolean isPlacedUnderneath() {
        return (this.flags & 1) != 0;
    }

    public boolean isCladding() {
        return this == CLADDING_SHEET;
    }

    static {
        values = EnumShape.values();
        debugPlacement = false;
        idMap = new HashMap<Integer, EnumShape>();
        for (EnumShape s : values) {
            idMap.put(s.id, s);
        }
    }
}

