/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.gui.widget;

import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.ConcreteFluidTank;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.FluidTankProxySlot;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.gui.ConcreteContainer;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.gui.client.GuiDrawing;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.gui.widget.WWidget;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WFluidBar
extends WWidget {
    private final ResourceLocation bg;
    private final ResourceLocation fg;
    private final ConcreteFluidTank concreteFluidTank;
    private final Direction direction;
    private String tooltipLabel;

    public WFluidBar(ResourceLocation bg, ConcreteFluidTank tank) {
        this(bg, tank, Direction.UP);
    }

    public WFluidBar(ResourceLocation bg, ConcreteFluidTank tank, Direction dir) {
        this(bg, null, tank, dir);
    }

    public WFluidBar(ResourceLocation bg, ResourceLocation fg, ConcreteFluidTank tank) {
        this(bg, fg, tank, Direction.UP);
    }

    public WFluidBar(ResourceLocation bg, ResourceLocation fg, ConcreteFluidTank tank, Direction dir) {
        this.bg = bg;
        this.fg = fg;
        this.concreteFluidTank = tank;
        this.direction = dir;
    }

    public WFluidBar withTooltip(String label) {
        this.setRenderTooltip(true);
        this.tooltipLabel = label;
        return this;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public void createPeers(ConcreteContainer c) {
        c.addSlotPeer(new FluidTankProxySlot(this.concreteFluidTank));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void paintBackground(int x, int y) {
        int barSize;
        GuiDrawing.rect(this.bg, x, y, this.getWidth(), this.getHeight(), -1);
        if (this.concreteFluidTank.getFluid() == null) {
            return;
        }
        float percent = (float)this.concreteFluidTank.getFluidAmount() / (float)this.concreteFluidTank.getCapacity();
        if (percent < 0.0f) {
            percent = 0.0f;
        }
        if (percent > 1.0f) {
            percent = 1.0f;
        }
        int barMax = this.getWidth();
        if (this.direction == Direction.DOWN || this.direction == Direction.UP) {
            barMax = this.getHeight();
        }
        if ((barSize = (int)((float)barMax * (percent = (float)((int)(percent * (float)barMax)) / (float)barMax))) <= 0) {
            return;
        }
        Fluid fluid = this.concreteFluidTank.getFluid().getFluid();
        switch (this.direction) {
            case UP: {
                int left = x;
                int bottom = y + this.getHeight();
                int verticalSegments = barSize / 16;
                int horizontalSegments = this.getWidth() / 16;
                for (int dY = 0; dY < verticalSegments; ++dY) {
                    for (int dX = 0; dX < horizontalSegments; ++dX) {
                        GuiDrawing.rect(fluid, left + dX * 16, bottom - (dY + 1) * 16, 16, 16, 0.0f, 0.0f, 16.0f, 16.0f, -1);
                    }
                    GuiDrawing.rect(fluid, left + horizontalSegments * 16, bottom - (dY + 1) * 16, this.getWidth() % 16, 16, 0.0f, 0.0f, (float)(this.getWidth() % 16), 16.0f, -1);
                }
                for (int dX = 0; dX < horizontalSegments; ++dX) {
                    GuiDrawing.rect(fluid, left + dX * 16, bottom - verticalSegments * 16 - barSize % 16, 16, barSize % 16, 0.0f, (float)(16 - barSize % 16), 16.0f, 16.0f, -1);
                }
                GuiDrawing.rect(fluid, left + horizontalSegments * 16, bottom - verticalSegments * 16 - barSize % 16, this.getWidth() % 16, barSize % 16, 0.0f, (float)(16 - barSize % 16), (float)(this.getWidth() % 16), 16.0f, -1);
                break;
            }
            case LEFT: {
                int left = x + this.getWidth();
                left -= barSize;
                int top = y;
                int verticalSegments = this.getHeight() / 16;
                int horizontalSegments = barSize / 16;
                for (int dX = 0; dX < horizontalSegments; ++dX) {
                    for (int dY = 0; dY < verticalSegments; ++dY) {
                        GuiDrawing.rect(fluid, left + dX * 16, y + dY * 16, 16, 16, 0.0f, 0.0f, 16.0f, 16.0f, -1);
                    }
                    GuiDrawing.rect(fluid, left + dX * 16, y + verticalSegments * 16, 16, this.getHeight() % 16, 0.0f, 0.0f, 16.0f, (float)(this.getHeight() % 16), -1);
                }
                if (barSize % 16 == 0) break;
                for (int dY = 0; dY < verticalSegments; ++dY) {
                    GuiDrawing.rect(fluid, left + horizontalSegments * 16, y + dY * 16, barSize % 16, 16, 0.0f, 0.0f, (float)(barSize % 16), 16.0f, -1);
                }
                GuiDrawing.rect(fluid, left + horizontalSegments * 16, y + verticalSegments * 16, barSize % 16, this.getHeight() % 16, 0.0f, 0.0f, (float)(barSize % 16), (float)(this.getHeight() % 16), -1);
                break;
            }
            case DOWN: {
                int left = x;
                int top = y + this.getHeight();
                top -= barSize;
                int verticalSegments = barSize / 16;
                int horizontalSegments = this.getWidth() / 16;
                for (int dY = 0; dY < verticalSegments; ++dY) {
                    for (int dX = 0; dX < horizontalSegments; ++dX) {
                        GuiDrawing.rect(fluid, left + dX * 16, y + dY * 16, 16, 16, 0.0f, 0.0f, 16.0f, 16.0f, -1);
                    }
                    GuiDrawing.rect(fluid, left + horizontalSegments * 16, y + dY * 16, this.getWidth() % 16, 16, 0.0f, 0.0f, (float)(this.getWidth() % 16), 16.0f, -1);
                }
                for (int dX = 0; dX < horizontalSegments; ++dX) {
                    GuiDrawing.rect(fluid, left + dX * 16, y + verticalSegments * 16, 16, barSize % 16, 0.0f, 0.0f, 16.0f, (float)(barSize % 16), -1);
                }
                GuiDrawing.rect(fluid, left + horizontalSegments * 16, y + verticalSegments * 16, this.getWidth() % 16, barSize % 16, 0.0f, 0.0f, (float)(this.getWidth() % 16), (float)(barSize % 16), -1);
                break;
            }
            case RIGHT: {
                int left = x;
                int top = y;
                int verticalSegments = this.getHeight() / 16;
                int horizontalSegments = barSize / 16;
                for (int dX = 0; dX < horizontalSegments; ++dX) {
                    for (int dY = 0; dY < verticalSegments; ++dY) {
                        GuiDrawing.rect(fluid, left + dX * 16, y + dY * 16, 16, 16, 0.0f, 0.0f, 16.0f, 16.0f, -1);
                    }
                    GuiDrawing.rect(fluid, left + dX * 16, y + verticalSegments * 16, 16, this.getHeight() % 16, 0.0f, 0.0f, 16.0f, (float)(this.getHeight() % 16), -1);
                }
                if (barSize % 16 == 0) break;
                for (int dY = 0; dY < verticalSegments; ++dY) {
                    GuiDrawing.rect(fluid, left + horizontalSegments * 16, y + dY * 16, barSize % 16, 16, 0.0f, 0.0f, (float)(barSize % 16), 16.0f, -1);
                }
                GuiDrawing.rect(fluid, left + horizontalSegments * 16, y + verticalSegments * 16, barSize % 16, this.getHeight() % 16, 0.0f, 0.0f, (float)(barSize % 16), (float)(this.getHeight() % 16), -1);
                break;
            }
        }
        if (this.fg != null) {
            GuiDrawing.rect(this.fg, x, y, this.getWidth(), this.getHeight(), -1);
        }
    }

    @Override
    public void addInformation(List<String> information) {
        int value = this.concreteFluidTank.getFluidAmount();
        int valMax = this.concreteFluidTank.getCapacity();
        information.add(String.format(this.tooltipLabel, value, valMax));
    }

    public static enum Direction {
        UP,
        RIGHT,
        DOWN,
        LEFT;

    }
}

