/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecturecraft.repackage.com.elytradev.concrete.resgen;

import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.common.ConcreteLog;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.common.ShadingValidator;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.reflect.accessor.Accessor;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.reflect.accessor.Accessors;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.reflect.invoker.Invoker;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.reflect.invoker.Invokers;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.resgen.BlockModelResourceProvider;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.resgen.BlockStateResourceProvider;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.resgen.ItemModelResourceProvider;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.resgen.MissingRealpackException;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.resgen.ResourceProvider;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.LegacyV2Adapter;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ConcreteResourcePack
extends AbstractResourcePack {
    private static Accessor<List<IResourcePack>> resourcePackList;
    private static Accessor<File> resourcePackFile;
    private static Accessor<IResourcePack> legacyPack;
    private static Accessor<Map<String, FallbackResourceManager>> domainResourceManagers;
    private static Accessor<List<IResourcePack>> resourcePacks;
    private static Invoker hasResourceName;
    private static Invoker getInputStreamByName;
    public AbstractResourcePack realResourcePack;
    public String modID;
    public List<ResourceProvider> providers;

    public ConcreteResourcePack(String modID) {
        super(ConcreteResourcePack.getPackFileByModID(modID));
        this.modID = modID;
        this.providers = Lists.newArrayList((Object[])new ResourceProvider[]{new BlockStateResourceProvider(this), new BlockModelResourceProvider(this), new ItemModelResourceProvider(this)});
        IResourcePack realPack = FMLClientHandler.instance().getResourcePackFor(modID);
        if (realPack instanceof LegacyV2Adapter) {
            this.realResourcePack = (AbstractResourcePack)legacyPack.get(realPack);
        } else if (realPack instanceof AbstractResourcePack) {
            this.realResourcePack = (AbstractResourcePack)realPack;
        }
        if (realPack == null || this.realResourcePack == null) {
            throw new MissingRealpackException(modID);
        }
        resourcePackList.get(FMLClientHandler.instance()).add(resourcePackList.get(FMLClientHandler.instance()).indexOf(realPack), (IResourcePack)this);
        if (Minecraft.func_71410_x().func_110442_L() instanceof SimpleReloadableResourceManager) {
            FallbackResourceManager domainManager = domainResourceManagers.get(Minecraft.func_71410_x().func_110442_L()).get(modID);
            resourcePacks.get(domainManager).add(resourcePacks.get(domainManager).indexOf(realPack), (IResourcePack)this);
        }
    }

    private static File getPackFileByModID(String modID) {
        IResourcePack pack = FMLClientHandler.instance().getResourcePackFor(modID);
        if (pack instanceof LegacyV2Adapter) {
            return resourcePackFile.get(legacyPack.get(pack));
        }
        if (pack instanceof AbstractResourcePack) {
            return resourcePackFile.get(pack);
        }
        return null;
    }

    public static ResourceLocation nameToLocation(String name) {
        name = name.substring(name.indexOf("/") + 1);
        String domain = name.substring(0, name.indexOf("/"));
        String path = name.substring(name.indexOf("/") + 1);
        ConcreteLog.debug("Converted {} to {}", name, new ResourceLocation(domain, path));
        return new ResourceLocation(domain, path);
    }

    public static BiMap<Pair<IRegistryDelegate<Item>, Integer>, ModelResourceLocation> getCustomModels() {
        try {
            Field field = ModelLoader.class.getDeclaredField("customModels");
            Map readField = (Map)FieldUtils.readStaticField((Field)field, (boolean)true);
            HashBiMap customModels = HashBiMap.create((int)readField.size());
            readField.forEach((arg_0, arg_1) -> ((BiMap)customModels).forcePut(arg_0, arg_1));
            return customModels;
        }
        catch (Exception e) {
            ConcreteLog.error("Caught exception getting customModels from the model loader, ", (Throwable)e);
            return HashBiMap.create();
        }
    }

    public InputStream func_110591_a(String name) throws IOException {
        ConcreteLog.debug("ConcreteResourcePack was asked to obtain: {}", name);
        for (int i = 0; i < this.providers.size(); ++i) {
            if (!this.providers.get(i).canProvide(name)) continue;
            return this.providers.get(i).provide(name);
        }
        return (InputStream)getInputStreamByName.invoke(this.realResourcePack, name);
    }

    public boolean func_110593_b(String name) {
        for (ResourceProvider provider : this.providers) {
            if (!provider.canProvide(name)) continue;
            return true;
        }
        return false;
    }

    public Set<String> func_110587_b() {
        return Collections.singleton(this.modID);
    }

    public Item getItem(String name) {
        String itemID = name.substring(name.lastIndexOf("/") + 1, name.lastIndexOf("."));
        if (Item.func_111206_d((String)(this.modID + ":" + itemID)) != null) {
            return Item.func_111206_d((String)(this.modID + ":" + itemID));
        }
        ResourceLocation location = ConcreteResourcePack.nameToLocation(name);
        try {
            BiMap<Pair<IRegistryDelegate<Item>, Integer>, ModelResourceLocation> customModelsMap = ConcreteResourcePack.getCustomModels();
            String resourcePath = location.func_110623_a();
            resourcePath = resourcePath.substring(resourcePath.lastIndexOf("/") + 1);
            resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf("."));
            String domain = location.func_110624_b();
            location = new ModelResourceLocation(domain + ":" + resourcePath, this.isLocation(name, "/models/item/") ? "inventory" : "normal");
            if (customModelsMap.inverse().containsKey((Object)location)) {
                return (Item)((IRegistryDelegate)((Pair)customModelsMap.inverse().get((Object)location)).getLeft()).get();
            }
        }
        catch (Exception e) {
            ConcreteLog.error("Failed to get item from ResourceLocation", (Throwable)e);
        }
        return Items.field_190931_a;
    }

    public Integer getMetaFromName(String name) {
        ResourceLocation location = ConcreteResourcePack.nameToLocation(name);
        try {
            BiMap<Pair<IRegistryDelegate<Item>, Integer>, ModelResourceLocation> customModelsMap = ConcreteResourcePack.getCustomModels();
            String resourcePath = location.func_110623_a();
            resourcePath = resourcePath.substring(resourcePath.lastIndexOf("/") + 1);
            resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf("."));
            String domain = location.func_110624_b();
            location = new ModelResourceLocation(domain + ":" + resourcePath, this.isLocation(name, "/models/item/") ? "inventory" : "normal");
            if (customModelsMap.inverse().containsKey((Object)location)) {
                return (Integer)((Pair)customModelsMap.inverse().get((Object)location)).getRight();
            }
        }
        catch (Exception e) {
            ConcreteLog.error("Failed to get metadata from name", (Throwable)e);
        }
        return 0;
    }

    public boolean realpackHasResourceName(String name) {
        return (Boolean)hasResourceName.invoke(this.realResourcePack, name);
    }

    public InputStream getRealpackInputStreamByName(String name) {
        return (InputStream)getInputStreamByName.invoke(this.realResourcePack, name);
    }

    private boolean isLocation(String place, String validation) {
        return place.startsWith("assets/" + this.modID + validation) && place.endsWith(".json");
    }

    static {
        ShadingValidator.ensureShaded();
        resourcePackList = Accessors.findField(FMLClientHandler.class, "resourcePackList");
        resourcePackFile = Accessors.findField(AbstractResourcePack.class, "field_110597_b", "resourcePackFile");
        legacyPack = Accessors.findField(LegacyV2Adapter.class, "field_191383_a", "pack");
        domainResourceManagers = Accessors.findField(SimpleReloadableResourceManager.class, "field_110548_a", "domainResourceManagers");
        resourcePacks = Accessors.findField(FallbackResourceManager.class, "field_110540_a", "resourcePacks");
        hasResourceName = Invokers.findMethod(AbstractResourcePack.class, "hasResourceName", "func_110593_b", String.class);
        getInputStreamByName = Invokers.findMethod(AbstractResourcePack.class, "getInputStreamByName", "func_110591_a", String.class);
    }
}

