/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.api.crafting.base;

import com.sofodev.armorplus.api.crafting.IRecipe;
import com.sofodev.armorplus.api.crafting.IShapedRecipe;
import com.sofodev.armorplus.api.crafting.utils.ShapedRecipeUtils;
import com.sofodev.armorplus.common.container.base.InventoryCraftingImproved;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class BaseShapedRecipe
implements IRecipe,
IShapedRecipe {
    private int xy;
    public final int recipeWidth;
    public final int recipeHeight;
    public final NonNullList<ItemStack> input;
    private final ItemStack recipeOutput;
    private boolean copyIngredientNBT;

    public BaseShapedRecipe(int xy, int width, int height, NonNullList<ItemStack> ingredientsIn, ItemStack output) {
        this.xy = xy;
        this.recipeWidth = width;
        this.recipeHeight = height;
        this.input = ingredientsIn;
        IntStream.range(0, this.getInput().size()).filter(i -> ((ItemStack)this.getInput().get(i)).func_190926_b()).forEachOrdered(i -> {
            ItemStack cfr_ignored_0 = (ItemStack)this.getInput().set(i, (Object)ItemStack.field_190927_a);
        });
        this.recipeOutput = output;
    }

    @Override
    @Nonnull
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    @Override
    public boolean matches(@Nonnull InventoryCraftingImproved inv, @Nonnull World worldIn) {
        return ShapedRecipeUtils.matches(this.recipeWidth, this.recipeHeight, this.input, inv);
    }

    @Override
    @Nonnull
    public ItemStack getCraftingResult(@Nonnull InventoryCraftingImproved inv) {
        return ShapedRecipeUtils.getCraftingResult(this.getRecipeOutput(), this.copyIngredientNBT, inv);
    }

    public NonNullList<ItemStack> getInput() {
        return this.input;
    }

    public int getWidth() {
        return this.recipeWidth;
    }

    public int getHeight() {
        return this.recipeHeight;
    }

    @Override
    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }

    @Override
    public int getRecipeWidth() {
        return this.xy;
    }

    @Override
    public int getRecipeHeight() {
        return this.xy;
    }
}

