/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.events;

import com.sofodev.armorplus.api.caps.abilities.AbilityData;
import com.sofodev.armorplus.api.caps.abilities.ImplementedAbilities;
import com.sofodev.armorplus.api.caps.ailments.Ailment;
import com.sofodev.armorplus.api.caps.ailments.ImplementedAilments;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.enchantments.EnhancedEnchantment;
import com.sofodev.armorplus.common.registry.enchantments.FuriousEnchantment;
import com.sofodev.armorplus.common.registry.enchantments.LifeStealEnchantment;
import com.sofodev.armorplus.common.registry.potions.PotionEmpty;
import com.sofodev.armorplus.common.registry.sounds.SoundTrapTriggered;
import com.sofodev.armorplus.common.util.Utils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="armorplus")
public class RegistryEventHandler {
    @SubscribeEvent
    public static void registerCapability(RegistryEvent.NewRegistry event) {
        ResourceLocation registryName;
        if (ModConfig.Experimental.enableExperimentalMode && ImplementedAbilities.ABILITY_REGISTRY == null) {
            registryName = Utils.setRL("abilities");
            ImplementedAbilities.ABILITY_REGISTRY = new RegistryBuilder().setType(AbilityData.class).setName(registryName).create();
        }
        if (ImplementedAilments.AILMENT_REGISTRY == null) {
            registryName = Utils.setRL("ailments");
            ImplementedAilments.AILMENT_REGISTRY = new RegistryBuilder().setType(Ailment.class).setName(registryName).create();
        }
    }

    @SubscribeEvent
    public static void registerAbilities(RegistryEvent.Register<AbilityData> event) {
        if (ModConfig.Experimental.enableExperimentalMode) {
            RegistryEventHandler.registerAbility(event, ImplementedAbilities.NONE, ImplementedAbilities.NIGHT_VISION, ImplementedAbilities.WATER_BREATHING, ImplementedAbilities.RESISTANCE, ImplementedAbilities.FIRE_RESISTANCE, ImplementedAbilities.HASTE, ImplementedAbilities.SPEED, ImplementedAbilities.JUMP_BOOST, ImplementedAbilities.REGENERATION, ImplementedAbilities.STRENGTH, ImplementedAbilities.INVISIBILITY, ImplementedAbilities.ABSORPTION, ImplementedAbilities.WITHER_PROOF, ImplementedAbilities.FLIGHT, ImplementedAbilities.STEP_ASSIST, ImplementedAbilities.BONUS_XP_ON_KILL, ImplementedAbilities.WALK_ON_LAVA, ImplementedAbilities.SWIMMING_SPEED);
        }
    }

    private static void registerAbility(RegistryEvent.Register<AbilityData> event, AbilityData ... dataList) {
        for (AbilityData data : dataList) {
            IForgeRegistry registry = event.getRegistry();
            if (registry.containsValue((IForgeRegistryEntry)data)) continue;
            event.getRegistry().register((IForgeRegistryEntry)data);
        }
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Enchantment[]{new FuriousEnchantment(), new LifeStealEnchantment(), new EnhancedEnchantment()});
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        event.getRegistry().register((IForgeRegistryEntry)new PotionEmpty());
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register((IForgeRegistryEntry)new SoundTrapTriggered());
    }
}

