/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.blocks;

import com.sofodev.armorplus.common.registry.blocks.HarvestProps;
import com.sofodev.armorplus.common.registry.blocks.base.ToolType;

public class BlockProperties {
    private final float resistance;
    private final float hardness;
    private final ToolType tool;
    private final int harvestLevel;
    private final boolean unbreakable;
    private final float lightLevel;
    private final int lightOpacity;

    public BlockProperties(float resistance, float hardness, HarvestProps props, float lightLevel, int lightOpacity) {
        this.resistance = resistance;
        this.hardness = hardness;
        this.tool = props.getType();
        this.harvestLevel = props.getHarvestLevel();
        this.lightLevel = lightLevel;
        this.lightOpacity = lightOpacity;
        this.unbreakable = props.isUnbreakable();
    }

    public BlockProperties(float resistance, float hardness, HarvestProps props, float lightLevel) {
        this(resistance, hardness, props, lightLevel, 0);
    }

    public BlockProperties(float resistance, float hardness, HarvestProps props) {
        this(resistance, hardness, props, 0.0f);
    }

    public BlockProperties(float resistance, float hardness) {
        this(resistance, hardness, new HarvestProps(ToolType.PICKAXE));
    }

    public float getResistance() {
        return this.resistance;
    }

    public float getHardness() {
        return this.hardness;
    }

    public ToolType getToolType() {
        return this.tool;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public float getLightLevel() {
        return this.lightLevel;
    }

    public int getLightOpacity() {
        return this.lightOpacity;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }
}

