/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.items.armors.base;

import com.sofodev.armorplus.api.properties.AbilityCanceller;
import com.sofodev.armorplus.api.properties.AbilityProvider;
import com.sofodev.armorplus.api.properties.iface.IEffectHolder;
import com.sofodev.armorplus.client.utils.ToolTipUtils;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.ModItems;
import com.sofodev.armorplus.common.registry.constants.APItems;
import com.sofodev.armorplus.common.registry.items.armors.ArmorMaterials;
import com.sofodev.armorplus.common.registry.items.armors.base.ItemArmorBase;
import com.sofodev.armorplus.common.util.ArmorPlusItemUtils;
import com.sofodev.armorplus.common.util.LoaderUtils;
import com.sofodev.armorplus.common.util.PotionUtils;
import com.sofodev.armorplus.common.util.Utils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

public class ItemUltimateArmor
extends ItemArmorBase
implements IEffectHolder {
    private ModConfig.RegistryConfig.UltimateMaterial.Armor armor;

    public ItemUltimateArmor(EntityEquipmentSlot slot) {
        super(ArmorMaterials.THE_ULTIMATE_ARMOR, slot, "the_ultimate", "ultimate");
        this.armor = ModConfig.RegistryConfig.ultimate.armor;
    }

    public void onArmorTick(EntityPlayer player) {
        boolean isAllowed;
        PlayerCapabilities caps = player.field_71075_bZ;
        boolean isFullSet = ArmorPlusItemUtils.isFullSet((EntityLivingBase)player, APItems.theUltimateHelmet, APItems.theUltimateChestplate, APItems.theUltimateLeggings, APItems.theUltimateBoots);
        boolean bl = isAllowed = isFullSet || caps.field_75098_d || player.func_175149_v();
        if (ModConfig.Misc.enableFlightAbility) {
            if (isAllowed) {
                caps.field_75101_c = true;
            } else {
                caps.field_75100_b = false;
                caps.field_75101_c = false;
            }
        }
        if (this.armor.setInvincible) {
            caps.field_75102_a = isAllowed;
            PotionUtils.addPotion((EntityLivingBase)player, MobEffects.field_76443_y, 120, 0, PotionUtils.PotionType.GOOD);
        }
        if (isFullSet) {
            ArmorPlusItemUtils.applyEffects((EntityLivingBase)player, this);
        } else if (this.armor.enableDeBuffs) {
            PotionUtils.addPotion((EntityLivingBase)player, MobEffects.field_76436_u, 60, 2, PotionUtils.PotionType.BAD);
            PotionUtils.addPotion((EntityLivingBase)player, MobEffects.field_76421_d, 60, 2, PotionUtils.PotionType.BAD);
            PotionUtils.addPotion((EntityLivingBase)player, MobEffects.field_76440_q, 60, 0, PotionUtils.PotionType.BAD);
            player.field_70159_w = 0.0;
            if (player.field_70122_E) {
                player.field_70181_x = 0.0;
            }
            player.field_70179_y = 0.0;
            player.field_70133_I = true;
        }
    }

    @Override
    public AbilityProvider getApplicableAbilities() {
        return new AbilityProvider(this.armor.addPotionEffects, this.armor.effectLevels, this.armor.effectDurations);
    }

    @Override
    public AbilityCanceller getRemovableAbilities() {
        return new AbilityCanceller(this.armor.removePotionEffects);
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return this.getRarity(ModConfig.RegistryConfig.ultimate.armor.itemNameColor, "Ultimate Armor Color");
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (LoaderUtils.isDELoaded() && ModConfig.IntegrationsConfig.ultimateChaosImmunity) {
            String out = new TextComponentTranslation("misc.armorplus.chaos.resistance.max", new Object[0]).func_150254_d();
            tooltip.add(TextFormatting.DARK_PURPLE + out);
        }
        if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
            if (ArmorPlusItemUtils.isFullSet((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, APItems.theUltimateHelmet, APItems.theUltimateChestplate, APItems.theUltimateLeggings, APItems.theUltimateBoots)) {
                tooltip.add("\u00a79Answer: \u00a7rYou are the chosen one!");
                tooltip.add("\u00a7cSet is completed, you now hold the ultimate power");
            } else {
                tooltip.add("\u00a79Question: \u00a7rAre you the chosen one ?");
                tooltip.add("\u00a7cRequires the full set equipped");
            }
        } else {
            ToolTipUtils.showInfo(tooltip, keyBindSneak, TextFormatting.func_96300_b((String)ModConfig.RegistryConfig.ultimate.armor.itemNameColor));
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        boolean isUnbreakable = false;
        if (tagCompound != null) {
            isUnbreakable = tagCompound.func_74767_n("Unbreakable");
        }
        if (ModConfig.RegistryConfig.ultimate.armor.setUnbreakable && !isUnbreakable) {
            Utils.setUnbreakable(stack);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        this.onArmorTick(player);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ArmorPlusItemUtils.isItemRepairable(repair, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)4));
    }
}

