/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.util;

import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.items.armors.APArmorMaterial;
import com.sofodev.armorplus.common.registry.items.armors.Tier;
import com.sofodev.armorplus.common.util.Utils;
import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;

public class EnumHelperUtil {
    public static EnumEnchantmentType addEnchantType(String enumName, Predicate<Item> itemPredicate) {
        return EnumHelper.addEnchantmentType((String)enumName, itemPredicate::test);
    }

    public static EnumAction addAction(String enumName) {
        return EnumHelper.addAction((String)enumName);
    }

    public static EntityPlayer.SleepResult addStatus(String enumName) {
        return EnumHelper.addStatus((String)enumName);
    }

    public static ItemArmor.ArmorMaterial addArmorMaterial(String enumName, String textureName, int durability, int[] armorPoints, int enchantability, SoundEvent soundOnEquip, double toughnessPoints) {
        return EnumHelper.addArmorMaterial((String)enumName, (String)Utils.setLocation(textureName), (int)durability, (int[])armorPoints, (int)enchantability, (SoundEvent)soundOnEquip, (float)((float)toughnessPoints));
    }

    public static ItemArmor.ArmorMaterial addVanillaArmorMaterial(String textureName, int durability, ModConfig.RegistryConfig.EnhancedMaterial props, int enchantability, SoundEvent soundOnEquip) {
        return EnumHelper.addArmorMaterial((String)("ENHANCED_" + textureName.toUpperCase() + "_ARMOR"), (String)textureName, (int)durability, (int[])props.protectionPoints, (int)enchantability, (SoundEvent)soundOnEquip, (float)((float)props.toughnessPoints));
    }

    public static ItemArmor.ArmorMaterial addArmorMaterial(String textureName, int durability, int[] armorPoints, double toughnessPoints, Tier tier) {
        return EnumHelperUtil.addArmorMaterial(textureName.toUpperCase(), textureName, durability, armorPoints, tier.getEnchantability(), SoundEvents.field_191258_p, toughnessPoints);
    }

    public static ItemArmor.ArmorMaterial addArmorMaterial(String textureName, int durability, ModConfig.RegistryConfig.ArmorProperties props, Tier tier) {
        return EnumHelperUtil.addArmorMaterial(textureName.toUpperCase(), textureName, durability, props.protectionPoints, tier.getEnchantability(), SoundEvents.field_191258_p, props.toughnessPoints);
    }

    public static HorseArmorType addHorseArmor(String name, int armorStrength) {
        return EnumHelper.addHorseArmor((String)name, (String)("armorplus:textures/entity/horse/armor/" + name + ".png"), (int)armorStrength);
    }

    public static HorseArmorType addHorseArmor(APArmorMaterial material, int armorStrength) {
        return EnumHelper.addHorseArmor((String)material.getName(), (String)("armorplus:textures/entity/horse/armor/" + material.getName() + ".png"), (int)armorStrength);
    }

    public static Enchantment getEnchantment(int nameOrId) {
        return Enchantment.func_185262_c((int)nameOrId);
    }

    public static Enchantment getEnchantment(String nameOrId) {
        return Enchantment.func_180305_b((String)nameOrId);
    }

    public static int getID(Enchantment enchant) {
        return Enchantment.func_185258_b((Enchantment)enchant);
    }
}

