/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.util;

import com.sofodev.armorplus.common.registry.constants.APPotions;
import com.sofodev.armorplus.common.util.TextUtils;
import com.sofodev.armorplus.common.util.Utils;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;

public final class PotionUtils {
    public static void addPotion(EntityLivingBase entity, Object potion, int duration, int amplifier, boolean ambientIn, boolean showParticlesIn) {
        if (Utils.isNotNull(potion)) {
            if (potion instanceof String) {
                entity.func_70690_d(new PotionEffect(PotionUtils.getPotion((String)potion), duration, amplifier, ambientIn, showParticlesIn));
            } else if (potion instanceof Potion) {
                entity.func_70690_d(new PotionEffect((Potion)potion, duration, amplifier, ambientIn, showParticlesIn));
            }
        }
    }

    public static void addPotion(EntityLivingBase entity, Object potion, int duration, int amplifier, boolean ambientIn, PotionType potionType) {
        if (Utils.isNotNull(potion)) {
            PotionUtils.addPotion(entity, potion, duration, amplifier, ambientIn, potionType.hasParticles());
        }
    }

    public static void addPotion(EntityLivingBase entity, Object potion, int duration, int amplifier, PotionType potionType) {
        if (Utils.isNotNull(potion)) {
            PotionUtils.addPotion(entity, potion, duration, amplifier, false, potionType.hasParticles());
        }
    }

    public static void addPotion(EntityLivingBase entity, Object potion, int amplifier, PotionType potionType) {
        if (Utils.isNotNull(potion)) {
            PotionUtils.addPotion(entity, potion, 240, amplifier, false, potionType.hasParticles());
        }
    }

    public static void addPotion(EntityLivingBase entity, List<String> potions, List<Integer> amplifiers, PotionType potionType) {
        IntStream.range(0, potions.size()).forEach(i -> {
            String potion = (String)potions.get(i);
            int amplifier = (Integer)amplifiers.get(i);
            if (Utils.isNotNull(potion)) {
                PotionUtils.addPotion(entity, (Object)potion, 240, amplifier, false, potionType.hasParticles());
            }
        });
    }

    public static void removePotion(EntityLivingBase entity, Object potion) {
        if (Utils.isNotNull(potion)) {
            if (potion instanceof String) {
                entity.func_184589_d(PotionUtils.getPotion((String)potion));
            } else if (potion instanceof Potion) {
                entity.func_184589_d((Potion)potion);
            }
        } else {
            entity.func_184589_d(APPotions.EMPTY);
        }
    }

    public static String localizePotion(String resourceLocation) {
        return Utils.isNotNull(PotionUtils.getPotion(resourceLocation)) ? TextUtils.translatedText(PotionUtils.getPotion(resourceLocation).func_76393_a() + ".name", new Object[0]) : "";
    }

    public static Potion getPotion(String resourceLocation) {
        return Utils.isNotNull(Potion.func_180142_b((String)resourceLocation)) ? Potion.func_180142_b((String)resourceLocation) : APPotions.EMPTY;
    }

    public static Potion getPotion(ResourceLocation resourceLocation) {
        return PotionUtils.getPotion(resourceLocation.toString());
    }

    public static enum PotionType {
        GOOD(false),
        BAD(true);

        private final boolean showParticles;

        private PotionType(boolean showParticles) {
            this.showParticles = showParticles;
        }

        public boolean hasParticles() {
            return this.showParticles;
        }
    }
}

