/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.client.models;

import com.google.common.collect.Lists;
import com.teamacronymcoders.base.client.models.SmartLightingQuad;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class ModelUtils {
    private static float[] alphaNoFading = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private static final ItemCameraTransforms defaultTransforms = new ItemCameraTransforms(new ItemTransformVec3f(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.25f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransformVec3f(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransformVec3f(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransformVec3f(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)), new ItemTransformVec3f(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)));

    public static BakedQuad createBakedQuad(VertexFormat format, Vector3f[] vertices, EnumFacing facing, TextureAtlasSprite sprite, double[] uvs, float[] colour, boolean invert) {
        return ModelUtils.createBakedQuad(format, vertices, facing, sprite, uvs, colour, invert, alphaNoFading);
    }

    public static BakedQuad createBakedQuad(VertexFormat format, Vector3f[] vertices, EnumFacing facing, TextureAtlasSprite sprite, double[] uvs, float[] colour, boolean invert, float[] alpha) {
        return ModelUtils.createBakedQuad(format, vertices, facing, sprite, uvs, colour, invert, alpha, false, null);
    }

    public static BakedQuad createBakedQuad(VertexFormat format, Vector3f[] vertices, EnumFacing facing, TextureAtlasSprite sprite, double[] uvs, float[] colour, boolean invert, float[] alpha, boolean smartLighting, BlockPos basePos) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadOrientation(facing);
        builder.setTexture(sprite);
        OBJModel.Normal faceNormal = new OBJModel.Normal((float)facing.func_176730_m().func_177958_n(), (float)facing.func_176730_m().func_177956_o(), (float)facing.func_176730_m().func_177952_p());
        int vId = invert ? 3 : 0;
        int u = vId > 1 ? 2 : 0;
        ModelUtils.putVertexData(format, builder, vertices[vId], faceNormal, uvs[u], uvs[1], sprite, colour, alpha[invert ? 3 : 0]);
        vId = invert ? 2 : 1;
        u = vId > 1 ? 2 : 0;
        ModelUtils.putVertexData(format, builder, vertices[invert ? 2 : 1], faceNormal, uvs[u], uvs[3], sprite, colour, alpha[invert ? 2 : 1]);
        vId = invert ? 1 : 2;
        u = vId > 1 ? 2 : 0;
        ModelUtils.putVertexData(format, builder, vertices[invert ? 1 : 2], faceNormal, uvs[u], uvs[3], sprite, colour, alpha[invert ? 1 : 2]);
        vId = invert ? 1 : 3;
        u = vId > 1 ? 2 : 0;
        ModelUtils.putVertexData(format, builder, vertices[invert ? 0 : 3], faceNormal, uvs[u], uvs[1], sprite, colour, alpha[invert ? 0 : 3]);
        UnpackedBakedQuad tmp = builder.build();
        return smartLighting ? new SmartLightingQuad(tmp.func_178209_a(), -1, facing, sprite, format, basePos) : tmp;
    }

    protected static void putVertexData(VertexFormat format, UnpackedBakedQuad.Builder builder, Vector3f pos, OBJModel.Normal faceNormal, double u, double v, TextureAtlasSprite sprite, float[] colour, float alpha) {
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{pos.getX(), pos.getY(), pos.getZ(), 0.0f});
                    continue block6;
                }
                case COLOR: {
                    float d = 1.0f;
                    builder.put(e, new float[]{d * colour[0], d * colour[1], d * colour[2], 1.0f * colour[3] * alpha});
                    continue block6;
                }
                case UV: {
                    if (sprite == null) {
                        sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
                    }
                    builder.put(e, new float[]{sprite.func_94214_a(u), sprite.func_94207_b(v), 0.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{faceNormal.x, faceNormal.y, faceNormal.z, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public static TextureAtlasSprite getBlockSprite(ResourceLocation path) {
        if (!path.func_110623_a().contains("blocks/")) {
            path = new ResourceLocation(path.func_110624_b(), "blocks/" + path.func_110623_a());
        }
        return Minecraft.func_71410_x().func_147117_R().getTextureExtry(path.toString());
    }

    public static ItemCameraTransforms getDefaultTransforms() {
        return defaultTransforms;
    }

    public static List<BakedQuad> bakeQuads(ResourceLocation sprite, Color color) {
        return ModelUtils.bakeQuads(ModelUtils.getBlockSprite(sprite), color);
    }

    public static List<BakedQuad> bakeQuads(TextureAtlasSprite sprite, Color color) {
        Object[] sprites = new TextureAtlasSprite[6];
        Arrays.fill(sprites, sprite);
        return ModelUtils.bakeQuads((TextureAtlasSprite[])sprites, color);
    }

    public static List<BakedQuad> bakeQuads(TextureAtlasSprite[] sprites, Color color) {
        ArrayList quads = Lists.newArrayListWithExpectedSize((int)6);
        float[] colorArray = color != null ? color.getRGBComponents(new float[4]) : new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        Vector3f[] vertices = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f)};
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.DOWN, sprites[0], new double[]{0.0, 16.0, 16.0, 0.0}, colorArray, true));
        vertices = new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 0.0f)};
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.UP, sprites[1], new double[]{0.0, 0.0, 16.0, 16.0}, colorArray, false));
        vertices = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f)};
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.NORTH, sprites[2], new double[]{0.0, 16.0, 16.0, 0.0}, colorArray, true));
        vertices = new Vector3f[]{new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.SOUTH, sprites[3], new double[]{16.0, 16.0, 0.0, 0.0}, colorArray, false));
        vertices = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.WEST, sprites[4], new double[]{0.0, 16.0, 16.0, 0.0}, colorArray, true));
        vertices = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f)};
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.EAST, sprites[5], new double[]{16.0, 16.0, 0.0, 0.0}, colorArray, false));
        return quads;
    }
}

