/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.client.models.sided;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.teamacronymcoders.base.blocks.properties.SideType;
import com.teamacronymcoders.base.client.models.ModelUtils;
import com.teamacronymcoders.base.client.models.sided.BakedModelSidedBlock;
import com.teamacronymcoders.base.client.models.sided.ITextureNamer;
import com.teamacronymcoders.base.client.models.sided.SidedTypeRegistry;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;

public class ModelSidedBlock
implements IModel {
    private final String name;
    private final String type;
    private final ImmutableMap<String, ResourceLocation> textures;

    public ModelSidedBlock(String name, String type, ImmutableMap<String, ResourceLocation> textures) {
        this.name = name;
        this.type = type;
        this.textures = textures;
    }

    @Nonnull
    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    @Nonnull
    public Collection<ResourceLocation> getTextures() {
        return this.textures.values();
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite[][] tex = new TextureAtlasSprite[6][3];
        for (EnumFacing f : EnumFacing.field_82609_l) {
            for (SideType cfg : SideType.values()) {
                ResourceLocation resourceLocation = (ResourceLocation)this.textures.get((Object)(f.func_176610_l() + "_" + cfg.func_176610_l()));
                if (resourceLocation == null) continue;
                tex[f.ordinal()][cfg.ordinal()] = ModelUtils.getBlockSprite(resourceLocation);
            }
        }
        return new BakedModelSidedBlock(this.name, tex);
    }

    @Nonnull
    public IModel retexture(ImmutableMap<String, String> textures) {
        String newName = this.name;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EnumFacing f : EnumFacing.field_82609_l) {
            for (SideType cfg : SideType.values()) {
                ITextureNamer namer;
                String key = f.func_176610_l() + "_" + cfg.func_176610_l();
                ResourceLocation resourceLocation = (ResourceLocation)this.textures.get((Object)key);
                if (textures.containsKey((Object)key)) {
                    resourceLocation = new ResourceLocation((String)textures.get((Object)key));
                } else if (textures.containsKey((Object)f.func_176610_l())) {
                    String c;
                    namer = SidedTypeRegistry.getTextureNamer(this.type);
                    resourceLocation = new ResourceLocation((String)textures.get((Object)f.func_176610_l()));
                    if (namer != null && (c = namer.nameFromCfg(f, cfg)) != null) {
                        resourceLocation = new ResourceLocation((String)textures.get((Object)f.func_176610_l()) + "_" + c);
                    }
                } else if (textures.containsKey((Object)"name")) {
                    namer = SidedTypeRegistry.getTextureNamer(this.type);
                    newName = (String)textures.get((Object)"name");
                    if (namer != null) {
                        resourceLocation = new ResourceLocation(newName + "_" + namer.getTextureName(f, cfg));
                    }
                }
                builder.put((Object)key, (Object)resourceLocation);
            }
        }
        return new ModelSidedBlock(newName, this.type, (ImmutableMap<String, ResourceLocation>)builder.build());
    }
}

