/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.capabilities;

import com.teamacronymcoders.base.materialsystem.MaterialSystem;
import com.teamacronymcoders.base.materialsystem.MaterialUser;
import com.teamacronymcoders.base.materialsystem.capabilities.IMaterialPartHolder;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPart;
import com.teamacronymcoders.base.materialsystem.materials.Material;
import com.teamacronymcoders.base.materialsystem.parts.Part;
import net.minecraft.nbt.NBTTagCompound;

public class MaterialPartHolder
implements IMaterialPartHolder {
    private MaterialPart materialPart;

    public MaterialPartHolder(MaterialPart materialPart) {
        this.materialPart = materialPart;
    }

    public MaterialPartHolder() {
    }

    @Override
    public MaterialPart getMaterialPart() {
        return this.materialPart;
    }

    @Override
    public Material getMaterial() {
        return this.materialPart.getMaterial();
    }

    @Override
    public Part getPart() {
        return this.materialPart.getPart();
    }

    @Override
    public MaterialUser getOwner() {
        return this.materialPart.getMaterialUser();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("modid", this.getOwner().getId());
        compound.func_74768_a("materialPartId", this.getMaterialPart().getId());
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        MaterialUser user = MaterialSystem.getUser(nbt.func_74779_i("modid"));
        this.materialPart = user != null ? user.getMaterialPart(nbt.func_74762_e("materialPartId")) : MaterialSystem.MISSING_MATERIAL_PART;
    }
}

