/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.multiblocksystem.rectangular;

import com.teamacronymcoders.base.multiblocksystem.MultiblockControllerBase;
import com.teamacronymcoders.base.multiblocksystem.rectangular.RectangularMultiblockTileEntityBase;
import com.teamacronymcoders.base.multiblocksystem.validation.IMultiblockValidator;
import com.teamacronymcoders.base.multiblocksystem.validation.ValidationError;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class RectangularMultiblockControllerBase
extends MultiblockControllerBase {
    protected RectangularMultiblockControllerBase(World world) {
        super(world);
    }

    @Override
    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        if (this.connectedParts.size() < this.getMinimumNumberOfBlocksForAssembledMachine()) {
            validatorCallback.setLastError(ValidationError.VALIDATION_ERROR_TOO_FEW_PARTS);
            return false;
        }
        BlockPos maximumCoord = this.getMaximumCoord();
        BlockPos minimumCoord = this.getMinimumCoord();
        int minX = minimumCoord.func_177958_n();
        int minY = minimumCoord.func_177956_o();
        int minZ = minimumCoord.func_177952_p();
        int maxX = maximumCoord.func_177958_n();
        int maxY = maximumCoord.func_177956_o();
        int maxZ = maximumCoord.func_177952_p();
        int deltaX = maxX - minX + 1;
        int deltaY = maxY - minY + 1;
        int deltaZ = maxZ - minZ + 1;
        int maxXSize = this.getMaximumXSize();
        int maxYSize = this.getMaximumYSize();
        int maxZSize = this.getMaximumZSize();
        int minXSize = this.getMinimumXSize();
        int minYSize = this.getMinimumYSize();
        int minZSize = this.getMinimumZSize();
        if (maxXSize > 0 && deltaX > maxXSize) {
            validatorCallback.setLastError("base.api.multiblock.validation.machine_too_large", maxXSize, "X");
            return false;
        }
        if (maxYSize > 0 && deltaY > maxYSize) {
            validatorCallback.setLastError("base.api.multiblock.validation.machine_too_large", maxYSize, "Y");
            return false;
        }
        if (maxZSize > 0 && deltaZ > maxZSize) {
            validatorCallback.setLastError("base.api.multiblock.validation.machine_too_large", maxZSize, "Z");
            return false;
        }
        if (deltaX < minXSize) {
            validatorCallback.setLastError("base.api.multiblock.validation.machine_too_small", minXSize, "X");
            return false;
        }
        if (deltaY < minYSize) {
            validatorCallback.setLastError("base.api.multiblock.validation.machine_too_small", minYSize, "Y");
            return false;
        }
        if (deltaZ < minZSize) {
            validatorCallback.setLastError("base.api.multiblock.validation.machine_too_small", minZSize, "Z");
            return false;
        }
        Class<?> myClass = this.getClass();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    boolean isPartValid;
                    RectangularMultiblockTileEntityBase part;
                    TileEntity te = this.WORLD.func_175625_s(new BlockPos(x, y, z));
                    if (te instanceof RectangularMultiblockTileEntityBase) {
                        part = (RectangularMultiblockTileEntityBase)te;
                        if (!myClass.equals(part.getMultiblockControllerType())) {
                            validatorCallback.setLastError("base.api.multiblock.validation.invalid_part", x, y, z);
                            return false;
                        }
                    } else {
                        part = null;
                    }
                    int extremes = 0;
                    if (x == minX) {
                        ++extremes;
                    }
                    if (y == minY) {
                        ++extremes;
                    }
                    if (z == minZ) {
                        ++extremes;
                    }
                    if (x == maxX) {
                        ++extremes;
                    }
                    if (y == maxY) {
                        ++extremes;
                    }
                    if (z == maxZ) {
                        ++extremes;
                    }
                    if (extremes >= 2) {
                        boolean bl = isPartValid = part != null ? part.isGoodForFrame(validatorCallback) : this.isBlockGoodForFrame(this.WORLD, x, y, z, validatorCallback);
                        if (isPartValid) continue;
                        if (null == validatorCallback.getLastError()) {
                            validatorCallback.setLastError("base.api.multiblock.validation.invalid_part_for_frame", x, y, z);
                        }
                        return false;
                    }
                    if (extremes == 1) {
                        if (y == maxY) {
                            boolean bl = isPartValid = part != null ? part.isGoodForTop(validatorCallback) : this.isBlockGoodForTop(this.WORLD, x, y, z, validatorCallback);
                            if (isPartValid) continue;
                            if (null == validatorCallback.getLastError()) {
                                validatorCallback.setLastError("base.api.multiblock.validation.invalid_part_for_top", x, y, z);
                            }
                            return false;
                        }
                        if (y == minY) {
                            boolean bl = isPartValid = part != null ? part.isGoodForBottom(validatorCallback) : this.isBlockGoodForBottom(this.WORLD, x, y, z, validatorCallback);
                            if (isPartValid) continue;
                            if (null == validatorCallback.getLastError()) {
                                validatorCallback.setLastError("base.api.multiblock.validation.invalid_part_for_bottom", x, y, z);
                            }
                            return false;
                        }
                        boolean bl = isPartValid = part != null ? part.isGoodForSides(validatorCallback) : this.isBlockGoodForSides(this.WORLD, x, y, z, validatorCallback);
                        if (isPartValid) continue;
                        if (null == validatorCallback.getLastError()) {
                            validatorCallback.setLastError("base.api.multiblock.validation.invalid_part_for_sides", x, y, z);
                        }
                        return false;
                    }
                    boolean bl = isPartValid = part != null ? part.isGoodForInterior(validatorCallback) : this.isBlockGoodForInterior(this.WORLD, x, y, z, validatorCallback);
                    if (isPartValid) continue;
                    if (null == validatorCallback.getLastError()) {
                        validatorCallback.setLastError("base.api.multiblock.validation.invalid_part_for_interior", x, y, z);
                    }
                    return false;
                }
            }
        }
        return true;
    }
}

