/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.subblocksystem.blocks;

import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public interface ISubBlock {
    public String getName();

    public String getUnLocalizedName();

    default public String getLocalizedName() {
        return I18n.func_74838_a((String)this.getUnLocalizedName());
    }

    public ResourceLocation getTextureLocation();

    public int getColor();

    public float getHardness();

    public int getResistance();

    public int getHarvestLevel();

    @Nonnull
    public String getHarvestTool();

    public void getDrops(int var1, List<ItemStack> var2);

    public void setRecipes(List<IRecipe> var1);

    public String getOreDict();

    @Nullable
    public CreativeTabs getCreativeTab();

    @Nullable
    public IGeneratedModel getGeneratedModel();

    public Material getMaterial();

    @Nonnull
    public ItemStack getItemStack();

    @Nonnull
    public IBlockState getBlockState();

    public void setMeta(int var1);

    public void setBlock(Block var1);

    public boolean isSideSolid(EnumFacing var1);

    public boolean isTopSolid();

    public BlockFaceShape getBlockFaceShape();

    public AxisAlignedBB getBoundingBox();

    public boolean isFullCube();

    public boolean isOpaqueCube();

    public boolean isPassable();

    public boolean isFullBlock();

    public int getLightOpacity();

    public boolean canSilkHarvest();

    public void onNeighborChange(World var1, BlockPos var2, Block var3, BlockPos var4);

    public boolean canPlaceBlockAt(World var1, @Nonnull BlockPos var2);

    public boolean onBlockActivated(World var1, BlockPos var2, EntityPlayer var3);

    default public BlockRenderLayer getRenderLayer() {
        return this.isOpaqueCube() ? BlockRenderLayer.SOLID : BlockRenderLayer.CUTOUT;
    }
}

