/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.api;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.api.ICustomInsertable;
import com.cleanroommc.bogosorter.api.IPosSetter;
import com.cleanroommc.bogosorter.api.ISlot;
import com.cleanroommc.bogosorter.api.ISortingContextBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface IBogoSortAPI {
    public static IBogoSortAPI getInstance() {
        return BogoSortAPI.INSTANCE;
    }

    public <T extends Slot> void addSlotGetter(Class<T> var1, Function<T, ISlot> var2);

    public void addCustomInsertable(Class<? extends Container> var1, ICustomInsertable var2);

    public <T extends Container> void addCompat(Class<T> var1, BiConsumer<T, ISortingContextBuilder> var2);

    default public <T extends Container> void addGenericCompat(Class<T> clazz) {
        this.addCompat(clazz, (container, builder) -> builder.addGenericSlotGroup());
    }

    @ApiStatus.Internal
    public <T> void addCompatSimple(Class<T> var1, BiConsumer<T, ISortingContextBuilder> var2);

    public void addPlayerSortButtonPosition(Class<?> var1, @Nullable IPosSetter var2);

    public <T extends Container> void removeCompat(Class<T> var1);

    public void registerItemSortingRule(String var1, Comparator<ItemStack> var2);

    public void registerNbtSortingRule(String var1, String var2, Comparator<NBTBase> var3);

    public void registerNbtSortingRule(String var1, String var2, int var3);

    public <T> void registerNbtSortingRule(String var1, String var2, int var3, Comparator<T> var4, Function<NBTBase, T> var5);

    @SideOnly(value=Side.CLIENT)
    default public void openConfigGui() {
        this.openConfigGui(null);
    }

    @SideOnly(value=Side.CLIENT)
    public void openConfigGui(GuiScreen var1);

    @SideOnly(value=Side.CLIENT)
    public boolean sortSlotGroup(Slot var1);

    public ISlot getSlot(Slot var1);

    public List<ISlot> getSlots(@NotNull List<Slot> var1);
}

