/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.sort;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.ClientEventHandler;
import com.cleanroommc.bogosorter.common.config.BogoSorterConfig;
import com.cleanroommc.bogosorter.common.sort.ButtonPos;
import com.cleanroommc.bogosorter.common.sort.GuiSortingContext;
import com.cleanroommc.bogosorter.common.sort.IGuiContainerAccessor;
import com.cleanroommc.bogosorter.common.sort.SlotGroup;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.screen.GuiScreenWrapper;
import com.cleanroommc.modularui.utils.Color;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class ButtonHandler {
    private static final int SORT_ID = 394658246;
    private static final int SETTINGS_ID = 394658247;
    public static final int BUTTON_SIZE = 10;
    public static final UITexture BUTTON_BACKGROUND = UITexture.builder().location("bogosorter", "gui/base_button").imageSize(18, 18).adaptable(1).build();

    @SubscribeEvent
    public static void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (ClientEventHandler.isSortableContainer(event.getGui()) && !(event.getGui() instanceof GuiScreenWrapper)) {
            Container container = ((GuiContainer)event.getGui()).field_147002_h;
            GuiSortingContext context = GuiSortingContext.getOrCreate(container);
            event.getButtonList().removeIf(guiButton -> guiButton instanceof SortButton);
            for (SlotGroup slotGroup : context.getSlotGroups()) {
                if (!slotGroup.canBeSorted() || slotGroup.getPosSetter() == null) continue;
                event.getButtonList().add(new SortButton(slotGroup, true));
                event.getButtonList().add(new SortButton(slotGroup, false));
            }
        }
    }

    @SubscribeEvent
    public static void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (ClientEventHandler.isSortableContainer(event.getGui()) && !(event.getGui() instanceof GuiScreenWrapper)) {
            GuiContainer gui = (GuiContainer)event.getGui();
            IGuiContainerAccessor guiAccess = (IGuiContainerAccessor)gui;
            GuiSortingContext context = GuiSortingContext.getOrCreate(gui.field_147002_h);
            ButtonPos buttonPos = new ButtonPos();
            for (SlotGroup slotGroup : context.getSlotGroups()) {
                if (slotGroup.getPosSetter() == null) continue;
                SortButton sortButton = null;
                SortButton settingsButton = null;
                for (GuiButton guiButton : guiAccess.getButtons()) {
                    SortButton button;
                    if (!(guiButton instanceof SortButton) || (button = (SortButton)guiButton).slotGroup != slotGroup) continue;
                    if (button.sort) {
                        sortButton = button;
                    } else {
                        settingsButton = button;
                    }
                    if (sortButton == null || settingsButton == null) continue;
                    break;
                }
                if (sortButton == null || settingsButton == null) continue;
                buttonPos.reset();
                slotGroup.getPosSetter().setButtonPos(slotGroup, buttonPos);
                sortButton.field_146124_l = buttonPos.isEnabled();
                settingsButton.field_146124_l = buttonPos.isEnabled();
                buttonPos.applyPos(guiAccess.getGuiLeft(), guiAccess.getGuiTop(), sortButton, settingsButton);
            }
        }
    }

    @SubscribeEvent
    public static void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (ClientEventHandler.isSortableContainer(event.getGui()) && !(event.getGui() instanceof GuiScreenWrapper)) {
            for (GuiButton guiButton : ((IGuiContainerAccessor)event.getGui()).getButtons()) {
                if (!(guiButton instanceof SortButton)) continue;
                ((SortButton)guiButton).drawTooltip(event.getMouseX(), event.getMouseY());
            }
        }
    }

    @SubscribeEvent
    public static void onActionPerformed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.getButton() instanceof SortButton && event.getButton().field_146124_l) {
            SortButton sortButton = (SortButton)event.getButton();
            if (sortButton.sort) {
                ClientEventHandler.sort(event.getGui(), sortButton.slotGroup.getSlots().get(0));
            } else {
                BogoSortAPI.INSTANCE.openConfigGui(event.getGui());
                Interactable.playButtonClickSound();
            }
            event.setCanceled(true);
        }
    }

    public static class SortButton
    extends GuiButton {
        private final SlotGroup slotGroup;
        private final boolean sort;

        public SortButton(SlotGroup slotGroup, boolean sort) {
            super(sort ? 394658246 : 394658247, 0, 0, 10, 10, sort ? "z" : "...");
            this.slotGroup = slotGroup;
            this.sort = sort;
        }

        public void func_191745_a(@NotNull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m && this.field_146124_l) {
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                Color.setGlColor((int)BogoSorterConfig.buttonColor);
                BUTTON_BACKGROUND.draw((float)this.field_146128_h, (float)this.field_146129_i, (float)this.field_146120_f, (float)this.field_146121_g);
                Color.resetGlColor();
                this.func_146119_b(mc, mouseX, mouseY);
                int color = 0xE0E0E0;
                if (this.packedFGColour != 0) {
                    color = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    color = 0xA0A0A0;
                } else if (this.field_146123_n) {
                    color = 0xFFFFA0;
                }
                int y = this.field_146129_i;
                if (!this.sort) {
                    --y;
                }
                this.func_73732_a(mc.field_71466_p, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, y, color);
            }
        }

        public void drawTooltip(int mouseX, int mouseY) {
            if (this.field_146124_l && this.field_146123_n) {
                GuiScreen guiScreen = Objects.requireNonNull(Minecraft.func_71410_x().field_71462_r);
                GuiUtils.drawHoveringText(Collections.singletonList(I18n.func_135052_a((String)(this.sort ? "key.sort" : "key.sort_config"), (Object[])new Object[0])), (int)mouseX, (int)mouseY, (int)guiScreen.field_146294_l, (int)guiScreen.field_146295_m, (int)300, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
            }
        }
    }
}

