/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.common.internal.mixins;

import com.google.common.base.Strings;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import org.apache.logging.log4j.ThreadContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import zone.rong.loliasm.config.LoliConfig;
import zone.rong.loliasm.spark.LoliSparker;

@Mixin(value={LoadController.class}, priority=-1000, remap=false)
public abstract class LoadControllerMixin {
    @Shadow(remap=false)
    private ModContainer activeContainer;
    @Unique
    private static Boolean hasSpark;
    @Unique
    private static boolean gameHasLoaded;

    @Shadow(remap=false)
    @Nullable
    protected abstract ModContainer findActiveContainerFromStack();

    @Nullable
    @Overwrite
    public ModContainer activeContainer() {
        if (this.activeContainer == null) {
            String modId = ThreadContext.get((String)"mod");
            if (Strings.isNullOrEmpty((String)modId)) {
                return this.findActiveContainerFromStack();
            }
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(modId);
            return container == null ? this.findActiveContainerFromStack() : container;
        }
        return this.activeContainer;
    }

    @Inject(method={"propogateStateMessage"}, at={@At(value="HEAD")})
    private void injectBeforeDistributingState(FMLEvent stateEvent, CallbackInfo ci) {
        if (hasSpark == null) {
            hasSpark = Loader.isModLoaded((String)"spark");
        }
        if (hasSpark.booleanValue()) {
            if (stateEvent instanceof FMLStateEvent) {
                if (stateEvent instanceof FMLConstructionEvent) {
                    if (LoliConfig.instance.sparkProfileCoreModLoading) {
                        LoliSparker.stop("coremod");
                    }
                    if (LoliConfig.instance.sparkProfileConstructionStage) {
                        LoliSparker.start(LoaderState.CONSTRUCTING.toString());
                    }
                } else if (stateEvent instanceof FMLPreInitializationEvent) {
                    if (LoliConfig.instance.sparkProfileConstructionStage) {
                        LoliSparker.stop(LoaderState.CONSTRUCTING.toString());
                    }
                    if (LoliConfig.instance.sparkProfilePreInitializationStage) {
                        LoliSparker.start(LoaderState.PREINITIALIZATION.toString());
                    }
                } else if (stateEvent instanceof FMLInitializationEvent) {
                    if (LoliConfig.instance.sparkProfilePreInitializationStage) {
                        LoliSparker.stop(LoaderState.PREINITIALIZATION.toString());
                    }
                    if (LoliConfig.instance.sparkProfileInitializationStage) {
                        LoliSparker.start(LoaderState.INITIALIZATION.toString());
                    }
                } else if (stateEvent instanceof FMLPostInitializationEvent) {
                    if (LoliConfig.instance.sparkProfileInitializationStage) {
                        LoliSparker.stop(LoaderState.INITIALIZATION.toString());
                    }
                    if (LoliConfig.instance.sparkProfilePostInitializationStage) {
                        LoliSparker.start(LoaderState.POSTINITIALIZATION.toString());
                    }
                } else if (stateEvent instanceof FMLLoadCompleteEvent) {
                    if (LoliConfig.instance.sparkProfilePostInitializationStage) {
                        LoliSparker.stop(LoaderState.POSTINITIALIZATION.toString());
                    }
                    if (LoliConfig.instance.sparkProfileLoadCompleteStage) {
                        LoliSparker.start(LoaderState.AVAILABLE.toString());
                    }
                } else if (stateEvent instanceof FMLServerAboutToStartEvent) {
                    if (LoliConfig.instance.sparkProfileWorldAboutToStartStage) {
                        LoliSparker.start(LoaderState.SERVER_ABOUT_TO_START.toString());
                    }
                    if (LoliConfig.instance.sparkProfileEntireWorldLoad) {
                        LoliSparker.start("world");
                    }
                } else if (stateEvent instanceof FMLServerStartingEvent) {
                    if (LoliConfig.instance.sparkProfileWorldAboutToStartStage) {
                        LoliSparker.stop(LoaderState.SERVER_ABOUT_TO_START.toString());
                    }
                    if (LoliConfig.instance.sparkProfileWorldStartingStage) {
                        LoliSparker.start(LoaderState.SERVER_STARTING.toString());
                    }
                } else if (stateEvent instanceof FMLServerStartedEvent) {
                    if (LoliConfig.instance.sparkProfileWorldStartingStage) {
                        LoliSparker.stop(LoaderState.SERVER_STARTING.toString());
                    }
                    if (LoliConfig.instance.sparkProfileWorldStartedStage) {
                        LoliSparker.start(LoaderState.SERVER_STARTED.toString());
                    }
                }
            } else if (stateEvent instanceof FMLModIdMappingEvent && !gameHasLoaded && ((FMLModIdMappingEvent)stateEvent).isFrozen && LoliConfig.instance.sparkProfileFinalizingStage) {
                LoliSparker.start("finalizing");
            }
        }
    }

    @Inject(method={"propogateStateMessage"}, at={@At(value="RETURN")})
    private void injectAfterDistributingState(FMLEvent stateEvent, CallbackInfo ci) {
        if (hasSpark.booleanValue()) {
            if (stateEvent instanceof FMLStateEvent) {
                if (stateEvent instanceof FMLLoadCompleteEvent) {
                    if (LoliConfig.instance.sparkProfileLoadCompleteStage) {
                        LoliSparker.stop(LoaderState.AVAILABLE.toString());
                    }
                } else if (stateEvent instanceof FMLServerStartedEvent) {
                    if (LoliConfig.instance.sparkProfileWorldStartedStage) {
                        LoliSparker.stop(LoaderState.SERVER_STARTED.toString());
                    }
                    if (LoliConfig.instance.sparkProfileEntireWorldLoad) {
                        LoliSparker.stop("world");
                    }
                    if (LoliConfig.instance.sparkSummarizeHeapSpaceAfterWorldLoads) {
                        LoliSparker.checkHeap(true, true);
                    }
                }
            } else if (stateEvent instanceof FMLModIdMappingEvent && !gameHasLoaded && ((FMLModIdMappingEvent)stateEvent).isFrozen) {
                if (LoliConfig.instance.sparkProfileFinalizingStage) {
                    LoliSparker.stop("finalizing");
                    gameHasLoaded = true;
                }
                if (LoliConfig.instance.sparkProfileEntireGameLoad) {
                    LoliSparker.stop("game");
                }
                if (LoliConfig.instance.sparkSummarizeHeapSpaceAfterGameLoads) {
                    LoliSparker.checkHeap(true, true);
                }
            }
        }
    }

    static {
        gameHasLoaded = false;
    }
}

