/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.spark;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.heapdump.HeapDumpSummary;
import me.lucko.spark.common.platform.AbstractPlatformInfo;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.sampler.Sampler;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.sampler.ThreadGrouper;
import me.lucko.spark.common.sampler.ThreadNodeOrder;
import me.lucko.spark.common.sampler.async.AsyncProfilerAccess;
import me.lucko.spark.common.sampler.async.AsyncSampler;
import me.lucko.spark.common.sampler.java.JavaSampler;
import me.lucko.spark.common.sampler.node.MergeMode;
import me.lucko.spark.common.util.MethodDisambiguator;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.okhttp3.MediaType;
import zone.rong.loliasm.LoliLogger;
import zone.rong.loliasm.config.LoliConfig;
import zone.rong.loliasm.core.LoliLoadingPlugin;

public class LoliSparker {
    private static PlatformInfo platformInfo = new LoliPlatformInfo();
    private static CommandSender commandSender = new LoliCommandSender();
    private static Map<String, Sampler> ongoingSamplers = new Object2ReferenceOpenHashMap();
    private static MediaType mediaType = MediaType.parse((String)"application/x-spark-sampler");
    private static MediaType heapMediaType = MediaType.parse((String)"application/x-spark-heap");
    private static ExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("spark-loli-async-worker").build());

    public static void start(String key) {
        if (!ongoingSamplers.containsKey(key)) {
            AsyncSampler sampler;
            try {
                AsyncProfilerAccess.INSTANCE.getProfiler();
                sampler = new AsyncSampler(4000, (ThreadDumper)(LoliConfig.instance.includeAllThreadsWhenProfiling ? ThreadDumper.ALL : new ThreadDumper.Specific(new long[]{Thread.currentThread().getId()})), ThreadGrouper.BY_NAME);
            }
            catch (UnsupportedOperationException e) {
                sampler = new JavaSampler(4000, (ThreadDumper)(LoliConfig.instance.includeAllThreadsWhenProfiling ? ThreadDumper.ALL : new ThreadDumper.Specific(new long[]{Thread.currentThread().getId()})), ThreadGrouper.BY_NAME, -1L, !LoliConfig.instance.includeAllThreadsWhenProfiling, !LoliConfig.instance.includeAllThreadsWhenProfiling);
            }
            ongoingSamplers.put(key, (Sampler)sampler);
            LoliLogger.instance.warn("Profiler has started for stage [{}]...", (Object)key);
            sampler.start();
        }
    }

    public static void checkHeap(boolean summarize, boolean runGC) {
        if (runGC) {
            System.gc();
        }
        if (summarize) {
            executor.execute(() -> {
                byte[] output = HeapDumpSummary.createNew().formCompressedDataPayload(platformInfo, commandSender);
                try {
                    String urlKey = SparkPlatform.BYTEBIN_CLIENT.postContent(output, heapMediaType, false).key();
                    String url = "https://spark.lucko.me/" + urlKey;
                    LoliLogger.instance.warn("Heap Summary: {}", (Object)url);
                }
                catch (Exception e) {
                    LoliLogger.instance.fatal("An error occurred whilst uploading heap summary.", (Throwable)e);
                }
            });
        }
    }

    public static void stop(String key) {
        Sampler sampler = ongoingSamplers.remove(key);
        if (sampler != null) {
            sampler.stop();
            LoliSparker.output(key, sampler);
        }
    }

    private static void output(String key, Sampler sampler) {
        executor.execute(() -> {
            LoliLogger.instance.warn("Stage [{}] profiler has stopped! Uploading results...", (Object)key);
            byte[] output = sampler.formCompressedDataPayload(platformInfo, commandSender, (Comparator)ThreadNodeOrder.BY_TIME, "Stage: " + key, MergeMode.separateParentCalls((MethodDisambiguator)new MethodDisambiguator()));
            try {
                String urlKey = SparkPlatform.BYTEBIN_CLIENT.postContent(output, mediaType, false).key();
                String url = "https://spark.lucko.me/" + urlKey;
                LoliLogger.instance.warn("Profiler results for Stage [{}]: {}", (Object)key, (Object)url);
            }
            catch (Exception e) {
                LoliLogger.instance.fatal("An error occurred whilst uploading the results.", (Throwable)e);
            }
        });
    }

    public static class LoliCommandSender
    implements CommandSender {
        private final UUID uuid = UUID.randomUUID();
        private final String name;

        public LoliCommandSender() {
            this.name = "LoliASM";
        }

        public String getName() {
            return this.name;
        }

        public UUID getUniqueId() {
            return this.uuid;
        }

        public void sendMessage(Component component) {
        }

        public boolean hasPermission(String s) {
            return true;
        }
    }

    static class LoliPlatformInfo
    extends AbstractPlatformInfo {
        LoliPlatformInfo() {
        }

        public PlatformInfo.Type getType() {
            return LoliLoadingPlugin.isClient ? PlatformInfo.Type.CLIENT : PlatformInfo.Type.SERVER;
        }

        public String getName() {
            return "LoliASM";
        }

        public String getVersion() {
            return "5.28";
        }

        public String getMinecraftVersion() {
            return "1.12.2";
        }
    }
}

