/*
 * Decompiled with CFR 0.152.
 */
package eutros.dynamistics.jei.categories.pauto;

import eutros.dynamistics.helper.ItemHelper;
import eutros.dynamistics.helper.JeiHelper;
import eutros.dynamistics.jei.categories.pauto.IWrapperSupplier;
import eutros.dynamistics.jei.categories.pauto.processing.PackageProcessingRecipe;
import eutros.dynamistics.jei.categories.pauto.processing.PackageRecipeProvider;
import eutros.dynamistics.jei.categories.pauto.processing.RecipeHolderProcessingRecipe;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.RecipeTypeRegistry;

public class PackageProcessCategory
implements IWrapperSupplier<PackageRecipeProvider> {
    public static final String UID = "dynamistics:package_process";
    public static final int HEIGHT = 98;
    public static final int WIDTH = 168;
    private final IDrawableStatic background;
    private final IDrawableStatic slot;
    private final IDrawable icon;
    private final Item recipePackage;
    private final IDrawableStatic arrow;

    public PackageProcessCategory(IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        this.recipePackage = (Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("packagedauto", "package")));
        this.slot = JeiHelper.getSlotDrawable();
        this.background = guiHelper.createBlankDrawable(168, 98);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(this.recipePackage));
        this.arrow = guiHelper.createDrawable(new ResourceLocation("dynamistics", "textures/gui/arrows.png"), 0, 32, 64, 64);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"dynamistics.category.title.pauto.process", (Object[])new Object[0]);
    }

    @Nonnull
    public String getModName() {
        return "PackagedAuto";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, (168 - this.arrow.getWidth()) / 2, (98 - this.arrow.getHeight()) / 2);
    }

    public void setRecipe(IRecipeLayout recipeLayout, PackageRecipeProvider recipeWrapper, IIngredients ingredients) {
        int i;
        IRecipeType recipeType;
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        NBTTagCompound nbt = recipeWrapper.getPackageNBT();
        ItemStack input = (ItemStack)((List)ingredients.getInputs(VanillaTypes.ITEM).get(0)).get(0);
        if (input.func_77973_b() != this.recipePackage) {
            input = recipeWrapper.stack;
            stacks.init(20, true, 2, 2);
            stacks.set(20, input);
            stacks.setBackground(20, (IDrawable)this.slot);
        }
        NonNullList inputs = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        NonNullList outputs = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        if (!nbt.func_82582_d() && (recipeType = RecipeTypeRegistry.getRecipeType((ResourceLocation)new ResourceLocation(nbt.func_74779_i("RecipeType")))) != null) {
            IRecipeInfo recipeInfo = recipeType.getNewRecipeInfo();
            recipeInfo.readFromNBT(nbt);
            List patterns = recipeInfo.getPatterns();
            for (int i2 = 0; i2 < patterns.size(); ++i2) {
                inputs.set(i2, (Object)((IPackagePattern)patterns.get(i2)).getOutput());
            }
            List outStacks = recipeInfo.getOutputs();
            for (int i3 = 0; i3 < outStacks.size(); ++i3) {
                outputs.set(i3, outStacks.get(i3));
            }
            recipeWrapper.setInfo(recipeInfo);
        }
        int gridStartY = 32;
        int gridStartX = 8;
        int gridSize = 18;
        for (i = 0; i < inputs.size(); ++i) {
            stacks.init(i, true, gridStartX + gridSize * (i % 3), gridStartY + gridSize * (i / 3));
            stacks.set(i, (ItemStack)inputs.get(i));
            stacks.setBackground(i, (IDrawable)this.slot);
        }
        gridStartX = 168 - gridSize * 3 - gridStartX;
        for (i = 0; i < outputs.size(); ++i) {
            stacks.init(9 + i, false, gridStartX + gridSize * (i % 3), gridStartY + gridSize * (i / 3));
            stacks.set(9 + i, (ItemStack)outputs.get(i));
            stacks.setBackground(9 + i, (IDrawable)this.slot);
        }
    }

    @Override
    @Nonnull
    public List<PackageRecipeProvider> makeWrappers(ItemStack stack) {
        return stack.func_77973_b() == ItemHelper.PAuto.HOLDER ? IntStream.range(0, 20).mapToObj(i -> new RecipeHolderProcessingRecipe(stack, i)).collect(Collectors.toList()) : Collections.singletonList(new PackageProcessingRecipe(stack));
    }

    @Override
    @Nonnull
    public ItemStack getFallbackStack() {
        return ItemHelper.PAuto.EXAMPLE_PACKAGE;
    }
}

