/*
 * Decompiled with CFR 0.152.
 */
package com.hjae.findme.network;

import com.hjae.findme.FindMe;
import com.hjae.findme.network.PositionResponseMessage;
import com.hjae.findme.proxy.FindMeConfig;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class FluidPositionRequestMessage
implements IMessage {
    private FluidStack fluid;

    public FluidPositionRequestMessage(FluidStack fluid) {
        this.fluid = fluid;
    }

    public FluidPositionRequestMessage() {
    }

    public static List<BlockPos> getBlockPosInAABB(AxisAlignedBB axisAlignedBB) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (double y = axisAlignedBB.field_72338_b; y < axisAlignedBB.field_72337_e; y += 1.0) {
            for (double x = axisAlignedBB.field_72340_a; x < axisAlignedBB.field_72336_d; x += 1.0) {
                for (double z = axisAlignedBB.field_72339_c; z < axisAlignedBB.field_72334_f; z += 1.0) {
                    blocks.add(new BlockPos(x, y, z));
                }
            }
        }
        return blocks;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        NBTTagCompound fluidStackTag = null;
        try {
            fluidStackTag = packetBuffer.func_150793_b();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (fluidStackTag != null) {
            this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidStackTag);
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        NBTTagCompound fluidStackTag = this.fluid.writeToNBT(new NBTTagCompound());
        packetBuffer.func_150786_a(fluidStackTag);
    }

    public static class Handler
    implements IMessageHandler<FluidPositionRequestMessage, PositionResponseMessage> {
        public PositionResponseMessage onMessage(FluidPositionRequestMessage message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.field_70170_p.func_73046_m().func_152344_a(() -> {
                AxisAlignedBB box = new AxisAlignedBB(ctx.getServerHandler().field_147369_b.func_180425_c()).func_186662_g((double)FindMeConfig.RADIUS_RANGE);
                ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
                for (BlockPos blockPos : FluidPositionRequestMessage.getBlockPosInAABB(box)) {
                    IFluidHandler handler;
                    TileEntity tileEntity = ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(blockPos);
                    if (tileEntity == null || !tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) || (handler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) == null) continue;
                    for (IFluidTankProperties property : handler.getTankProperties()) {
                        if (property.getContents() == null || !property.getContents().isFluidEqual(message.fluid)) continue;
                        blockPosList.add(blockPos);
                    }
                }
                if (!blockPosList.isEmpty()) {
                    FindMe.NETWORK.sendTo((IMessage)new PositionResponseMessage(blockPosList), ctx.getServerHandler().field_147369_b);
                }
            });
            return null;
        }
    }
}

