/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.block;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.dynamic.StatusModelData;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.item.ItemCustomDrawers;
import eutros.framedcompactdrawers.block.AbstractBlockDrawersCustom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDrawersCustomComp
extends AbstractBlockDrawersCustom {
    public static final PropertyEnum<EnumCompDrawer> SLOTS = BlockCompDrawers.SLOTS;
    private StatusModelData statusInfo;

    public BlockDrawersCustomComp() {
        super("framedcompactdrawers:framed_compact_drawer", "framedcompactdrawers.framed_compact_drawer");
    }

    @Override
    @Nonnull
    protected BlockStateContainer createTrueBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{SLOTS, FACING}, new IUnlistedProperty[]{MAT_MODEL, STATE_MODEL});
    }

    @Override
    protected void replaceDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SLOTS, (Comparable)EnumCompDrawer.OPEN3).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected int getDrawerSlot(int drawerCount, int side, float hitX, float hitY, float hitZ) {
        if (this.hitTop(hitY)) {
            return 0;
        }
        if (this.hitLeft(side, hitX, hitZ)) {
            return 1;
        }
        return 2;
    }

    public int getDrawerCount(IBlockState state) {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public void initDynamic() {
        ResourceLocation location = new ResourceLocation("storagedrawers:models/dynamic/compDrawers.json");
        this.statusInfo = new StatusModelData(3, location);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public StatusModelData getStatusInfo(IBlockState state) {
        return this.statusInfo;
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing;
        TileEntityDrawers tile = this.getTileEntity(world, pos);
        if (tile == null) {
            return state;
        }
        EnumCompDrawer slots = EnumCompDrawer.OPEN1;
        if (tile.getGroup().getDrawer(1).isEnabled()) {
            slots = EnumCompDrawer.OPEN2;
        }
        if (tile.getGroup().getDrawer(2).isEnabled()) {
            slots = EnumCompDrawer.OPEN3;
        }
        if ((facing = EnumFacing.func_82600_a((int)tile.getDirection())).func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return state.func_177226_a(SLOTS, (Comparable)slots).func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @Nullable
    public TileEntityDrawers createNewTileEntity(World worldIn, int meta) {
        return new TileEntityDrawersComp();
    }

    @Nonnull
    protected ItemStack getMainDrop(IBlockAccess world, BlockPos pos, IBlockState state) {
        boolean hasContents;
        NBTTagCompound data;
        ItemStack drop;
        TileEntityDrawers tile;
        block7: {
            tile = this.getTileEntity(world, pos);
            if (tile == null) {
                return ItemCustomDrawers.makeItemStack((IBlockState)state, (int)1, (ItemStack)ItemStack.field_190927_a, (ItemStack)ItemStack.field_190927_a, (ItemStack)ItemStack.field_190927_a);
            }
            drop = ItemCustomDrawers.makeItemStack((IBlockState)state, (int)1, (ItemStack)tile.material().getSide(), (ItemStack)tile.material().getTrim(), (ItemStack)tile.material().getFront());
            if (drop.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            data = drop.func_77978_p();
            if (data == null) {
                data = new NBTTagCompound();
            }
            hasContents = false;
            if (StorageDrawers.config.cache.keepContentsOnBreak) {
                int i;
                for (i = 0; i < tile.getGroup().getDrawerCount(); ++i) {
                    IDrawer drawer = tile.getGroup().getDrawer(i);
                    if (drawer.isEmpty()) continue;
                    hasContents = true;
                    break block7;
                }
                for (i = 0; i < tile.upgrades().getSlotCount(); ++i) {
                    if (tile.upgrades().getUpgrade(i).func_190926_b()) continue;
                    hasContents = true;
                    break;
                }
            }
        }
        if (tile.isSealed() || StorageDrawers.config.cache.keepContentsOnBreak && hasContents) {
            NBTTagCompound tiledata = new NBTTagCompound();
            tile.func_189515_b(tiledata);
            data.func_74782_a("tile", (NBTBase)tiledata);
        }
        drop.func_77982_d(data);
        return drop;
    }
}

