/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability;

import gregtech.api.capability.IFilter;
import gregtech.api.capability.IFilteredFluidContainer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IMultipleTankHandler
extends IFluidHandler,
Iterable<MultiFluidTankEntry> {
    public static final Comparator<MultiFluidTankEntry> ENTRY_COMPARATOR = (o1, o2) -> {
        boolean empty2;
        boolean empty1 = o1.getFluidAmount() <= 0;
        boolean bl = empty2 = o2.getFluidAmount() <= 0;
        if (empty1 != empty2) {
            return empty1 ? 1 : -1;
        }
        IFilter<FluidStack> filter1 = o1.getFilter();
        IFilter<FluidStack> filter2 = o2.getFilter();
        if (filter1 == null) {
            return filter2 == null ? 0 : 1;
        }
        if (filter2 == null) {
            return -1;
        }
        return IFilter.FILTER_COMPARATOR.compare(filter1, filter2);
    };

    @NotNull
    public List<MultiFluidTankEntry> getFluidTanks();

    public int getTanks();

    @NotNull
    public MultiFluidTankEntry getTankAt(int var1);

    public boolean allowSameFluidFill();

    default public int getIndexOfFluid(@Nullable FluidStack fluidStack) {
        List<MultiFluidTankEntry> fluidTanks = this.getFluidTanks();
        for (int i = 0; i < fluidTanks.size(); ++i) {
            FluidStack tankStack = fluidTanks.get(i).getFluid();
            if (fluidStack != tankStack && (tankStack == null || !tankStack.isFluidEqual(fluidStack))) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public Iterator<MultiFluidTankEntry> iterator() {
        return this.getFluidTanks().iterator();
    }

    public static final class MultiFluidTankEntry
    implements IFluidTank,
    IFluidHandler,
    IFilteredFluidContainer {
        private final IMultipleTankHandler tank;
        private final IFluidTank delegate;

        public MultiFluidTankEntry(@NotNull IMultipleTankHandler tank, @NotNull IFluidTank delegate) {
            this.tank = tank;
            this.delegate = delegate;
        }

        @NotNull
        public IMultipleTankHandler getTank() {
            return this.tank;
        }

        @NotNull
        public IFluidTank getDelegate() {
            return this.delegate;
        }

        public boolean allowSameFluidFill() {
            return this.tank.allowSameFluidFill();
        }

        @Override
        @Nullable
        public IFilter<FluidStack> getFilter() {
            IFilter<FluidStack> iFilter;
            IFluidTank iFluidTank = this.delegate;
            if (iFluidTank instanceof IFilteredFluidContainer) {
                IFilteredFluidContainer filtered = (IFilteredFluidContainer)iFluidTank;
                iFilter = filtered.getFilter();
            } else {
                iFilter = null;
            }
            return iFilter;
        }

        @NotNull
        public IFluidTankProperties[] getTankProperties() {
            IFluidTankProperties[] iFluidTankPropertiesArray;
            IFluidTank iFluidTank = this.delegate;
            if (iFluidTank instanceof IFluidHandler) {
                IFluidHandler fluidHandler = (IFluidHandler)iFluidTank;
                iFluidTankPropertiesArray = fluidHandler.getTankProperties();
            } else {
                IFluidTankProperties[] iFluidTankPropertiesArray2 = new IFluidTankProperties[1];
                iFluidTankPropertiesArray = iFluidTankPropertiesArray2;
                iFluidTankPropertiesArray2[0] = new FallbackTankProperty();
            }
            return iFluidTankPropertiesArray;
        }

        public NBTTagCompound trySerialize() {
            IFluidTank iFluidTank = this.delegate;
            if (iFluidTank instanceof FluidTank) {
                FluidTank fluidTank = (FluidTank)iFluidTank;
                return fluidTank.writeToNBT(new NBTTagCompound());
            }
            iFluidTank = this.delegate;
            if (iFluidTank instanceof INBTSerializable) {
                INBTSerializable serializable = (INBTSerializable)iFluidTank;
                try {
                    return (NBTTagCompound)serializable.serializeNBT();
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return new NBTTagCompound();
        }

        public void tryDeserialize(NBTTagCompound tag) {
            IFluidTank iFluidTank = this.delegate;
            if (iFluidTank instanceof FluidTank) {
                FluidTank fluidTank = (FluidTank)iFluidTank;
                fluidTank.readFromNBT(tag);
            } else {
                iFluidTank = this.delegate;
                if (iFluidTank instanceof INBTSerializable) {
                    INBTSerializable serializable = (INBTSerializable)iFluidTank;
                    try {
                        serializable.deserializeNBT((NBTBase)tag);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
        }

        @Nullable
        public FluidStack getFluid() {
            return this.delegate.getFluid();
        }

        public int getFluidAmount() {
            return this.delegate.getFluidAmount();
        }

        public int getCapacity() {
            return this.delegate.getCapacity();
        }

        public FluidTankInfo getInfo() {
            return this.delegate.getInfo();
        }

        public int fill(FluidStack resource, boolean doFill) {
            return this.delegate.fill(resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null || resource.amount <= 0) {
                return null;
            }
            IFluidTank iFluidTank = this.delegate;
            if (iFluidTank instanceof IFluidHandler) {
                IFluidHandler fluidHandler = (IFluidHandler)iFluidTank;
                return fluidHandler.drain(resource, doDrain);
            }
            FluidStack fluid = this.delegate.getFluid();
            return fluid != null && fluid.isFluidEqual(resource) ? this.drain(resource.amount, doDrain) : null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.delegate.drain(maxDrain, doDrain);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || this.delegate.equals(obj);
        }

        public String toString() {
            return this.delegate.toString();
        }

        private final class FallbackTankProperty
        implements IFluidTankProperties {
            private FallbackTankProperty() {
            }

            @Nullable
            public FluidStack getContents() {
                return MultiFluidTankEntry.this.delegate.getFluid();
            }

            public int getCapacity() {
                return MultiFluidTankEntry.this.delegate.getCapacity();
            }

            public boolean canFill() {
                return true;
            }

            public boolean canDrain() {
                return true;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                IFilter<FluidStack> filter = MultiFluidTankEntry.this.getFilter();
                return filter == null || filter.test(fluidStack);
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return true;
            }
        }
    }
}

