/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IMultiblockController;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.CommonFluidFilters;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTLog;
import gregtech.common.ConfigHolder;
import gregtech.common.metatileentities.multi.MetaTileEntityLargeBoiler;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoilerRecipeLogic
extends AbstractRecipeLogic {
    private static final long STEAM_PER_WATER = 160L;
    private static final int FLUID_DRAIN_MULTIPLIER = 100;
    private static final int FLUID_BURNTIME_TO_EU = 8;
    private int currentHeat;
    private int lastTickSteamOutput;
    private int excessWater;
    private int excessFuel;
    private int excessProjectedEU;

    public BoilerRecipeLogic(MetaTileEntityLargeBoiler tileEntity) {
        super(tileEntity, null);
        this.fluidOutputs = Collections.emptyList();
        this.itemOutputs = NonNullList.func_191196_a();
    }

    @Override
    public void update() {
        if (!(this.isActive() && this.canProgressRecipe() && this.isWorkingEnabled() || this.currentHeat <= 0)) {
            this.setHeat(this.currentHeat - 1);
            this.setLastTickSteam(0);
        }
        super.update();
    }

    @Override
    protected boolean canProgressRecipe() {
        return super.canProgressRecipe() && (!(this.metaTileEntity instanceof IMultiblockController) || !((IMultiblockController)((Object)this.metaTileEntity)).isStructureObstructed());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void trySearchNewRecipe() {
        MetaTileEntityLargeBoiler boiler = (MetaTileEntityLargeBoiler)this.metaTileEntity;
        if (ConfigHolder.machines.enableMaintenance && boiler.hasMaintenanceMechanics() && boiler.getNumMaintenanceProblems() > 5) {
            return;
        }
        FluidTankList importFluids = boiler.getImportFluids();
        NonNullList dummyList = NonNullList.func_191196_a();
        boolean didStartRecipe = false;
        for (IFluidTank iFluidTank : importFluids.getFluidTanks()) {
            FluidStack fuelStack = iFluidTank.drain(Integer.MAX_VALUE, false);
            if (fuelStack == null || CommonFluidFilters.BOILER_FLUID.test(fuelStack)) continue;
            Recipe dieselRecipe = RecipeMaps.COMBUSTION_GENERATOR_FUELS.findRecipe(GTValues.V[14], (List<ItemStack>)dummyList, Collections.singletonList(fuelStack));
            if (dieselRecipe != null && fuelStack.amount >= dieselRecipe.getFluidInputs().get(0).getAmount() * 100) {
                iFluidTank.drain(dieselRecipe.getFluidInputs().get(0).getAmount() * 100, true);
                this.setMaxProgress(this.adjustBurnTimeForThrottle(Math.max(1, boiler.boilerType.runtimeBoost(Math.abs(dieselRecipe.getEUt()) * dieselRecipe.getDuration() / 8 / 2))));
                didStartRecipe = true;
                break;
            }
            Recipe denseFuelRecipe = RecipeMaps.SEMI_FLUID_GENERATOR_FUELS.findRecipe(GTValues.V[14], (List<ItemStack>)dummyList, Collections.singletonList(fuelStack));
            if (denseFuelRecipe == null || fuelStack.amount < denseFuelRecipe.getFluidInputs().get(0).getAmount() * 100) continue;
            iFluidTank.drain(denseFuelRecipe.getFluidInputs().get(0).getAmount() * 100, true);
            this.setMaxProgress(this.adjustBurnTimeForThrottle(Math.max(1, boiler.boilerType.runtimeBoost(Math.abs(denseFuelRecipe.getEUt()) * denseFuelRecipe.getDuration() / 8 * 2))));
            didStartRecipe = true;
            break;
        }
        if (!didStartRecipe) {
            void var6_8;
            IItemHandlerModifiable importItems = boiler.getImportItems();
            boolean bl = false;
            while (var6_8 < importItems.getSlots()) {
                ItemStack stack = importItems.getStackInSlot((int)var6_8);
                int fuelBurnTime = (int)Math.ceil(TileEntityFurnace.func_145952_a((ItemStack)stack));
                if (fuelBurnTime / 80 > 0 && FluidUtil.getFluidHandler((ItemStack)stack) == null) {
                    this.excessFuel += fuelBurnTime % 80;
                    int excessProgress = this.excessFuel / 80;
                    this.excessFuel %= 80;
                    this.setMaxProgress(excessProgress + this.adjustBurnTimeForThrottle(boiler.boilerType.runtimeBoost(fuelBurnTime / 80)));
                    stack.func_190918_g(1);
                    didStartRecipe = true;
                    break;
                }
                ++var6_8;
            }
        }
        if (didStartRecipe) {
            this.progressTime = 1;
            this.recipeEUt = this.adjustEUtForThrottle(boiler.boilerType.steamPerTick());
            if (this.wasActiveAndNeedsUpdate) {
                this.wasActiveAndNeedsUpdate = false;
            } else {
                this.setActive(true);
            }
        }
        this.metaTileEntity.getNotifiedItemInputList().clear();
        this.metaTileEntity.getNotifiedFluidInputList().clear();
    }

    @Override
    protected void updateRecipeProgress() {
        if (this.canRecipeProgress) {
            int generatedSteam = this.recipeEUt * this.getMaximumHeatFromMaintenance() / this.getMaximumHeat();
            if (generatedSteam > 0) {
                long amount = ((long)generatedSteam + 160L) / 160L;
                this.excessWater = (int)((long)this.excessWater + (amount * 160L - (long)generatedSteam));
                this.excessWater = (int)((long)this.excessWater % 160L);
                FluidStack drainedWater = BoilerRecipeLogic.getBoilerFluidFromContainer(this.getInputTank(), (int)(amount -= (long)this.excessWater / 160L));
                if (amount != 0L && (drainedWater == null || (long)drainedWater.amount < amount)) {
                    this.getMetaTileEntity().explodeMultiblock(1.0f * (float)this.currentHeat / (float)this.getMaximumHeat() * 8.0f);
                } else {
                    this.setLastTickSteam(generatedSteam);
                    this.getOutputTank().fill(Materials.Steam.getFluid(generatedSteam), true);
                }
            }
            if (this.currentHeat < this.getMaximumHeat()) {
                this.setHeat(this.currentHeat + 1);
            }
            if (++this.progressTime > this.maxProgressTime) {
                this.completeRecipe();
            }
        }
    }

    private int getMaximumHeatFromMaintenance() {
        if (ConfigHolder.machines.enableMaintenance) {
            return (int)Math.min((double)this.currentHeat, (1.0 - 0.1 * (double)this.getMetaTileEntity().getNumMaintenanceProblems()) * (double)this.getMaximumHeat());
        }
        return this.currentHeat;
    }

    private int adjustEUtForThrottle(int rawEUt) {
        int throttle = ((MetaTileEntityLargeBoiler)this.metaTileEntity).getThrottle();
        return Math.max(25, (int)((double)rawEUt * ((double)throttle / 100.0)));
    }

    private int adjustBurnTimeForThrottle(int rawBurnTime) {
        MetaTileEntityLargeBoiler boiler = (MetaTileEntityLargeBoiler)this.metaTileEntity;
        int EUt = boiler.boilerType.steamPerTick();
        int adjustedEUt = this.adjustEUtForThrottle(EUt);
        int adjustedBurnTime = rawBurnTime * EUt / adjustedEUt;
        this.excessProjectedEU += EUt * rawBurnTime - adjustedEUt * adjustedBurnTime;
        this.excessProjectedEU %= adjustedEUt;
        return adjustedBurnTime += this.excessProjectedEU / adjustedEUt;
    }

    private int getMaximumHeat() {
        return ((MetaTileEntityLargeBoiler)this.metaTileEntity).boilerType.getTicksToBoiling();
    }

    public int getHeatScaled() {
        return (int)Math.round((double)this.currentHeat / (1.0 * (double)this.getMaximumHeat()) * 100.0);
    }

    public void setHeat(int heat) {
        if (heat != this.currentHeat && !this.metaTileEntity.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.BOILER_HEAT, b -> b.func_150787_b(heat));
        }
        this.currentHeat = heat;
    }

    public int getLastTickSteam() {
        return this.lastTickSteamOutput;
    }

    public void setLastTickSteam(int lastTickSteamOutput) {
        if (lastTickSteamOutput != this.lastTickSteamOutput && !this.metaTileEntity.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.BOILER_LAST_TICK_STEAM, b -> b.func_150787_b(lastTickSteamOutput));
        }
        this.lastTickSteamOutput = lastTickSteamOutput;
    }

    @Override
    public int getInfoProviderEUt() {
        return this.lastTickSteamOutput;
    }

    @Override
    public boolean consumesEnergy() {
        return false;
    }

    public void invalidate() {
        this.progressTime = 0;
        this.maxProgressTime = 0;
        this.recipeEUt = 0;
        this.setActive(false);
        this.setLastTickSteam(0);
    }

    @Override
    protected void completeRecipe() {
        this.progressTime = 0;
        this.setMaxProgress(0);
        this.recipeEUt = 0;
        this.wasActiveAndNeedsUpdate = true;
    }

    @Override
    @NotNull
    public MetaTileEntityLargeBoiler getMetaTileEntity() {
        return (MetaTileEntityLargeBoiler)super.getMetaTileEntity();
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74768_a("Heat", this.currentHeat);
        compound.func_74768_a("ExcessFuel", this.excessFuel);
        compound.func_74768_a("ExcessWater", this.excessWater);
        compound.func_74768_a("ExcessProjectedEU", this.excessProjectedEU);
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.currentHeat = compound.func_74762_e("Heat");
        this.excessFuel = compound.func_74762_e("ExcessFuel");
        this.excessWater = compound.func_74762_e("ExcessWater");
        this.excessProjectedEU = compound.func_74762_e("ExcessProjectedEU");
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.func_150787_b(this.currentHeat);
        buf.func_150787_b(this.lastTickSteamOutput);
    }

    @Override
    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.currentHeat = buf.func_150792_a();
        this.lastTickSteamOutput = buf.func_150792_a();
    }

    @Override
    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.BOILER_HEAT) {
            this.currentHeat = buf.func_150792_a();
        } else if (dataId == GregtechDataCodes.BOILER_LAST_TICK_STEAM) {
            this.lastTickSteamOutput = buf.func_150792_a();
        }
    }

    @Override
    protected long getEnergyInputPerSecond() {
        GTLog.logger.error("Large Boiler called getEnergyInputPerSecond(), this should not be possible!");
        return 0L;
    }

    @Override
    protected long getEnergyStored() {
        GTLog.logger.error("Large Boiler called getEnergyStored(), this should not be possible!");
        return 0L;
    }

    @Override
    protected long getEnergyCapacity() {
        GTLog.logger.error("Large Boiler called getEnergyCapacity(), this should not be possible!");
        return 0L;
    }

    @Override
    protected boolean drawEnergy(int recipeEUt, boolean simulate) {
        GTLog.logger.error("Large Boiler called drawEnergy(), this should not be possible!");
        return false;
    }

    @Override
    public long getMaxVoltage() {
        GTLog.logger.error("Large Boiler called getMaxVoltage(), this should not be possible!");
        return 0L;
    }

    @Nullable
    private static FluidStack getBoilerFluidFromContainer(@NotNull IFluidHandler fluidHandler, int amount) {
        if (amount == 0) {
            return null;
        }
        FluidStack drainedWater = fluidHandler.drain(Materials.Water.getFluid(amount), true);
        if (drainedWater == null || drainedWater.amount == 0) {
            drainedWater = fluidHandler.drain(Materials.DistilledWater.getFluid(amount), true);
        }
        if (drainedWater == null || drainedWater.amount == 0) {
            String fluidName;
            Fluid fluid;
            String[] stringArray = ConfigHolder.machines.boilerFluids;
            int n = stringArray.length;
            for (int i = 0; i < n && ((fluid = FluidRegistry.getFluid((String)(fluidName = stringArray[i]))) == null || (drainedWater = fluidHandler.drain(new FluidStack(fluid, amount), true)) == null || drainedWater.amount <= 0); ++i) {
            }
        }
        return drainedWater;
    }
}

