/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.IMultipleTankHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidTankList
implements IMultipleTankHandler,
INBTSerializable<NBTTagCompound> {
    private final IMultipleTankHandler.MultiFluidTankEntry[] fluidTanks;
    private final boolean allowSameFluidFill;

    public FluidTankList(boolean allowSameFluidFill, IFluidTank ... fluidTanks) {
        ArrayList<IMultipleTankHandler.MultiFluidTankEntry> list = new ArrayList<IMultipleTankHandler.MultiFluidTankEntry>();
        for (IFluidTank tank : fluidTanks) {
            list.add(this.wrapIntoEntry(tank));
        }
        this.fluidTanks = list.toArray(new IMultipleTankHandler.MultiFluidTankEntry[0]);
        this.allowSameFluidFill = allowSameFluidFill;
    }

    public FluidTankList(boolean allowSameFluidFill, @NotNull List<? extends IFluidTank> fluidTanks) {
        ArrayList<IMultipleTankHandler.MultiFluidTankEntry> list = new ArrayList<IMultipleTankHandler.MultiFluidTankEntry>();
        for (IFluidTank iFluidTank : fluidTanks) {
            list.add(this.wrapIntoEntry(iFluidTank));
        }
        this.fluidTanks = list.toArray(new IMultipleTankHandler.MultiFluidTankEntry[0]);
        this.allowSameFluidFill = allowSameFluidFill;
    }

    public FluidTankList(boolean allowSameFluidFill, @NotNull IMultipleTankHandler parent, IFluidTank ... additionalTanks) {
        ArrayList<IMultipleTankHandler.MultiFluidTankEntry> list = new ArrayList<IMultipleTankHandler.MultiFluidTankEntry>(parent.getFluidTanks());
        for (IFluidTank tank : additionalTanks) {
            list.add(this.wrapIntoEntry(tank));
        }
        this.fluidTanks = list.toArray(new IMultipleTankHandler.MultiFluidTankEntry[0]);
        this.allowSameFluidFill = allowSameFluidFill;
    }

    private IMultipleTankHandler.MultiFluidTankEntry wrapIntoEntry(IFluidTank tank) {
        IMultipleTankHandler.MultiFluidTankEntry entry;
        return tank instanceof IMultipleTankHandler.MultiFluidTankEntry ? (entry = (IMultipleTankHandler.MultiFluidTankEntry)tank) : new IMultipleTankHandler.MultiFluidTankEntry(this, tank);
    }

    @Override
    @NotNull
    public List<IMultipleTankHandler.MultiFluidTankEntry> getFluidTanks() {
        return Collections.unmodifiableList(Arrays.asList(this.fluidTanks));
    }

    @Override
    public int getTanks() {
        return this.fluidTanks.length;
    }

    @Override
    @NotNull
    public IMultipleTankHandler.MultiFluidTankEntry getTankAt(int index) {
        return this.fluidTanks[index];
    }

    @NotNull
    public IFluidTankProperties[] getTankProperties() {
        ArrayList propertiesList = new ArrayList();
        for (IMultipleTankHandler.MultiFluidTankEntry fluidTank : this.fluidTanks) {
            Collections.addAll(propertiesList, fluidTank.getTankProperties());
        }
        return propertiesList.toArray(new IFluidTankProperties[0]);
    }

    @Override
    public boolean allowSameFluidFill() {
        return this.allowSameFluidFill;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        int totalInserted = 0;
        boolean inputFluidCopied = false;
        boolean distinctSlotVisited = false;
        IMultipleTankHandler.MultiFluidTankEntry[] fluidTanks = (IMultipleTankHandler.MultiFluidTankEntry[])this.fluidTanks.clone();
        Arrays.sort(fluidTanks, IMultipleTankHandler.ENTRY_COMPARATOR);
        for (IMultipleTankHandler.MultiFluidTankEntry tank : fluidTanks) {
            if (!resource.isFluidEqual(tank.getFluid())) continue;
            int inserted = tank.fill(resource, doFill);
            if (inserted > 0) {
                totalInserted += inserted;
                if (resource.amount - inserted <= 0) {
                    return totalInserted;
                }
                if (!inputFluidCopied) {
                    inputFluidCopied = true;
                    resource = resource.copy();
                }
                resource.amount -= inserted;
            }
            if (tank.allowSameFluidFill()) continue;
            distinctSlotVisited = true;
        }
        for (IMultipleTankHandler.MultiFluidTankEntry tank : fluidTanks) {
            int inserted;
            boolean usesDistinctFluidFill = tank.allowSameFluidFill();
            if (!usesDistinctFluidFill && distinctSlotVisited || tank.getFluidAmount() != 0 || (inserted = tank.fill(resource, doFill)) <= 0) continue;
            totalInserted += inserted;
            if (resource.amount - inserted <= 0) {
                return totalInserted;
            }
            if (!inputFluidCopied) {
                inputFluidCopied = true;
                resource = resource.copy();
            }
            resource.amount -= inserted;
            if (usesDistinctFluidFill) continue;
            distinctSlotVisited = true;
        }
        return totalInserted;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || resource.amount <= 0) {
            return null;
        }
        int amountLeft = resource.amount;
        FluidStack totalDrained = null;
        for (IMultipleTankHandler.MultiFluidTankEntry handler : this.fluidTanks) {
            FluidStack drain;
            if (!resource.isFluidEqual(handler.getFluid()) || (drain = handler.drain(amountLeft, doDrain)) == null) continue;
            if (totalDrained == null) {
                totalDrained = drain;
            } else {
                totalDrained.amount += drain.amount;
            }
            if ((amountLeft -= drain.amount) > 0) continue;
            return totalDrained;
        }
        return totalDrained;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        FluidStack totalDrained = null;
        for (IMultipleTankHandler.MultiFluidTankEntry handler : this.fluidTanks) {
            if (totalDrained == null) {
                totalDrained = handler.drain(maxDrain, doDrain);
                if (totalDrained != null) {
                    maxDrain -= totalDrained.amount;
                }
            } else {
                if (!totalDrained.isFluidEqual(handler.getFluid())) continue;
                FluidStack drain = handler.drain(maxDrain, doDrain);
                if (drain != null) {
                    totalDrained.amount += drain.amount;
                    maxDrain -= drain.amount;
                }
            }
            if (maxDrain > 0) continue;
            return totalDrained;
        }
        return totalDrained;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound fluidInventory = new NBTTagCompound();
        NBTTagList tanks = new NBTTagList();
        for (int i = 0; i < this.getTanks(); ++i) {
            tanks.func_74742_a((NBTBase)this.fluidTanks[i].trySerialize());
        }
        fluidInventory.func_74782_a("Tanks", (NBTBase)tanks);
        return fluidInventory;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList tanks = nbt.func_150295_c("Tanks", 10);
        for (int i = 0; i < Math.min(this.fluidTanks.length, tanks.func_74745_c()); ++i) {
            this.fluidTanks[i].tryDeserialize(tanks.func_150305_b(i));
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean lineBreak) {
        StringBuilder stb = new StringBuilder("FluidTankList[").append(this.fluidTanks.length).append(";");
        for (int i = 0; i < this.fluidTanks.length; ++i) {
            if (i != 0) {
                stb.append(',');
            }
            stb.append(lineBreak ? "\n  " : " ");
            FluidStack fluid = this.fluidTanks[i].getFluid();
            if (fluid == null || fluid.amount == 0) {
                stb.append("None 0 / ").append(this.fluidTanks[i].getCapacity());
                continue;
            }
            stb.append(fluid.getFluid().getName()).append(' ').append(fluid.amount).append(" / ").append(this.fluidTanks[i].getCapacity());
        }
        if (lineBreak) {
            stb.append('\n');
        }
        return stb.append(']').toString();
    }
}

