/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultiblockController;
import gregtech.api.capability.IMultipleRecipeMaps;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.Tuple;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiblockRecipeLogic
extends AbstractRecipeLogic {
    protected int lastRecipeIndex = 0;
    protected IItemHandlerModifiable currentDistinctInputBus;
    protected List<IItemHandlerModifiable> invalidatedInputList = new ArrayList<IItemHandlerModifiable>();

    public MultiblockRecipeLogic(RecipeMapMultiblockController tileEntity) {
        super(tileEntity, tileEntity.recipeMap);
    }

    public MultiblockRecipeLogic(RecipeMapMultiblockController tileEntity, boolean hasPerfectOC) {
        super(tileEntity, tileEntity.recipeMap, hasPerfectOC);
    }

    @Override
    public void update() {
    }

    public void updateWorkable() {
        super.update();
    }

    @Override
    protected boolean canProgressRecipe() {
        return super.canProgressRecipe() && !((IMultiblockController)((Object)this.metaTileEntity)).isStructureObstructed();
    }

    public void invalidate() {
        this.previousRecipe = null;
        this.progressTime = 0;
        this.maxProgressTime = 0;
        this.recipeEUt = 0;
        this.fluidOutputs = null;
        this.itemOutputs = null;
        this.lastRecipeIndex = 0;
        this.parallelRecipesPerformed = 0;
        this.isOutputsFull = false;
        this.invalidInputsForRecipes = false;
        this.invalidatedInputList.clear();
        this.setActive(false);
    }

    public void onDistinctChanged() {
        this.lastRecipeIndex = 0;
    }

    public IEnergyContainer getEnergyContainer() {
        RecipeMapMultiblockController controller = (RecipeMapMultiblockController)this.metaTileEntity;
        return controller.getEnergyContainer();
    }

    @Override
    protected IItemHandlerModifiable getInputInventory() {
        RecipeMapMultiblockController controller = (RecipeMapMultiblockController)this.metaTileEntity;
        return controller.getInputInventory();
    }

    protected List<IItemHandlerModifiable> getInputBuses() {
        RecipeMapMultiblockController controller = (RecipeMapMultiblockController)this.metaTileEntity;
        return controller.getAbilities(MultiblockAbility.IMPORT_ITEMS);
    }

    @Override
    protected IItemHandlerModifiable getOutputInventory() {
        RecipeMapMultiblockController controller = (RecipeMapMultiblockController)this.metaTileEntity;
        return controller.getOutputInventory();
    }

    @Override
    protected IMultipleTankHandler getInputTank() {
        RecipeMapMultiblockController controller = (RecipeMapMultiblockController)this.metaTileEntity;
        return controller.getInputFluidInventory();
    }

    @Override
    protected IMultipleTankHandler getOutputTank() {
        RecipeMapMultiblockController controller = (RecipeMapMultiblockController)this.metaTileEntity;
        return controller.getOutputFluidInventory();
    }

    @Override
    protected boolean canWorkWithInputs() {
        RecipeMapMultiblockController distinctController;
        MultiblockWithDisplayBase controller = (MultiblockWithDisplayBase)this.metaTileEntity;
        if (controller instanceof RecipeMapMultiblockController && (distinctController = (RecipeMapMultiblockController)controller).canBeDistinct() && distinctController.isDistinct() && this.getInputInventory().getSlots() > 0) {
            boolean canWork = false;
            if (this.invalidatedInputList.isEmpty()) {
                return true;
            }
            if (!this.metaTileEntity.getNotifiedFluidInputList().isEmpty()) {
                canWork = true;
                this.invalidatedInputList.clear();
                this.metaTileEntity.getNotifiedFluidInputList().clear();
                this.metaTileEntity.getNotifiedItemInputList().clear();
            } else {
                Iterator<IItemHandlerModifiable> notifiedIter = this.metaTileEntity.getNotifiedItemInputList().iterator();
                while (notifiedIter.hasNext()) {
                    IItemHandlerModifiable bus = notifiedIter.next();
                    Iterator<IItemHandlerModifiable> iterator = this.invalidatedInputList.iterator();
                    block1: while (iterator.hasNext()) {
                        IItemHandler invalidatedHandler = (IItemHandler)iterator.next();
                        if (invalidatedHandler instanceof ItemHandlerList) {
                            for (IItemHandler ih : ((ItemHandlerList)invalidatedHandler).getBackingHandlers()) {
                                if (ih != bus) continue;
                                canWork = true;
                                iterator.remove();
                                continue block1;
                            }
                            continue;
                        }
                        if (invalidatedHandler != bus) continue;
                        canWork = true;
                        iterator.remove();
                    }
                    notifiedIter.remove();
                }
            }
            ArrayList<IItemHandler> flattenedHandlers = new ArrayList<IItemHandler>();
            for (IItemHandler iItemHandler : this.getInputBuses()) {
                if (iItemHandler instanceof ItemHandlerList) {
                    flattenedHandlers.addAll(((ItemHandlerList)iItemHandler).getBackingHandlers());
                }
                flattenedHandlers.add(iItemHandler);
            }
            if (!this.invalidatedInputList.containsAll(flattenedHandlers)) {
                canWork = true;
            }
            return canWork;
        }
        return super.canWorkWithInputs();
    }

    @Override
    protected void trySearchNewRecipe() {
        RecipeMapMultiblockController distinctController;
        MultiblockWithDisplayBase controller = (MultiblockWithDisplayBase)this.metaTileEntity;
        if (ConfigHolder.machines.enableMaintenance && controller.hasMaintenanceMechanics() && controller.getNumMaintenanceProblems() > 5) {
            return;
        }
        if (controller instanceof RecipeMapMultiblockController && (distinctController = (RecipeMapMultiblockController)controller).canBeDistinct() && distinctController.isDistinct() && this.getInputInventory().getSlots() > 0) {
            this.trySearchNewRecipeDistinct();
            return;
        }
        this.trySearchNewRecipeCombined();
    }

    protected void trySearchNewRecipeCombined() {
        super.trySearchNewRecipe();
    }

    protected void trySearchNewRecipeDistinct() {
        Recipe currentRecipe;
        long maxVoltage = this.getMaxVoltage();
        List<IItemHandlerModifiable> importInventory = this.getInputBuses();
        IMultipleTankHandler importFluids = this.getInputTank();
        if (this.checkPreviousRecipeDistinct(importInventory.get(this.lastRecipeIndex)) && this.checkRecipe(this.previousRecipe)) {
            currentRecipe = this.previousRecipe;
            this.currentDistinctInputBus = importInventory.get(this.lastRecipeIndex);
            if (this.prepareRecipeDistinct(currentRecipe)) {
                return;
            }
        }
        for (int i = 0; i < importInventory.size(); ++i) {
            IItemHandlerModifiable bus = importInventory.get(i);
            if (this.invalidatedInputList.contains(bus)) continue;
            currentRecipe = this.findRecipe(maxVoltage, bus, importFluids);
            if (currentRecipe != null && this.checkRecipe(currentRecipe)) {
                this.previousRecipe = currentRecipe;
                this.currentDistinctInputBus = bus;
                if (this.prepareRecipeDistinct(currentRecipe)) {
                    this.lastRecipeIndex = i;
                    return;
                }
            }
            if (currentRecipe != null) continue;
            this.invalidatedInputList.add(bus);
        }
    }

    @Override
    public void invalidateInputs() {
        MultiblockWithDisplayBase controller = (MultiblockWithDisplayBase)this.metaTileEntity;
        RecipeMapMultiblockController distinctController = (RecipeMapMultiblockController)controller;
        if (distinctController.canBeDistinct() && distinctController.isDistinct() && this.getInputInventory().getSlots() > 0) {
            this.invalidatedInputList.add(this.currentDistinctInputBus);
        } else {
            super.invalidateInputs();
        }
    }

    protected boolean checkPreviousRecipeDistinct(IItemHandlerModifiable previousBus) {
        return this.previousRecipe != null && this.previousRecipe.matches(false, previousBus, this.getInputTank());
    }

    protected boolean prepareRecipeDistinct(Recipe recipe) {
        recipe = Recipe.trimRecipeOutputs(recipe, this.getRecipeMap(), this.metaTileEntity.getItemOutputLimit(), this.metaTileEntity.getFluidOutputLimit());
        if ((recipe = this.findParallelRecipe(recipe, this.currentDistinctInputBus, this.getInputTank(), this.getOutputInventory(), this.getOutputTank(), this.getMaxParallelVoltage(), this.getParallelLimit())) != null && this.setupAndConsumeRecipeInputs(recipe, this.currentDistinctInputBus)) {
            this.setupRecipe(recipe);
            return true;
        }
        return false;
    }

    @Override
    protected void modifyOverclockPre(int @NotNull [] values, @NotNull IRecipePropertyStorage storage) {
        super.modifyOverclockPre(values, storage);
        Tuple<Integer, Double> maintenanceValues = this.getMaintenanceValues();
        if ((Double)maintenanceValues.func_76340_b() != 1.0) {
            values[1] = (int)Math.round((double)values[1] * (Double)maintenanceValues.func_76340_b());
        }
    }

    @Override
    protected void modifyOverclockPost(int[] overclockResults, @NotNull IRecipePropertyStorage storage) {
        super.modifyOverclockPost(overclockResults, storage);
        Tuple<Integer, Double> maintenanceValues = this.getMaintenanceValues();
        if ((Integer)maintenanceValues.func_76341_a() > 0) {
            overclockResults[1] = (int)((double)overclockResults[1] * (1.0 + 0.1 * (double)((Integer)maintenanceValues.func_76341_a()).intValue()));
        }
    }

    @Override
    public long getMaximumOverclockVoltage() {
        IEnergyContainer energyContainer = this.getEnergyContainer();
        if (energyContainer instanceof EnergyContainerList) {
            long amperage;
            long voltage;
            if (energyContainer.getInputVoltage() > energyContainer.getOutputVoltage()) {
                voltage = energyContainer.getInputVoltage();
                amperage = energyContainer.getInputAmperage();
            } else {
                voltage = energyContainer.getOutputVoltage();
                amperage = energyContainer.getOutputAmperage();
            }
            if (amperage == 1L) {
                return GTValues.V[GTUtility.getFloorTierByVoltage(voltage)];
            }
            return voltage;
        }
        return Math.max(energyContainer.getInputVoltage(), energyContainer.getOutputVoltage());
    }

    @NotNull
    protected Tuple<Integer, Double> getMaintenanceValues() {
        MultiblockWithDisplayBase displayBase = this.metaTileEntity instanceof MultiblockWithDisplayBase ? (MultiblockWithDisplayBase)this.metaTileEntity : null;
        int numMaintenanceProblems = displayBase == null || !displayBase.hasMaintenanceMechanics() || !ConfigHolder.machines.enableMaintenance ? 0 : displayBase.getNumMaintenanceProblems();
        double durationMultiplier = 1.0;
        if (displayBase != null && displayBase.hasMaintenanceMechanics() && ConfigHolder.machines.enableMaintenance) {
            durationMultiplier = displayBase.getMaintenanceDurationMultiplier();
        }
        return new Tuple((Object)numMaintenanceProblems, (Object)durationMultiplier);
    }

    @Override
    public boolean checkRecipe(@NotNull Recipe recipe) {
        RecipeMapMultiblockController controller = (RecipeMapMultiblockController)this.metaTileEntity;
        if (controller.checkRecipe(recipe, false)) {
            controller.checkRecipe(recipe, true);
            return super.checkRecipe(recipe);
        }
        return false;
    }

    @Override
    protected void completeRecipe() {
        this.performMufflerOperations();
        super.completeRecipe();
    }

    protected void performMufflerOperations() {
        MultiblockWithDisplayBase controller;
        MetaTileEntity metaTileEntity = this.metaTileEntity;
        if (metaTileEntity instanceof MultiblockWithDisplayBase && (controller = (MultiblockWithDisplayBase)metaTileEntity).hasMufflerMechanics()) {
            if (this.parallelRecipesPerformed > 1) {
                controller.outputRecoveryItems(this.parallelRecipesPerformed);
            } else {
                controller.outputRecoveryItems();
            }
        }
    }

    @Override
    protected long getEnergyInputPerSecond() {
        return this.getEnergyContainer().getInputPerSec();
    }

    @Override
    protected long getEnergyStored() {
        return this.getEnergyContainer().getEnergyStored();
    }

    @Override
    protected long getEnergyCapacity() {
        return this.getEnergyContainer().getEnergyCapacity();
    }

    @Override
    protected boolean drawEnergy(int recipeEUt, boolean simulate) {
        long resultEnergy = this.getEnergyStored() - (long)recipeEUt;
        if (resultEnergy >= 0L && resultEnergy <= this.getEnergyCapacity()) {
            if (!simulate) {
                this.getEnergyContainer().changeEnergy(-recipeEUt);
            }
            return true;
        }
        return false;
    }

    @Override
    public long getMaxVoltage() {
        IEnergyContainer energyContainer = this.getEnergyContainer();
        if (!this.consumesEnergy()) {
            long voltage = energyContainer.getOutputVoltage();
            long amperage = energyContainer.getOutputAmperage();
            if (energyContainer instanceof EnergyContainerList && amperage == 1L) {
                return GTValues.V[GTUtility.getFloorTierByVoltage(voltage)];
            }
            return voltage;
        }
        if (energyContainer instanceof EnergyContainerList) {
            EnergyContainerList energyList = (EnergyContainerList)energyContainer;
            long highestVoltage = energyList.getHighestInputVoltage();
            if (energyList.getNumHighestInputContainers() > 1) {
                byte tier = GTUtility.getTierByVoltage(highestVoltage);
                return GTValues.V[Math.min(tier + 1, 14)];
            }
            return highestVoltage;
        }
        return energyContainer.getInputVoltage();
    }

    @Override
    protected long getMaxParallelVoltage() {
        return this.getMaximumOverclockVoltage();
    }

    @Override
    @Nullable
    public RecipeMap<?> getRecipeMap() {
        if (this.metaTileEntity instanceof IMultipleRecipeMaps) {
            return ((IMultipleRecipeMaps)((Object)this.metaTileEntity)).getCurrentRecipeMap();
        }
        return super.getRecipeMap();
    }
}

