/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.NotNull;

public class VoidFluidHandlerItemStack
extends FluidHandlerItemStack {
    public VoidFluidHandlerItemStack(@NotNull ItemStack container) {
        this(container, Integer.MAX_VALUE);
    }

    public VoidFluidHandlerItemStack(@NotNull ItemStack container, int capacity) {
        super(container, capacity);
    }

    public FluidStack getFluid() {
        return null;
    }

    protected void setFluid(FluidStack fluid) {
    }

    public IFluidTankProperties[] getTankProperties() {
        return EmptyFluidHandler.EMPTY_TANK_PROPERTIES_ARRAY;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        return Math.min(this.capacity, resource.amount);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return true;
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return false;
    }
}

