/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.cover;

import gregtech.api.GregTechAPI;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverableView;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoverDefinition {
    private final ResourceLocation resourceLocation;
    private final CoverCreator coverCreator;
    private final ItemStack dropItemStack;

    public CoverDefinition(@NotNull ResourceLocation resourceLocation, @NotNull CoverCreator coverCreator, @NotNull ItemStack dropItemStack) {
        this.resourceLocation = resourceLocation;
        this.coverCreator = coverCreator;
        this.dropItemStack = dropItemStack.func_77946_l();
    }

    @Nullable
    public static CoverDefinition getCoverById(@NotNull ResourceLocation id) {
        return (CoverDefinition)GregTechAPI.COVER_REGISTRY.func_82594_a(id);
    }

    @Nullable
    public static CoverDefinition getCoverByNetworkId(int networkId) {
        return (CoverDefinition)GregTechAPI.COVER_REGISTRY.func_148754_a(networkId);
    }

    public static int getNetworkIdForCover(@NotNull CoverDefinition definition) {
        return GregTechAPI.COVER_REGISTRY.func_148757_b(definition);
    }

    @NotNull
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    @NotNull
    public ItemStack getDropItemStack() {
        return this.dropItemStack.func_77946_l();
    }

    @NotNull
    public Cover createCover(@NotNull CoverableView coverableView, @NotNull EnumFacing side) {
        return this.coverCreator.create(this, coverableView, side);
    }

    @FunctionalInterface
    public static interface CoverCreator {
        @NotNull
        public Cover create(@NotNull CoverDefinition var1, @NotNull CoverableView var2, @NotNull EnumFacing var3);
    }
}

