/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.fluids;

import gregtech.api.GTValues;
import gregtech.api.unification.material.info.MaterialFlags;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTFluidBlock
extends BlockFluidClassic {
    private final boolean isFlammable;
    private final boolean isExplosive;
    private final boolean isSticky;
    @Nullable
    private gregtech.api.unification.material.Material gtMaterial;

    public GTFluidBlock(@NotNull Fluid fluid, @NotNull MaterialLiquid material, boolean isFlammable, boolean isExplosive, boolean isSticky) {
        super(fluid, (Material)material);
        this.isFlammable = isFlammable;
        this.isExplosive = isExplosive;
        this.isSticky = isSticky;
        boolean displaces = fluid.getDensity() > 1000;
        this.displacements.put(Blocks.field_150355_j, displaces);
        this.displacements.put(Blocks.field_150358_i, displaces);
        displaces = fluid.getDensity() > 3000;
        this.displacements.put(Blocks.field_150353_l, displaces);
        this.displacements.put(Blocks.field_150356_k, displaces);
    }

    public GTFluidBlock(@NotNull Fluid fluid, @NotNull MaterialLiquid material, @NotNull gregtech.api.unification.material.Material gtMaterial) {
        this(fluid, material, gtMaterial.hasFlag(MaterialFlags.FLAMMABLE), gtMaterial.hasFlag(MaterialFlags.EXPLOSIVE), gtMaterial.hasFlag(MaterialFlags.STICKY));
        this.gtMaterial = gtMaterial;
    }

    public boolean isFlammable() {
        return this.isFlammable;
    }

    public boolean isExplosive() {
        return this.isExplosive;
    }

    public boolean isSticky() {
        return this.isSticky;
    }

    @Nullable
    public gregtech.api.unification.material.Material getGtMaterial() {
        return this.gtMaterial;
    }

    @Nullable
    public Boolean isEntityInsideMaterial(@NotNull IBlockAccess world, @NotNull BlockPos blockpos, @NotNull IBlockState iblockstate, @NotNull Entity entity, double yToTest, @NotNull Material materialIn, boolean testingHead) {
        return materialIn == Material.field_151586_h ? Boolean.valueOf(true) : null;
    }

    public int getFireSpreadSpeed(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing face) {
        return this.isFlammable ? 5 : 0;
    }

    public boolean isFlammable(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing face) {
        return this.isFlammable;
    }

    public int getFlammability(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing face) {
        return this.isFlammable ? 200 : 0;
    }

    public void func_189540_a(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighbourPos) {
        super.func_189540_a(state, world, pos, neighborBlock, neighbourPos);
        if (this.isExplosive && this.isFlammable && neighborBlock instanceof BlockFire && GTValues.RNG.nextInt(5) == 0) {
            world.func_175698_g(pos);
            world.func_72876_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 1.5f, true);
        }
    }

    public void func_180634_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Entity entityIn) {
        if (this.isSticky) {
            if (entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).func_184812_l_()) {
                return;
            }
            entityIn.field_70159_w *= 0.5;
            entityIn.field_70181_x *= 0.25;
            entityIn.field_70179_y *= 0.5;
        }
    }

    public boolean canDisplace(@NotNull IBlockAccess world, @NotNull BlockPos pos) {
        if (this.isFlammable && world.func_180495_p(pos).func_185904_a() == Material.field_151581_o) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(@NotNull World world, @NotNull BlockPos pos) {
        if (this.isFlammable && world.func_180495_p(pos).func_185904_a() == Material.field_151581_o) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }
}

