/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.resources;

import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.picturetexture.AnimatedPictureTexture;
import gregtech.api.gui.resources.picturetexture.OrdinaryTexture;
import gregtech.api.gui.resources.picturetexture.PictureTexture;
import gregtech.api.gui.resources.utils.GifDecoder;
import gregtech.api.gui.resources.utils.ImageUtils;
import gregtech.api.gui.resources.utils.ProcessedImageData;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.compress.utils.IOUtils;

public class FileTexture
implements IGuiTexture {
    public final File file;
    @SideOnly(value=Side.CLIENT)
    private PictureTexture texture;
    @SideOnly(value=Side.CLIENT)
    private ProcessedImageData imageData;
    private Thread downloadThread;
    private boolean failed;

    public FileTexture(File file) {
        this.file = file;
    }

    @SideOnly(value=Side.CLIENT)
    public void loadFile() {
        if (this.imageData != null) {
            if (this.imageData.isAnimated()) {
                this.texture = new AnimatedPictureTexture(this.imageData);
                this.texture.tick();
            } else {
                this.texture = new OrdinaryTexture(this.imageData);
            }
            this.imageData = null;
            this.downloadThread = null;
        } else if (this.downloadThread == null) {
            this.downloadThread = new Thread(() -> {
                FileInputStream inputStream;
                block8: {
                    inputStream = null;
                    try {
                        inputStream = new FileInputStream(this.file);
                        String type = ImageUtils.readType(inputStream);
                        if (type.equalsIgnoreCase("gif")) {
                            GifDecoder gif = new GifDecoder();
                            inputStream.close();
                            inputStream = new FileInputStream(this.file);
                            int status = gif.read(inputStream);
                            if (status == 0) {
                                this.imageData = new ProcessedImageData(gif);
                            } else {
                                this.failed = true;
                            }
                            break block8;
                        }
                        inputStream.close();
                        inputStream = new FileInputStream(this.file);
                        BufferedImage image = ImageIO.read(inputStream);
                        if (image != null) {
                            this.imageData = new ProcessedImageData(image);
                            break block8;
                        }
                        this.failed = true;
                    }
                    catch (IOException e) {
                        try {
                            this.failed = true;
                            this.texture = null;
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(inputStream);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Closeable)inputStream);
                    }
                }
                IOUtils.closeQuietly((Closeable)inputStream);
            });
            this.downloadThread.start();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateTick() {
        if (this.texture != null) {
            this.texture.tick();
        }
    }

    @Override
    public void draw(double x, double y, int width, int height) {
        if (this.texture != null && this.texture.hasTexture()) {
            this.texture.render((float)x, (float)y, width, height, 0.0f, 1.0f, 1.0f, false, false);
        } else if (this.failed || this.file == null) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(I18n.func_135052_a((String)"texture.url_texture.fail", (Object[])new Object[0]), (int)x + 2, (int)(y + (double)height / 2.0 - 4.0), -65536);
        } else {
            this.loadFile();
            int s = (int)Math.floorMod(System.currentTimeMillis() / 200L, 24L);
            Widget.drawSector((float)(x + (double)width / 2.0), (float)(y + (double)height / 2.0), (float)((double)Math.min(width, height) / 4.0), -7019839, 24, s, s + 5);
        }
    }
}

