/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.GTValues;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IndicatorImageWidget
extends Widget {
    protected TextureArea normalTexture;
    protected TextureArea warningTexture;
    protected TextureArea errorTexture;
    protected Consumer<List<ITextComponent>> warningTextSupplier;
    private List<ITextComponent> warningText = new ArrayList<ITextComponent>();
    protected Consumer<List<ITextComponent>> errorTextSupplier;
    private List<ITextComponent> errorText = new ArrayList<ITextComponent>();

    public IndicatorImageWidget(int xPosition, int yPosition, int width, int height, TextureArea normalTexture) {
        super(new Position(xPosition, yPosition), new Size(width, height));
        this.normalTexture = normalTexture;
    }

    public IndicatorImageWidget setWarningStatus(TextureArea texture, Consumer<List<ITextComponent>> warningTextSupplier) {
        this.warningTexture = texture;
        this.warningTextSupplier = warningTextSupplier;
        return this;
    }

    public IndicatorImageWidget setErrorStatus(TextureArea texture, Consumer<List<ITextComponent>> errorTextSupplier) {
        this.errorTexture = texture;
        this.errorTextSupplier = errorTextSupplier;
        return this;
    }

    @Override
    public void detectAndSendChanges() {
        ArrayList<Object> textBuffer = new ArrayList<ITextComponent>();
        this.warningTextSupplier.accept(textBuffer);
        if (!this.warningText.equals(textBuffer)) {
            this.warningText = textBuffer;
            this.writeUpdateInfo(1, buffer -> {
                buffer.func_150787_b(this.warningText.size());
                for (ITextComponent component : this.warningText) {
                    buffer.func_180714_a(ITextComponent.Serializer.func_150696_a((ITextComponent)component));
                }
            });
        }
        textBuffer = new ArrayList();
        this.errorTextSupplier.accept(textBuffer);
        if (!this.errorText.equals(textBuffer)) {
            this.errorText = textBuffer;
            this.writeUpdateInfo(2, buffer -> {
                buffer.func_150787_b(this.errorText.size());
                for (ITextComponent component : this.errorText) {
                    buffer.func_180714_a(ITextComponent.Serializer.func_150696_a((ITextComponent)component));
                }
            });
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        block3: {
            block2: {
                if (id != 1) break block2;
                this.warningText.clear();
                int count = buffer.func_150792_a();
                for (int i = 0; i < count; ++i) {
                    String jsonText = buffer.func_150789_c(Short.MAX_VALUE);
                    this.warningText.add(ITextComponent.Serializer.func_150699_a((String)jsonText));
                }
                break block3;
            }
            if (id != 2) break block3;
            this.errorText.clear();
            int count = buffer.func_150792_a();
            for (int i = 0; i < count; ++i) {
                String jsonText = buffer.func_150789_c(Short.MAX_VALUE);
                this.errorText.add(ITextComponent.Serializer.func_150699_a((String)jsonText));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        double drawnV;
        Position pos = this.getPosition();
        Size size = this.getSize();
        double d = drawnV = GTValues.CLIENT_TIME / 20L % 2L == 0L ? 0.0 : 0.5;
        if (this.errorText != null && !this.errorText.isEmpty()) {
            this.errorTexture.drawSubArea(pos.x, pos.y, size.width, size.height, 0.0, drawnV, 1.0, 0.5);
        } else if (this.warningText != null && !this.warningText.isEmpty()) {
            this.warningTexture.drawSubArea(pos.x, pos.y, size.width, size.height, 0.0, drawnV, 1.0, 0.5);
        } else {
            this.normalTexture.draw(pos.x, pos.y, size.width, size.height);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            List<ITextComponent> displayText = null;
            if (this.errorText != null && !this.errorText.isEmpty()) {
                displayText = this.errorText;
            } else if (this.warningText != null && !this.warningText.isEmpty()) {
                displayText = this.warningText;
            }
            if (displayText != null) {
                ArrayList<String> hoverList = new ArrayList<String>();
                for (ITextComponent s : displayText) {
                    Collections.addAll(hoverList, s.func_150254_d());
                }
                if (!hoverList.isEmpty()) {
                    this.drawHoveringText(ItemStack.field_190927_a, hoverList, 300, mouseX, mouseY);
                }
            }
        }
    }
}

