/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import com.google.common.collect.Lists;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.ingredient.IGhostIngredientTarget;
import gregtech.api.gui.ingredient.IIngredientSlot;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.utils.RenderUtil;
import gregtech.client.utils.TooltipHelper;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class PhantomFluidWidget
extends Widget
implements IIngredientSlot,
IGhostIngredientTarget {
    private FluidTank fluidTank = null;
    protected IGuiTexture backgroundTexture = GuiTextures.FLUID_SLOT;
    private Supplier<FluidStack> fluidStackSupplier;
    private Consumer<FluidStack> fluidStackUpdater;
    private Supplier<Boolean> showTipSupplier;
    private boolean isClient;
    private boolean showTip;
    protected FluidStack lastFluidStack;

    public PhantomFluidWidget(int xPosition, int yPosition, int width, int height, Supplier<FluidStack> fluidStackSupplier, Consumer<FluidStack> fluidStackUpdater) {
        super(new Position(xPosition, yPosition), new Size(width, height));
        this.fluidStackSupplier = fluidStackSupplier;
        this.fluidStackUpdater = fluidStackUpdater;
    }

    public PhantomFluidWidget(int xPosition, int yPosition, int width, int height, FluidTank fluidTank) {
        super(new Position(xPosition, yPosition), new Size(width, height));
        this.fluidTank = fluidTank;
        this.fluidStackSupplier = () -> ((FluidTank)fluidTank).getFluid();
        this.fluidStackUpdater = arg_0 -> ((FluidTank)fluidTank).setFluid(arg_0);
    }

    public PhantomFluidWidget showTip(boolean showTip) {
        this.showTip = showTip;
        return this;
    }

    public PhantomFluidWidget showTipSupplier(Supplier<Boolean> showTipSupplier) {
        this.showTipSupplier = showTipSupplier;
        return this;
    }

    public PhantomFluidWidget setFluidStackSupplier(Supplier<FluidStack> fluidStackSupplier, boolean isClient) {
        this.fluidStackSupplier = fluidStackSupplier;
        this.isClient = isClient;
        return this;
    }

    public PhantomFluidWidget setFluidStackUpdater(Consumer<FluidStack> fluidStackUpdater, boolean isClient) {
        this.fluidStackUpdater = fluidStackUpdater;
        this.isClient = isClient;
        return this;
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        if (!(ingredient instanceof FluidStack) && GTUtility.getFluidFromContainer(ingredient) == null) {
            return Collections.emptyList();
        }
        final Rectangle rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new IGhostIngredientHandler.Target[]{new IGhostIngredientHandler.Target<Object>(){

            @NotNull
            public Rectangle getArea() {
                return rectangle;
            }

            public void accept(@NotNull Object ingredient) {
                FluidStack ingredientStack = ingredient instanceof FluidStack ? (FluidStack)ingredient : GTUtility.getFluidFromContainer(ingredient);
                if (ingredientStack != null) {
                    NBTTagCompound tagCompound = ingredientStack.writeToNBT(new NBTTagCompound());
                    PhantomFluidWidget.this.writeClientAction(2, buffer -> buffer.func_150786_a(tagCompound));
                }
                if (PhantomFluidWidget.this.isClient && PhantomFluidWidget.this.fluidStackUpdater != null) {
                    PhantomFluidWidget.this.fluidStackUpdater.accept(ingredientStack);
                }
            }
        }});
    }

    @Override
    public Object getIngredientOverMouse(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            return this.lastFluidStack;
        }
        return null;
    }

    public PhantomFluidWidget setBackgroundTexture(IGuiTexture backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.isClient && this.fluidStackSupplier != null) {
            this.lastFluidStack = this.fluidStackSupplier.get();
        }
    }

    @Override
    public void detectAndSendChanges() {
        FluidStack currentStack = this.fluidStackSupplier.get();
        if (currentStack == null && this.lastFluidStack != null) {
            this.lastFluidStack = null;
            this.writeUpdateInfo(1, buffer -> buffer.writeBoolean(false));
        } else if (currentStack != null && !currentStack.isFluidStackIdentical(this.lastFluidStack)) {
            this.lastFluidStack = currentStack;
            this.writeUpdateInfo(1, buffer -> {
                buffer.writeBoolean(true);
                buffer.func_150786_a(currentStack.writeToNBT(new NBTTagCompound()));
            });
        }
        if (this.showTipSupplier != null && this.showTip != this.showTipSupplier.get()) {
            this.showTip = this.showTipSupplier.get();
            this.writeUpdateInfo(2, buffer -> buffer.writeBoolean(this.showTip));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 1) {
            if (buffer.readBoolean()) {
                try {
                    NBTTagCompound tagCompound = buffer.func_150793_b();
                    this.lastFluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound);
                }
                catch (IOException e) {
                    GTLog.logger.error("Could not read NBT from PhantomFluidWidget buffer", (Throwable)e);
                }
            } else {
                this.lastFluidStack = null;
            }
        } else if (id == 2) {
            this.showTip = buffer.readBoolean();
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 1) {
            Widget.ClickData clickData = Widget.ClickData.readFromBuf(buffer);
            ItemStack itemStack = this.gui.entityPlayer.field_71071_by.func_70445_o().func_77946_l();
            if (!itemStack.func_190926_b()) {
                itemStack.func_190920_e(1);
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (fluidHandler != null) {
                    FluidStack resultFluid = fluidHandler.drain(Integer.MAX_VALUE, false);
                    this.fluidStackUpdater.accept(resultFluid);
                }
            } else if (this.showTip) {
                if (clickData.button == 2) {
                    this.fluidStackUpdater.accept(null);
                } else if (clickData.button == 0) {
                    if (this.fluidStackSupplier.get() != null) {
                        FluidStack fluid = this.fluidStackSupplier.get().copy();
                        fluid.amount = clickData.isShiftClick ? (fluid.amount + 1) / 2 : --fluid.amount;
                        if (fluid.amount < 0) {
                            fluid.amount = 0x3FFFFFFF;
                        }
                        fluid.amount = MathHelper.func_76125_a((int)fluid.amount, (int)1, (int)this.fluidTank.getCapacity());
                        this.fluidStackUpdater.accept(fluid);
                    }
                } else if (clickData.button == 1 && this.fluidStackSupplier.get() != null) {
                    FluidStack fluid = this.fluidStackSupplier.get().copy();
                    fluid.amount = clickData.isShiftClick ? (fluid.amount *= 2) : ++fluid.amount;
                    if (fluid.amount < 0) {
                        fluid.amount = Integer.MAX_VALUE;
                    }
                    fluid.amount = MathHelper.func_76125_a((int)fluid.amount, (int)1, (int)this.fluidTank.getCapacity());
                    this.fluidStackUpdater.accept(fluid);
                }
            } else {
                this.fluidStackUpdater.accept(null);
            }
        } else if (id == 2) {
            FluidStack fluidStack;
            try {
                fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer.func_150793_b());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.fluidStackUpdater.accept(fluidStack);
        } else if (id == 3) {
            Widget.WheelData wheelData = Widget.WheelData.readFromBuf(buffer);
            if (this.fluidStackSupplier.get() != null && this.fluidStackUpdater != null && this.showTip) {
                int multiplier = wheelData.isCtrlClick ? 100 : 1;
                int n = wheelData.isShiftClick ? 10 : 1;
                FluidStack currentFluid = this.fluidStackSupplier.get().copy();
                int amount = wheelData.wheelDelta * (multiplier *= n);
                currentFluid.amount = MathHelper.func_76125_a((int)(currentFluid.amount + amount), (int)1, (int)this.fluidTank.getCapacity());
                this.fluidStackUpdater.accept(currentFluid);
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            Widget.ClickData clickData = new Widget.ClickData(button, TooltipHelper.isShiftDown(), TooltipHelper.isCtrlDown(), true);
            this.writeClientAction(1, clickData::writeToBuf);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (this.showTip) {
                Widget.WheelData wheelData = new Widget.WheelData(MathHelper.func_76125_a((int)wheelDelta, (int)-1, (int)1), TooltipHelper.isShiftDown(), TooltipHelper.isCtrlDown(), true);
                this.writeClientAction(3, wheelData::writeToBuf);
            }
            return true;
        }
        return false;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.backgroundTexture != null) {
            this.backgroundTexture.draw(pos.x, pos.y, size.width, size.height);
        }
        if (this.lastFluidStack != null) {
            GlStateManager.func_179084_k();
            RenderUtil.drawFluidForGui(this.lastFluidStack, this.lastFluidStack.amount, pos.x + 1, pos.y + 1, size.width - 1, size.height - 1);
            if (this.showTip) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
                String s = TextFormattingUtil.formatLongToCompactString(this.lastFluidStack.amount, 4) + "L";
                FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                fontRenderer.func_175063_a(s, ((float)pos.x + (float)size.width / 3.0f) * 2.0f - (float)fontRenderer.func_78256_a(s) + 21.0f, ((float)pos.y + (float)size.height / 3.0f + 6.0f) * 2.0f, 0xFFFFFF);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179147_l();
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.lastFluidStack != null) {
            String fluidName = this.lastFluidStack.getLocalizedName();
            ArrayList<String> hoverStringList = new ArrayList<String>();
            hoverStringList.add(fluidName);
            if (this.showTip) {
                hoverStringList.add(this.lastFluidStack.amount + " L");
                Collections.addAll(hoverStringList, LocalizationUtils.formatLines("cover.fluid_filter.config_amount", new Object[0]));
            }
            this.drawHoveringText(ItemStack.field_190927_a, hoverStringList, -1, mouseX, mouseY);
        }
    }
}

