/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.toolitem;

import com.google.common.collect.Multimap;
import gregtech.api.GregTechAPI;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.items.toolitem.IGTToolDefinition;
import gregtech.api.items.toolitem.ToolBuilder;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.util.LocalizationUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemGTTool
extends ItemTool
implements IGTTool {
    protected final String domain;
    protected final String id;
    protected final int tier;
    protected final IGTToolDefinition toolStats;
    protected final Set<String> toolClasses;
    protected final String oreDict;
    protected final List<String> secondaryOreDicts;
    protected final SoundEvent sound;
    protected final boolean playSoundOnBlockDestroy;
    protected final Supplier<ItemStack> markerItem;

    protected ItemGTTool(String domain, String id, int tier, IGTToolDefinition toolStats, SoundEvent sound, boolean playSoundOnBlockDestroy, Set<String> toolClasses, String oreDict, List<String> secondaryOreDicts, Supplier<ItemStack> markerItem) {
        super(0.0f, 0.0f, Item.ToolMaterial.STONE, Collections.emptySet());
        this.domain = domain;
        this.id = id;
        this.tier = tier;
        this.toolStats = toolStats;
        this.sound = sound;
        this.playSoundOnBlockDestroy = playSoundOnBlockDestroy;
        this.toolClasses = Collections.unmodifiableSet(toolClasses);
        this.oreDict = oreDict;
        this.secondaryOreDicts = secondaryOreDicts;
        this.markerItem = markerItem;
        this.func_77625_d(1);
        this.func_77637_a(GregTechAPI.TAB_GREGTECH_TOOLS);
        this.func_77655_b("gt.tool." + id + ".name");
        this.setRegistryName(domain, id);
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getToolId() {
        return this.id;
    }

    @Override
    public boolean isElectric() {
        return this.tier > -1;
    }

    @Override
    public int getElectricTier() {
        return this.tier;
    }

    @Override
    public IGTToolDefinition getToolStats() {
        return this.toolStats;
    }

    @Override
    @Nullable
    public SoundEvent getSound() {
        return this.sound;
    }

    @Override
    public boolean playSoundOnBlockDestroy() {
        return this.playSoundOnBlockDestroy;
    }

    @Override
    public String getOreDictName() {
        return this.oreDict;
    }

    @Override
    @NotNull
    public List<String> getSecondaryOreDicts() {
        return this.secondaryOreDicts;
    }

    @Override
    @Nullable
    public Supplier<ItemStack> getMarkerItem() {
        return this.markerItem;
    }

    public void func_150895_a(@NotNull CreativeTabs tab, @NotNull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            this.definition$getSubItems(items);
        }
    }

    @NotNull
    public String func_77653_i(@NotNull ItemStack stack) {
        return LocalizationUtils.format(this.func_77658_a(), this.getToolMaterial(stack).getLocalizedName());
    }

    public float func_150893_a(@NotNull ItemStack stack, @NotNull IBlockState state) {
        return this.definition$getDestroySpeed(stack, state);
    }

    public boolean func_77644_a(@NotNull ItemStack stack, @NotNull EntityLivingBase target, @NotNull EntityLivingBase attacker) {
        return this.definition$hitEntity(stack, target, attacker);
    }

    public boolean onBlockStartBreak(@NotNull ItemStack itemstack, @NotNull BlockPos pos, @NotNull EntityPlayer player) {
        return this.definition$onBlockStartBreak(itemstack, pos, player);
    }

    public boolean func_179218_a(@NotNull ItemStack stack, @NotNull World worldIn, @NotNull IBlockState state, @NotNull BlockPos pos, @NotNull EntityLivingBase entityLiving) {
        return this.definition$onBlockDestroyed(stack, worldIn, state, pos, entityLiving);
    }

    public int getItemEnchantability(@NotNull ItemStack stack) {
        return this.getTotalEnchantability(stack);
    }

    public boolean func_82789_a(@NotNull ItemStack toRepair, @NotNull ItemStack repair) {
        return this.definition$getIsRepairable(toRepair, repair);
    }

    @NotNull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@NotNull EntityEquipmentSlot slot, @NotNull ItemStack stack) {
        return this.definition$getAttributeModifiers(slot, stack);
    }

    public int getHarvestLevel(@NotNull ItemStack stack, @NotNull String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        return this.definition$getHarvestLevel(stack, toolClass, player, blockState);
    }

    @Override
    @NotNull
    public Set<String> getToolClasses(@NotNull ItemStack stack) {
        return this.toolClasses;
    }

    public boolean canDisableShield(@NotNull ItemStack stack, @NotNull ItemStack shield, @NotNull EntityLivingBase entity, @NotNull EntityLivingBase attacker) {
        return this.definition$canDisableShield(stack, shield, entity, attacker);
    }

    public boolean doesSneakBypassUse(@NotNull ItemStack stack, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityPlayer player) {
        return this.definition$doesSneakBypassUse(stack, world, pos, player);
    }

    public boolean shouldCauseBlockBreakReset(@NotNull ItemStack oldStack, @NotNull ItemStack newStack) {
        return this.definition$shouldCauseBlockBreakReset(oldStack, newStack);
    }

    public boolean hasContainerItem(@NotNull ItemStack stack) {
        return this.definition$hasContainerItem(stack);
    }

    @NotNull
    public ItemStack getContainerItem(@NotNull ItemStack stack) {
        return this.definition$getContainerItem(stack);
    }

    public boolean onEntitySwing(@NotNull EntityLivingBase entityLiving, @NotNull ItemStack stack) {
        return this.definition$onEntitySwing(entityLiving, stack);
    }

    public boolean canDestroyBlockInCreative(@NotNull World world, @NotNull BlockPos pos, @NotNull ItemStack stack, @NotNull EntityPlayer player) {
        return this.definition$canDestroyBlockInCreative(world, pos, stack, player);
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        return this.definition$shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean isDamaged(@NotNull ItemStack stack) {
        return this.definition$isDamaged(stack);
    }

    public int getDamage(@NotNull ItemStack stack) {
        return this.definition$getDamage(stack);
    }

    public int getMaxDamage(@NotNull ItemStack stack) {
        return this.definition$getMaxDamage(stack);
    }

    public void setDamage(@NotNull ItemStack stack, int damage) {
        this.definition$setDamage(stack, damage);
    }

    public boolean showDurabilityBar(@NotNull ItemStack stack) {
        return false;
    }

    public double getDurabilityForDisplay(@NotNull ItemStack stack) {
        return this.definition$getDurabilityForDisplay(stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return this.definition$initCapabilities(stack, nbt);
    }

    @NotNull
    public EnumActionResult onItemUseFirst(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing side, float hitX, float hitY, float hitZ, @NotNull EnumHand hand) {
        return this.definition$onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    @NotNull
    public EnumActionResult func_180614_a(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.definition$onItemUse(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        return this.definition$onItemRightClick(world, player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        this.definition$addInformation(stack, world, tooltip, flag);
    }

    public boolean canApplyAtEnchantingTable(@NotNull ItemStack stack, @NotNull Enchantment enchantment) {
        return this.definition$canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean canHarvestBlock(@NotNull IBlockState state, @NotNull ItemStack stack) {
        return ToolHelper.isToolEffective(state, this.getToolClasses(stack), this.getTotalHarvestLevel(stack));
    }

    public static class Builder
    extends ToolBuilder<ItemGTTool> {
        @NotNull
        public static Builder of(@NotNull String domain, @NotNull String id) {
            return new Builder(domain, id);
        }

        public Builder(@NotNull String domain, @NotNull String id) {
            super(domain, id);
        }

        @Override
        public Supplier<ItemGTTool> supply() {
            return () -> new ItemGTTool(this.domain, this.id, this.tier, this.toolStats, this.sound, this.playSoundOnBlockDestroy, this.toolClasses, this.oreDict, this.secondaryOreDicts, this.markerItem);
        }
    }
}

