/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock;

import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.MultiblockFuelRecipeLogic;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract class FuelMultiblockController
extends RecipeMapMultiblockController {
    public FuelMultiblockController(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, int tier) {
        super(metaTileEntityId, recipeMap);
        this.recipeMapWorkable = new MultiblockFuelRecipeLogic(this);
        this.recipeMapWorkable.setMaximumOverclockVoltage(GTValues.V[tier]);
    }

    @Override
    protected void initializeAbilities() {
        super.initializeAbilities();
        this.energyContainer = new EnergyContainerList(this.getAbilities(MultiblockAbility.OUTPUT_ENERGY));
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockFuelRecipeLogic recipeLogic = (MultiblockFuelRecipeLogic)this.recipeMapWorkable;
        MultiblockDisplayText.builder(textList, this.isStructureFormed()).setWorkingStatus(recipeLogic.isWorkingEnabled(), recipeLogic.isActive()).addEnergyProductionLine(this.getMaxVoltage(), recipeLogic.getRecipeEUt()).addFuelNeededLine(recipeLogic.getRecipeFluidInputInfo(), recipeLogic.getPreviousRecipeDuration()).addWorkingStatusLine();
    }

    protected long getMaxVoltage() {
        IEnergyContainer energyContainer = this.recipeMapWorkable.getEnergyContainer();
        if (energyContainer != null && energyContainer.getEnergyCapacity() > 0L) {
            return Math.max(energyContainer.getInputVoltage(), energyContainer.getOutputVoltage());
        }
        return 0L;
    }

    @Override
    protected void addWarningText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, this.isStructureFormed(), false).addLowDynamoTierLine(this.isDynamoTierTooLow()).addMaintenanceProblemLines(this.getMaintenanceProblems());
    }

    protected boolean isDynamoTierTooLow() {
        IEnergyContainer energyContainer;
        if (this.isStructureFormed() && (energyContainer = this.recipeMapWorkable.getEnergyContainer()) != null && energyContainer.getEnergyCapacity() > 0L) {
            long maxVoltage = Math.max(energyContainer.getInputVoltage(), energyContainer.getOutputVoltage());
            return maxVoltage < (long)(-this.recipeMapWorkable.getRecipeEUt());
        }
        return false;
    }

    @Override
    @NotNull
    public List<ITextComponent> getDataInfo() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (this.recipeMapWorkable.getMaxProgress() > 0) {
            list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.workable_progress", new Object[]{new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.recipeMapWorkable.getProgress() / 20), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.recipeMapWorkable.getMaxProgress() / 20), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}));
        }
        list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.energy_container_storage", new Object[]{new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.energyContainer.getEnergyStored()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.energyContainer.getEnergyCapacity()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}));
        if (!this.recipeMapWorkable.consumesEnergy()) {
            list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.workable_production", new Object[]{new TextComponentTranslation(TextFormattingUtil.formatNumbers(Math.abs(this.recipeMapWorkable.getInfoProviderEUt())), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.recipeMapWorkable.getInfoProviderEUt() == 0 ? 0L : 1L), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
            list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.multiblock_energy_output", new Object[]{new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.energyContainer.getOutputVoltage()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)), new TextComponentTranslation(GTValues.VN[GTUtility.getTierByVoltage(this.energyContainer.getOutputVoltage())], new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}));
        }
        if (ConfigHolder.machines.enableMaintenance && this.hasMaintenanceMechanics()) {
            list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.multiblock_maintenance", new Object[]{new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.getNumMaintenanceProblems()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
        }
        return list;
    }

    protected int[] getTotalFluidAmount(FluidStack testStack, IMultipleTankHandler multiTank) {
        int fluidAmount = 0;
        int fluidCapacity = 0;
        for (IMultipleTankHandler.MultiFluidTankEntry tank : multiTank) {
            FluidStack drainStack;
            if (tank == null || (drainStack = tank.drain(testStack, false)) == null || drainStack.amount <= 0) continue;
            fluidAmount += drainStack.amount;
            fluidCapacity += tank.getCapacity();
        }
        return new int[]{fluidAmount, fluidCapacity};
    }

    protected void addFuelText(List<ITextComponent> textList) {
        int fuelStored = 0;
        int fuelCapacity = 0;
        FluidStack fuelStack = null;
        MultiblockFuelRecipeLogic recipeLogic = (MultiblockFuelRecipeLogic)this.recipeMapWorkable;
        if (this.isStructureFormed() && recipeLogic.getInputFluidStack() != null && this.getInputFluidInventory() != null) {
            fuelStack = recipeLogic.getInputFluidStack().copy();
            fuelStack.amount = Integer.MAX_VALUE;
            int[] fuelAmount = this.getTotalFluidAmount(fuelStack, this.getInputFluidInventory());
            fuelStored = fuelAmount[0];
            fuelCapacity = fuelAmount[1];
        }
        if (fuelStack != null) {
            ITextComponent fuelName = TextComponentUtil.setColor((ITextComponent)GTUtility.getFluidTranslation(fuelStack), TextFormatting.GOLD);
            TextComponentTranslation fuelInfo = new TextComponentTranslation("%s / %s L (%s)", new Object[]{TextFormattingUtil.formatNumbers(fuelStored), TextFormattingUtil.formatNumbers(fuelCapacity), fuelName});
            textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.large_combustion_engine.fuel_amount", TextComponentUtil.setColor((ITextComponent)fuelInfo, TextFormatting.GOLD)));
        } else {
            textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.large_combustion_engine.fuel_amount", "0 / 0 L"));
        }
    }
}

