/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.persistence;

import gregtech.api.util.GTLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistentData {
    private static final PersistentData INSTANCE = new PersistentData();
    @Nullable
    private Path path;
    @Nullable
    private NBTTagCompound tag;

    @NotNull
    public static PersistentData instance() {
        return INSTANCE;
    }

    private PersistentData() {
    }

    @ApiStatus.Internal
    public void init() {
        this.path = Loader.instance().getConfigDir().toPath().resolve("gregtech").resolve("persistent_data.dat");
    }

    @NotNull
    public synchronized NBTTagCompound getTag() {
        if (this.tag == null) {
            this.tag = this.read();
        }
        return this.tag;
    }

    @NotNull
    private NBTTagCompound read() {
        NBTTagCompound nBTTagCompound;
        block10: {
            GTLog.logger.debug("Reading persistent data from path {}", (Object)this.path);
            if (this.path == null) {
                throw new IllegalStateException("Persistent data path cannot be null");
            }
            if (!Files.exists(this.path, new LinkOption[0])) {
                return new NBTTagCompound();
            }
            InputStream inputStream = Files.newInputStream(this.path, new OpenOption[0]);
            try {
                nBTTagCompound = CompressedStreamTools.func_74796_a((InputStream)inputStream);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    GTLog.logger.error("Failed to read persistent data", (Throwable)e);
                    return new NBTTagCompound();
                }
            }
            inputStream.close();
        }
        return nBTTagCompound;
    }

    public synchronized void save() {
        if (this.tag != null) {
            this.write(this.tag);
        }
    }

    private void write(@NotNull NBTTagCompound tagCompound) {
        GTLog.logger.debug("Writing persistent data to path {}", (Object)this.path);
        if (tagCompound.func_82582_d()) {
            return;
        }
        if (this.path == null) {
            throw new IllegalStateException("Persistent data path cannot be null");
        }
        if (!Files.exists(this.path, new LinkOption[0])) {
            try {
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                GTLog.logger.error("Could not create persistent data dir", (Throwable)e);
                return;
            }
        }
        try (OutputStream outputStream = Files.newOutputStream(this.path, new OpenOption[0]);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)tagCompound, (OutputStream)outputStream);
        }
        catch (IOException e) {
            GTLog.logger.error("Failed to write persistent data", (Throwable)e);
        }
    }
}

