/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTLog;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GTRecipeHandler {
    public static <R extends RecipeBuilder<R>> boolean removeRecipesByInputs(RecipeMap<R> map, ItemStack[] itemInputs, FluidStack[] fluidInputs) {
        boolean wasRemoved;
        ArrayList<String> fluidNames = new ArrayList<String>();
        ArrayList<String> itemNames = new ArrayList<String>();
        ArrayList<ItemStack> itemIn = new ArrayList<ItemStack>();
        for (ItemStack s : itemInputs) {
            itemIn.add(s);
            if (!ConfigHolder.misc.debug) continue;
            itemNames.add(String.format("%s x %d", s.func_82833_r(), s.func_190916_E()));
        }
        ArrayList<FluidStack> fluidIn = new ArrayList<FluidStack>();
        for (FluidStack s : fluidInputs) {
            fluidIn.add(s);
            if (!ConfigHolder.misc.debug) continue;
            fluidNames.add(String.format("%s x %d", s.getFluid().getName(), s.amount));
        }
        Recipe recipeFound = map.findRecipe(Long.MAX_VALUE, itemIn, fluidIn);
        boolean bl = wasRemoved = recipeFound != null && map.removeRecipe(recipeFound);
        if (ConfigHolder.misc.debug) {
            if (wasRemoved) {
                GTLog.logger.info("Removed Recipe for inputs: Items: {} Fluids: {}", itemNames, fluidNames);
            } else {
                GTLog.logger.error("Failed to Remove Recipe for inputs: Items: {} Fluids: {}", itemNames, fluidNames);
            }
        }
        return wasRemoved;
    }

    public static <R extends RecipeBuilder<R>> boolean removeRecipesByInputs(RecipeMap<R> map, ItemStack ... itemInputs) {
        return GTRecipeHandler.removeRecipesByInputs(map, itemInputs, new FluidStack[0]);
    }

    public static <R extends RecipeBuilder<R>> boolean removeRecipesByInputs(RecipeMap<R> map, FluidStack ... fluidInputs) {
        return GTRecipeHandler.removeRecipesByInputs(map, new ItemStack[0], fluidInputs);
    }

    public static <R extends RecipeBuilder<R>> void removeAllRecipes(RecipeMap<R> map) {
        map.removeAllRecipes();
        if (ConfigHolder.misc.debug) {
            GTLog.logger.info("Removed all recipes for Recipe Map: {}", (Object)map.unlocalizedName);
        }
    }
}

