/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import gregtech.api.GTValues;
import gregtech.api.persistence.PersistentData;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.util.GTLog;
import gregtech.common.ConfigHolder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class GTRecipeInputCache {
    private static final int MINIMUM_CACHE_SIZE = 8192;
    private static final int MAXIMUM_CACHE_SIZE = 0x40000000;
    private static ObjectOpenHashSet<GTRecipeInput> instances;
    private static final String DATA_NAME = "expectedIngredientInstances";

    private GTRecipeInputCache() {
    }

    public static boolean isCacheEnabled() {
        return instances != null;
    }

    @ApiStatus.Internal
    public static void enableCache() {
        if (!GTRecipeInputCache.isCacheEnabled()) {
            int size = GTRecipeInputCache.calculateOptimalExpectedSize();
            instances = new ObjectOpenHashSet(size);
            if (ConfigHolder.misc.debug || GTValues.isDeobfEnvironment()) {
                GTLog.logger.info("GTRecipeInput cache enabled with expected size {}", (Object)size);
            }
        }
    }

    @ApiStatus.Internal
    public static void disableCache() {
        if (GTRecipeInputCache.isCacheEnabled()) {
            NBTTagCompound tagCompound;
            int size = instances.size();
            if (ConfigHolder.misc.debug || GTValues.isDeobfEnvironment()) {
                GTLog.logger.info("GTRecipeInput cache disabled; releasing {} unique instances", (Object)size);
            }
            instances = null;
            if (size >= 8192 && size < 0x40000000 && GTRecipeInputCache.getExpectedInstanceAmount(tagCompound = PersistentData.instance().getTag()) != size) {
                tagCompound.func_74768_a(DATA_NAME, size);
                PersistentData.instance().save();
            }
        }
    }

    private static int getExpectedInstanceAmount(@NotNull NBTTagCompound tagCompound) {
        return MathHelper.func_76125_a((int)tagCompound.func_74762_e(DATA_NAME), (int)8192, (int)0x40000000);
    }

    public static GTRecipeInput deduplicate(GTRecipeInput recipeInput) {
        if (!GTRecipeInputCache.isCacheEnabled() || recipeInput.isCached()) {
            return recipeInput;
        }
        GTRecipeInput cached = (GTRecipeInput)instances.addOrGet((Object)recipeInput);
        if (cached == recipeInput) {
            cached.setCached();
        }
        return cached;
    }

    public static List<GTRecipeInput> deduplicateInputs(List<GTRecipeInput> inputs) {
        if (!GTRecipeInputCache.isCacheEnabled()) {
            return inputs;
        }
        if (inputs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GTRecipeInput> list = new ArrayList<GTRecipeInput>(inputs.size());
        for (GTRecipeInput input : inputs) {
            list.add(GTRecipeInputCache.deduplicate(input));
        }
        return list;
    }

    private static int calculateOptimalExpectedSize() {
        int min = Math.max(GTRecipeInputCache.getExpectedInstanceAmount(PersistentData.instance().getTag()), 8192);
        for (int i = 13; i < 31; ++i) {
            int sizeToTest = 1 << i;
            int arraySize = GTRecipeInputCache.nextHighestPowerOf2((int)((float)sizeToTest / 0.75f));
            int maxStoredBeforeRehash = (int)((float)arraySize * 0.75f);
            if (maxStoredBeforeRehash < min) continue;
            return sizeToTest;
        }
        return 8192;
    }

    private static int nextHighestPowerOf2(int x) {
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return ++x;
    }
}

