/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification;

import gregtech.api.unification.material.Material;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class FluidUnifier {
    private static final Map<Fluid, Material> fluidToMaterial = new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<Fluid>(){

        public int hashCode(@Nullable Fluid o) {
            return o == null ? 0 : o.getName().hashCode();
        }

        public boolean equals(@Nullable Fluid a, @Nullable Fluid b) {
            return Objects.equals(a == null ? null : a.getName(), b == null ? null : b.getName());
        }
    });

    private FluidUnifier() {
    }

    @ApiStatus.Experimental
    public static void registerFluid(@NotNull Fluid fluid, @NotNull Material material) {
        fluidToMaterial.put(fluid, material);
    }

    @ApiStatus.Experimental
    @Nullable
    public static Material getMaterialFromFluid(@NotNull Fluid fluid) {
        return fluidToMaterial.get(fluid);
    }
}

